/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AckBatchSizeTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");

    private int getMessageEncodeSize(SimpleString address) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientMessage message = session.createMessage(false);
        message.setAddress(address);
        int encodeSize = message.getEncodeSize();
        session.close();
        cf.close();
        return encodeSize;
    }

    @Test
    public void testAckBatchSize() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        int numMessages = 100;
        int originalSize = this.getMessageEncodeSize(this.addressA);
        ServerLocator locator = this.createInVMNonHALocator().setAckBatchSize(numMessages * originalSize).setBlockOnAcknowledge(true);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = (ClientMessage)sendSession.createMessage(false).setAddress(this.addressA);
            Assert.assertEquals((long)originalSize, (long)message.getEncodeSize());
            cp.send((Message)message);
            Assert.assertEquals((long)originalSize, (long)message.getEncodeSize());
        }
        ClientConsumer consumer = session.createConsumer(this.queueA);
        session.start();
        for (int i = 0; i < numMessages - 1; ++i) {
            this.instanceLog.debug((Object)"Receive ");
            ClientMessage m = consumer.receive(5000L);
            Assert.assertEquals((long)0L, (long)m.getPropertyNames().size());
            Assert.assertEquals((String)("expected to be " + originalSize), (long)originalSize, (long)m.getEncodeSize());
            m.acknowledge();
        }
        ClientMessage m = consumer.receive(5000L);
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assert.assertEquals((long)numMessages, (long)q.getDeliveringCount());
        m.acknowledge();
        Assert.assertEquals((long)0L, (long)q.getDeliveringCount());
        sendSession.close();
        session.close();
    }

    @Test
    public void testAckBatchSizeZero() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setAckBatchSize(0).setBlockOnAcknowledge(true);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        int numMessages = 100;
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        for (int i2 = 0; i2 < numMessages; ++i2) {
            cp.send((Message)sendSession.createMessage(false));
        }
        ClientConsumer consumer = session.createConsumer(this.queueA);
        session.start();
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        ClientMessage[] messages = new ClientMessage[numMessages];
        for (i = 0; i < numMessages; ++i) {
            messages[i] = consumer.receive(5000L);
            Assert.assertNotNull((Object)messages[i]);
        }
        for (i = 0; i < numMessages; ++i) {
            messages[i].acknowledge();
            Assert.assertEquals((long)(numMessages - i - 1), (long)q.getDeliveringCount());
        }
        sendSession.close();
        session.close();
    }
}

