/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSSharedConsumerTest
extends JMSClientTestSupport {
    @Parameterized.Parameter(value=0)
    public boolean amqpUseCoreSubscriptionNaming;

    @Parameterized.Parameters(name="{index}: amqpUseCoreSubscriptionNaming={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setAmqpUseCoreSubscriptionNaming(this.amqpUseCoreSubscriptionNaming);
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    private void testSharedConsumer(Connection connection1, Connection connection2) throws Exception {
        this.testSharedConsumer(connection1, connection2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSharedConsumer(Connection connection1, Connection connection2, boolean amqpQueueName) throws Exception {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Topic topic = session1.createTopic(this.getTopicName());
            Topic topic2 = session2.createTopic(this.getTopicName());
            MessageConsumer consumer1 = session1.createSharedConsumer(topic, "SharedConsumer");
            MessageConsumer consumer2 = session2.createSharedConsumer(topic2, "SharedConsumer");
            MessageProducer producer = session1.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message message1 = consumer1.receive(100L);
            Message message2 = consumer2.receive(100L);
            Message received = null;
            if (message1 != null) {
                JMSSharedConsumerTest.assertNull((String)"Message should only be delivered once per subscribtion but see twice", (Object)message2);
                received = message1;
            } else {
                received = message2;
            }
            JMSSharedConsumerTest.assertNotNull((String)"Should have received a message by now.", (Object)received);
            JMSSharedConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(received instanceof TextMessage));
            String consumerQueueName = "nonDurable.SharedConsumer";
            if (amqpQueueName) {
                consumerQueueName = "SharedConsumer:shared-volatile:global";
            }
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)consumerQueueName));
            JMSSharedConsumerTest.assertTrue((boolean)queueBinding.getQueue().isTemporary());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    @Test(timeout=30000L)
    public void testSharedConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        this.testSharedConsumer(connection, connection2, !this.amqpUseCoreSubscriptionNaming);
    }

    @Test(timeout=30000L)
    public void testSharedConsumerWithArtemisClient() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createCoreConnection();
        this.testSharedConsumer(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testSharedConsumerWithAMQPClientAndArtemisClient() throws Exception {
        Assume.assumeTrue((boolean)this.amqpUseCoreSubscriptionNaming);
        Connection connection = this.createConnection();
        Connection connection2 = this.createCoreConnection();
        this.testSharedConsumer(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testSharedConsumerWithArtemisClientAndAMQPClient() throws Exception {
        Assume.assumeTrue((boolean)this.amqpUseCoreSubscriptionNaming);
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createConnection();
        this.testSharedConsumer(connection, connection2);
    }
}

