/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Assert;
import org.junit.Test;

public class GlobalDiskFullTest
extends AmqpClientTestSupport {
    @Override
    protected void addConfiguration(ActiveMQServer server) {
        Configuration serverConfig = server.getConfiguration();
        serverConfig.setDiskScanPeriod(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProducerOnDiskFull() throws Exception {
        FileStoreMonitor monitor = ((ActiveMQServerImpl)this.server).getMonitor().setMaxUsage(0.0);
        final CountDownLatch latch = new CountDownLatch(1);
        monitor.addCallback(new FileStoreMonitor.Callback(){

            public void tick(long usableSpace, long totalSpace) {
            }

            public void over(long usableSpace, long totalSpace) {
                latch.countDown();
            }

            public void under(long usableSpace, long totalSpace) {
            }
        });
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        AmqpClient client = this.createAmqpClient(new URI("tcp://localhost:5672"));
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            final AmqpSender sender = session.createSender(this.getQueueName());
            final byte[] payload = new byte[1000];
            final AmqpSender anonSender = session.createSender();
            final CountDownLatch sentWithName = new CountDownLatch(1);
            final CountDownLatch sentAnon = new CountDownLatch(1);
            Thread threadWithName = new Thread(){

                @Override
                public void run() {
                    try {
                        AmqpMessage message = new AmqpMessage();
                        message.setBytes(payload);
                        sender.setSendTimeout(-1L);
                        sender.send(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        sentWithName.countDown();
                    }
                }
            };
            threadWithName.start();
            Thread threadWithAnon = new Thread(){

                @Override
                public void run() {
                    try {
                        AmqpMessage message = new AmqpMessage();
                        message.setBytes(payload);
                        anonSender.setSendTimeout(-1L);
                        message.setAddress(GlobalDiskFullTest.this.getQueueName());
                        anonSender.send(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        sentAnon.countDown();
                    }
                }
            };
            threadWithAnon.start();
            Assert.assertFalse((String)"Thread sender should be blocked", (boolean)sentWithName.await(500L, TimeUnit.MILLISECONDS));
            Assert.assertFalse((String)"Thread sender anonymous should be blocked", (boolean)sentAnon.await(500L, TimeUnit.MILLISECONDS));
            monitor.setMaxUsage(100.0);
            Assert.assertTrue((String)"Thread sender should be released", (boolean)sentWithName.await(30L, TimeUnit.SECONDS));
            Assert.assertTrue((String)"Thread sender anonymous should be released", (boolean)sentAnon.await(30L, TimeUnit.SECONDS));
            threadWithName.join(TimeUnit.SECONDS.toMillis(30L));
            threadWithAnon.join(TimeUnit.SECONDS.toMillis(30L));
            Assert.assertFalse((boolean)threadWithName.isAlive());
            Assert.assertFalse((boolean)threadWithAnon.isAlive());
        }
    }
}

