/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.Before;
import org.junit.Test;

public class AmqpFullyQualifiedNameTest
extends JMSClientTestSupport {
    private SimpleString anycastAddress = new SimpleString("address.anycast");
    private SimpleString multicastAddress = new SimpleString("address.multicast");
    private SimpleString anycastQ1 = new SimpleString("q1");
    private SimpleString anycastQ2 = new SimpleString("q2");
    private SimpleString anycastQ3 = new SimpleString("q3");
    private ServerLocator locator;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createNettyNonHALocator();
    }

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, new HashMap(), "netty", new HashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFQQNTopicWhenQueueDoesNotExist() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)));
        InvalidDestinationException e = null;
        String queueName = "testQueue";
        try (Connection connection = this.createConnection(false);){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.multicastAddress.toString() + "::" + queueName);
            session.createConsumer((Destination)topic);
        }
        AmqpFullyQualifiedNameTest.assertNotNull((Object)((Object)e));
        AmqpFullyQualifiedNameTest.assertTrue((boolean)e.getMessage().contains("Queue: '" + queueName + "' does not exist"));
    }

    @Test
    public void testTopicFQQNSendAndConsumeAutoCreate() throws Exception {
        this.internalTopicFQQNSendAndConsume(true);
    }

    @Test
    public void testTopicFQQNSendAndConsumeManualCreate() throws Exception {
        this.internalTopicFQQNSendAndConsume(false);
    }

    private void internalTopicFQQNSendAndConsume(boolean autocreate) throws Exception {
        if (autocreate) {
            this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)));
        } else {
            this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        }
        try (Connection connection = this.createConnection(false);){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.anycastQ1).toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)topic);
            MessageConsumer consumer2 = session.createConsumer((Destination)topic);
            MessageConsumer consumer3 = session.createConsumer((Destination)topic);
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send(session.createMessage());
            Message m = consumer1.receive(2000L);
            AmqpFullyQualifiedNameTest.assertNotNull((Object)m);
            m = consumer2.receiveNoWait();
            AmqpFullyQualifiedNameTest.assertNull((Object)m);
            m = consumer3.receiveNoWait();
            AmqpFullyQualifiedNameTest.assertNull((Object)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumeQueueToFQQNWrongQueueAttachedToAnotherAddress() throws Exception {
        String address1 = "a1";
        String address2 = "a2";
        String queue1 = "q1";
        String queue2 = "q2";
        this.server.createQueue(new QueueConfiguration(queue1).setAddress(address1).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(queue2).setAddress(address2).setRoutingType(RoutingType.ANYCAST));
        InvalidDestinationException e = null;
        String wrongFQQN = address1 + "::" + queue2;
        try (Connection connection = this.createConnection(false);){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(wrongFQQN);
            session.createConsumer((Destination)queue);
        }
        AmqpFullyQualifiedNameTest.assertNotNull((Object)((Object)e));
        AmqpFullyQualifiedNameTest.assertTrue((boolean)e.getMessage().contains("Queue: '" + queue2 + "' does not exist for address '" + address1 + "'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubscribeTopicToFQQNWrongQueueAttachedToAnotherAddress() throws Exception {
        String address1 = "a1";
        String address2 = "a2";
        String queue1 = "q1";
        String queue2 = "q2";
        this.server.createQueue(new QueueConfiguration(queue1).setAddress(address1));
        this.server.createQueue(new QueueConfiguration(queue2).setAddress(address2));
        InvalidDestinationException e = null;
        String wrongFQQN = address1 + "::" + queue2;
        try (Connection connection = this.createConnection(false);){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(wrongFQQN);
            session.createConsumer((Destination)topic);
        }
        AmqpFullyQualifiedNameTest.assertNotNull((Object)((Object)e));
        AmqpFullyQualifiedNameTest.assertTrue((boolean)e.getMessage().contains("Queue: '" + queue2 + "' does not exist for address '" + address1 + "'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTopic() throws Exception {
        SimpleString queueName = new SimpleString("someAddress");
        this.server.createQueue(new QueueConfiguration(queueName).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        try (Connection connection = this.createConnection(false);){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic fqqn = session.createTopic(this.multicastAddress.toString() + "::" + queueName);
            MessageConsumer consumer1 = session.createConsumer((Destination)fqqn);
            MessageConsumer consumer2 = session.createConsumer((Destination)fqqn);
            Topic topic = session.createTopic(this.multicastAddress.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send(session.createMessage());
            Message m = consumer1.receive(2000L);
            AmqpFullyQualifiedNameTest.assertNotNull((Object)m);
            m = consumer2.receive(2000L);
            AmqpFullyQualifiedNameTest.assertNull((Object)m);
            Bindings bindings = this.server.getPostOffice().getBindingsForAddress(this.multicastAddress);
            for (Binding b : bindings.getBindings()) {
                this.instanceLog.debug((Object)("checking binidng " + b.getUniqueName() + " " + ((LocalQueueBinding)b).getQueue().getDeliveringMessages()));
                SimpleString qName = b.getUniqueName();
                QueueQueryResult result = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)qName));
                AmqpFullyQualifiedNameTest.assertTrue((boolean)result.isExists());
                AmqpFullyQualifiedNameTest.assertEquals((Object)result.getName(), (Object)qName);
                result = this.server.queueQuery(qName);
                AmqpFullyQualifiedNameTest.assertTrue((boolean)result.isExists());
                AmqpFullyQualifiedNameTest.assertEquals((Object)result.getName(), (Object)qName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueConsumerReceiveTopicUsingFQQN() throws Exception {
        SimpleString queueName1 = new SimpleString("sub.queue1");
        SimpleString queueName2 = new SimpleString("sub.queue2");
        this.server.createQueue(new QueueConfiguration(queueName1).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        this.server.createQueue(new QueueConfiguration(queueName2).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        try (Connection connection = this.createConnection(false);){
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue fqqn1 = session.createQueue(this.multicastAddress.toString() + "::" + queueName1);
            Queue fqqn2 = session.createQueue(this.multicastAddress.toString() + "::" + queueName2);
            MessageConsumer consumer1 = session.createConsumer((Destination)fqqn1);
            MessageConsumer consumer2 = session.createConsumer((Destination)fqqn2);
            Topic topic = session.createTopic(this.multicastAddress.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send(session.createMessage());
            Message m = consumer1.receive(2000L);
            AmqpFullyQualifiedNameTest.assertNotNull((Object)m);
            m = consumer2.receive(2000L);
            AmqpFullyQualifiedNameTest.assertNotNull((Object)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueue() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)));
        this.server.addAddressInfo(new AddressInfo(this.anycastAddress).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false));
        this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(this.anycastQ2).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(this.anycastQ3).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        Connection connection = this.createConnection();
        try {
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue q1 = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ1).toString());
            Queue q2 = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ2).toString());
            Queue q3 = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ3).toString());
            MessageProducer producer1 = session.createProducer((Destination)q1);
            producer1.send(session.createMessage());
            producer1.send(session.createMessage());
            AmqpFullyQualifiedNameTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ1).getMessageCount() == 2L, (long)2000L, (long)200L));
            MessageProducer producer2 = session.createProducer((Destination)q2);
            producer2.send(session.createMessage());
            producer2.send(session.createMessage());
            producer2.send(session.createMessage());
            AmqpFullyQualifiedNameTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ2).getMessageCount() == 3L, (long)2000L, (long)200L));
            MessageProducer producer3 = session.createProducer((Destination)q3);
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            AmqpFullyQualifiedNameTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ3).getMessageCount() == 5L, (long)2000L, (long)200L));
            this.instanceLog.debug((Object)("Queue is: " + q1));
            MessageConsumer consumer1 = session.createConsumer((Destination)q1);
            MessageConsumer consumer2 = session.createConsumer((Destination)q2);
            MessageConsumer consumer3 = session.createConsumer((Destination)q3);
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer1.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer1.receive(2000L));
            AmqpFullyQualifiedNameTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ1).getMessageCount() == 0L, (long)2000L, (long)200L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer2.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer2.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer2.receive(2000L));
            AmqpFullyQualifiedNameTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ2).getMessageCount() == 0L, (long)2000L, (long)200L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer3.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer3.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer3.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer3.receive(2000L));
            AmqpFullyQualifiedNameTest.assertNotNull((Object)consumer3.receive(2000L));
            AmqpFullyQualifiedNameTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ3).getMessageCount() == 0L, (long)2000L, (long)200L));
            connection.close();
            for (SimpleString q : new SimpleString[]{this.anycastQ1, this.anycastQ2, this.anycastQ3}) {
                QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)q));
                AmqpFullyQualifiedNameTest.assertTrue((query.isExists() || query.isAutoCreateQueues() ? (byte)1 : 0) != 0);
                AmqpFullyQualifiedNameTest.assertEquals((Object)this.anycastAddress, (Object)query.getAddress());
                AmqpFullyQualifiedNameTest.assertEquals((Object)q, (Object)query.getName());
                AmqpFullyQualifiedNameTest.assertEquals((String)"Message not consumed", (long)0L, (long)query.getMessageCount());
                query = this.server.queueQuery(q);
                AmqpFullyQualifiedNameTest.assertEquals((Object)q, (Object)query.getName());
            }
        }
        finally {
            connection.close();
            if (this.locator != null) {
                this.locator.close();
            }
        }
    }

    @Test
    public void testQueueSpecial() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.anycastQ1).setAddress(this.anycastAddress).setRoutingType(RoutingType.ANYCAST));
        Connection connection = this.createConnection();
        InvalidDestinationException expectedException = null;
        try {
            connection.start();
            Session session = connection.createSession(false, 1);
            String specialName = CompositeAddress.toFullyQualified((SimpleString)new SimpleString(""), (SimpleString)this.anycastQ1).toString();
            Queue q1 = session.createQueue(specialName);
            session.createConsumer((Destination)q1);
        }
        catch (InvalidDestinationException e) {
            expectedException = e;
        }
        AmqpFullyQualifiedNameTest.assertNotNull((Object)((Object)expectedException));
        AmqpFullyQualifiedNameTest.assertTrue((boolean)expectedException.getMessage().contains("Queue: 'q1' does not exist for address ''"));
    }
}

