/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import java.util.Arrays;
import java.util.Collection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DuplicateDetectionTest
extends ActiveMQTestBase {
    @Parameterized.Parameter(value=0)
    public boolean persistCache;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private ActiveMQServer server;
    private final SimpleString propKey = new SimpleString("propkey");
    private final int cacheSize = 10;
    private Configuration config;
    ServerLocator locator;
    ClientSessionFactory sf;

    @Parameterized.Parameters(name="persistentCache={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testSimpleDuplicateDetecion() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)0, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 3);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 4);
        SimpleString dupID2 = new SimpleString("hijklmnop");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)4, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 5);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 6);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
    }

    @Test
    public void testDuplicateIDCacheMemoryRetentionForNonTemporaryQueues() throws Exception {
        this.testDuplicateIDCacheMemoryRetention(false);
    }

    @Test
    public void testDuplicateIDCacheMemoryRetentionForTemporaryQueues() throws Exception {
        this.testDuplicateIDCacheMemoryRetention(true);
    }

    @Test
    public void testDuplicateIDCacheJournalRetentionForNonTemporaryQueues() throws Exception {
        this.testDuplicateIDCacheMemoryRetention(false);
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        Assert.assertEquals((long)0L, (long)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().size());
    }

    @Test
    public void testDuplicateIDCacheJournalRetentionForTemporaryQueues() throws Exception {
        this.testDuplicateIDCacheMemoryRetention(true);
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        Assert.assertEquals((long)0L, (long)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().size());
    }

    public void testDuplicateIDCacheMemoryRetention(boolean temporary) throws Exception {
        int TEST_SIZE = 100;
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        Assert.assertEquals((long)0L, (long)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().size());
        SimpleString addressName = new SimpleString("DuplicateDetectionTestAddress");
        for (int i = 0; i < 100; ++i) {
            SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue_" + i);
            session.createQueue(new QueueConfiguration(queueName).setAddress(addressName).setDurable(Boolean.valueOf(!temporary)).setTemporary(Boolean.valueOf(temporary)));
            ClientProducer producer = session.createProducer(addressName);
            ClientConsumer consumer = session.createConsumer(queueName);
            ClientMessage message = this.createMessage(session, 1);
            SimpleString dupID = new SimpleString("abcdefg");
            message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer.send((Message)message);
            ClientMessage message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
            message = this.createMessage(session, 2);
            message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer.send((Message)message);
            message2 = consumer.receiveImmediate();
            Assert.assertNull((Object)message2);
            message = this.createMessage(session, 3);
            message.putBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID, dupID.getData());
            producer.send((Message)message);
            message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)3, (Object)message2.getObjectProperty(this.propKey));
            message = this.createMessage(session, 4);
            message.putBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID, dupID.getData());
            producer.send((Message)message);
            message2 = consumer.receiveImmediate();
            Assert.assertNull((Object)message2);
            producer.close();
            consumer.close();
            Assert.assertEquals((long)2L, (long)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().size());
            session.deleteQueue(queueName);
            Assert.assertEquals((long)0L, (long)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().size());
        }
        Assert.assertEquals((long)0L, (long)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().size());
    }

    @Test
    public void testShrinkCache() throws Exception {
        ClientMessage message;
        int i;
        Assume.assumeTrue((String)"This test would restart the server", (boolean)this.persistCache);
        this.server.stop();
        this.server.getConfiguration().setIDCacheSize(150);
        this.server.start();
        int TEST_SIZE = 200;
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        locator.setBlockOnNonDurableSend(true);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName));
        ClientProducer producer = session.createProducer(queueName);
        for (i = 0; i < 200; ++i) {
            message = session.createMessage(true);
            message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.toSimpleString((String)("DUPL-" + i)));
            producer.send((Message)message);
        }
        session.commit();
        sf.close();
        session.close();
        locator.close();
        this.server.stop();
        this.server.getConfiguration().setIDCacheSize(100);
        this.server.start();
        locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        locator.setBlockOnNonDurableSend(true);
        sf = this.createSessionFactory(locator);
        session = sf.createSession(false, false, false);
        session.start();
        producer = session.createProducer(queueName);
        for (i = 150; i < 200; ++i) {
            message = session.createMessage(true);
            message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, SimpleString.toSimpleString((String)("DUPL-" + i)));
            producer.send((Message)message);
        }
        try {
            session.commit();
            Assert.fail((String)"Exception expected");
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleDuplicateDetectionWithString() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)0, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID);
        producer.send((Message)message);
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID);
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 3);
        message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID);
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 4);
        SimpleString dupID2 = new SimpleString("hijklmnop");
        message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2);
        producer.send((Message)message);
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)4, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 5);
        message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2);
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 6);
        message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID);
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
    }

    @Test
    public void testCacheSize() throws Exception {
        SimpleString dupID;
        int i;
        ClientMessage message;
        SimpleString dupID2;
        int i2;
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        SimpleString queueName1 = new SimpleString("DuplicateDetectionTestQueue1");
        SimpleString queueName2 = new SimpleString("DuplicateDetectionTestQueue2");
        SimpleString queueName3 = new SimpleString("DuplicateDetectionTestQueue3");
        session.createQueue(new QueueConfiguration(queueName1).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName2).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queueName3).setDurable(Boolean.valueOf(false)));
        ClientProducer producer1 = session.createProducer(queueName1);
        ClientConsumer consumer1 = session.createConsumer(queueName1);
        ClientProducer producer2 = session.createProducer(queueName2);
        ClientConsumer consumer2 = session.createConsumer(queueName2);
        ClientProducer producer3 = session.createProducer(queueName3);
        ClientConsumer consumer3 = session.createConsumer(queueName3);
        for (i2 = 0; i2 < 10; ++i2) {
            dupID2 = new SimpleString("dupID" + i2);
            message = this.createMessage(session, i2);
            message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
            producer1.send((Message)message);
            producer2.send((Message)message);
            producer3.send((Message)message);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            ClientMessage message2 = consumer1.receive(1000L);
            Assert.assertNotNull((Object)message2);
            Assert.assertEquals((Object)i2, (Object)message2.getObjectProperty(this.propKey));
            message2 = consumer2.receive(1000L);
            Assert.assertNotNull((Object)message2);
            Assert.assertEquals((Object)i2, (Object)message2.getObjectProperty(this.propKey));
            message2 = consumer3.receive(1000L);
            Assert.assertNotNull((Object)message2);
            Assert.assertEquals((Object)i2, (Object)message2.getObjectProperty(this.propKey));
        }
        this.log.debug((Object)"Now sending more");
        for (i2 = 0; i2 < 10; ++i2) {
            dupID2 = new SimpleString("dupID" + i2);
            message = this.createMessage(session, i2);
            message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
            producer1.send((Message)message);
            producer2.send((Message)message);
            producer3.send((Message)message);
        }
        ClientMessage message3 = consumer1.receiveImmediate();
        Assert.assertNull((Object)message3);
        message3 = consumer2.receiveImmediate();
        Assert.assertNull((Object)message3);
        message3 = consumer3.receiveImmediate();
        Assert.assertNull((Object)message3);
        for (i = 0; i < 10; ++i) {
            dupID = new SimpleString("dupID2-" + i);
            message3 = this.createMessage(session, i);
            message3.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer1.send((Message)message3);
            producer2.send((Message)message3);
            producer3.send((Message)message3);
        }
        for (i = 0; i < 10; ++i) {
            message3 = consumer1.receive(1000L);
            Assert.assertNotNull((Object)message3);
            Assert.assertEquals((Object)i, (Object)message3.getObjectProperty(this.propKey));
            message3 = consumer2.receive(1000L);
            Assert.assertNotNull((Object)message3);
            Assert.assertEquals((Object)i, (Object)message3.getObjectProperty(this.propKey));
            message3 = consumer3.receive(1000L);
            Assert.assertNotNull((Object)message3);
            Assert.assertEquals((Object)i, (Object)message3.getObjectProperty(this.propKey));
        }
        for (i = 0; i < 10; ++i) {
            dupID = new SimpleString("dupID2-" + i);
            message3 = this.createMessage(session, i);
            message3.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer1.send((Message)message3);
            producer2.send((Message)message3);
            producer3.send((Message)message3);
        }
        message3 = consumer1.receiveImmediate();
        Assert.assertNull((Object)message3);
        message3 = consumer2.receiveImmediate();
        Assert.assertNull((Object)message3);
        message3 = consumer3.receiveImmediate();
        Assert.assertNull((Object)message3);
        for (i = 0; i < 10; ++i) {
            dupID = new SimpleString("dupID" + i);
            message3 = this.createMessage(session, i);
            message3.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer1.send((Message)message3);
            producer2.send((Message)message3);
            producer3.send((Message)message3);
        }
        for (i = 0; i < 10; ++i) {
            message3 = consumer1.receive(1000L);
            Assert.assertNotNull((Object)message3);
            Assert.assertEquals((Object)i, (Object)message3.getObjectProperty(this.propKey));
            message3 = consumer2.receive(1000L);
            Assert.assertNotNull((Object)message3);
            Assert.assertEquals((Object)i, (Object)message3.getObjectProperty(this.propKey));
            message3 = consumer3.receive(1000L);
            Assert.assertNotNull((Object)message3);
            Assert.assertEquals((Object)i, (Object)message3.getObjectProperty(this.propKey));
        }
    }

    @Test
    public void testTransactedDuplicateDetection1() throws Exception {
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.close();
        session = this.sf.createSession(false, false, false);
        session.start();
        producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.commit();
        message = consumer.receive(250L);
        Assert.assertEquals((Object)1, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test
    public void testTransactedDuplicateDetection2() throws Exception {
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.rollback();
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.commit();
        message = consumer.receive(250L);
        Assert.assertEquals((Object)1, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test
    public void testTransactedDuplicateDetection3() throws Exception {
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID1 = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID1.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 1);
        SimpleString dupID2 = new SimpleString("hijklmno");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.commit();
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID1.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 3);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        try {
            session.commit();
        }
        catch (Exception e) {
            session.rollback();
        }
        message = consumer.receive(250L);
        Assert.assertEquals((Object)0, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receive(250L);
        Assert.assertEquals((Object)1, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
    }

    @Test
    public void testRollbackThenSend() throws Exception {
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID1 = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID1.getData());
        message.putStringProperty("key", dupID1.toString());
        producer.send((Message)message);
        session.rollback();
        message = this.createMessage(session, 0);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID1.getData());
        message.putStringProperty("key", dupID1.toString());
        producer.send((Message)message);
        session.commit();
        message = consumer.receive(5000L);
        DuplicateDetectionTest.assertNotNull((Object)message);
        DuplicateDetectionTest.assertTrue((boolean)message.getStringProperty("key").equals(dupID1.toString()));
    }

    @Test
    public void testEntireTransactionRejected() throws Exception {
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        SimpleString queue2 = new SimpleString("queue2");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        session.createQueue(new QueueConfiguration(queue2).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        ClientMessage message2 = this.createMessage(session, 0);
        ClientProducer producer2 = session.createProducer(queue2);
        producer2.send((Message)message2);
        session.commit();
        session.close();
        session = this.sf.createSession(false, false, false);
        session.start();
        ClientConsumer consumer2 = session.createConsumer(queue2);
        producer = session.createProducer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        producer.send((Message)message);
        message = this.createMessage(session, 3);
        producer.send((Message)message);
        message = this.createMessage(session, 4);
        producer.send((Message)message);
        message = consumer2.receive(5000L);
        DuplicateDetectionTest.assertNotNull((Object)message);
        message.acknowledge();
        try {
            session.commit();
        }
        catch (ActiveMQDuplicateIdException die) {
            session.rollback();
        }
        catch (ActiveMQException e) {
            DuplicateDetectionTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        ClientConsumer consumer = session.createConsumer(queueName);
        message = consumer.receive(250L);
        Assert.assertEquals((Object)0, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        message = consumer2.receive(5000L);
        DuplicateDetectionTest.assertNotNull((Object)message);
        message.acknowledge();
        session.commit();
    }

    @Test
    public void testXADuplicateDetection1() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.close();
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid2, 0);
        session.start();
        producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        message = consumer.receive(250L);
        Assert.assertEquals((Object)1, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        this.log.debug((Object)"ending session");
        session.end((Xid)xid3, 0x4000000);
        this.log.debug((Object)"preparing session");
        session.prepare((Xid)xid3);
        this.log.debug((Object)"committing session");
        session.commit((Xid)xid3, false);
    }

    @Test
    public void testXADuplicateDetection2() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.rollback((Xid)xid);
        session.close();
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid2, 0);
        session.start();
        producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        message = consumer.receive(250L);
        Assert.assertEquals((Object)1, (Object)message.getObjectProperty(this.propKey));
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        this.log.debug((Object)"ending session");
        session.end((Xid)xid3, 0x4000000);
        this.log.debug((Object)"preparing session");
        session.prepare((Xid)xid3);
        this.log.debug((Object)"committing session");
        session.commit((Xid)xid3, false);
    }

    @Test
    public void testXADuplicateDetection3() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.close();
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid2, 0);
        session.start();
        producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        consumer.receive(250L);
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        this.log.debug((Object)"ending session");
        session.end((Xid)xid3, 0x4000000);
        this.log.debug((Object)"preparing session");
        session.prepare((Xid)xid3);
        this.log.debug((Object)"committing session");
        session.commit((Xid)xid3, false);
    }

    @Test
    public void testXADuplicateDetectionPrepareAndRollback() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.rollback((Xid)xid);
        session.close();
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid2, 0);
        session.start();
        producer = session.createProducer(queueName);
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        session.close();
        session = this.sf.createSession(false, false, false);
        session.start();
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage msgRec = consumer.receive(5000L);
        DuplicateDetectionTest.assertNotNull((Object)msgRec);
        msgRec.acknowledge();
        session.commit();
    }

    @Test
    public void testXADuplicateDetectionPrepareAndRollbackStopServer() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid, 0x200000);
        session.end((Xid)xid, 0x4000000);
        session.rollback((Xid)xid);
        session.close();
        XidImpl xid2 = new XidImpl("xa2".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid2, 0);
        session.start();
        producer = session.createProducer(queueName);
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        session.close();
        session = this.sf.createSession(false, false, false);
        session.start();
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage msgRec = consumer.receive(5000L);
        DuplicateDetectionTest.assertNotNull((Object)msgRec);
        msgRec.acknowledge();
        session.commit();
    }

    @Test
    public void testXADuplicateDetection4() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 0);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.commit((Xid)xid, false);
        session.close();
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session = this.sf.createSession(true, false, false);
        session.start((Xid)xid2, 0);
        session.start();
        producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        try {
            session.prepare((Xid)xid2);
            DuplicateDetectionTest.fail((String)"Should throw an exception here!");
        }
        catch (XAException expected) {
            DuplicateDetectionTest.assertTrue((boolean)expected.getCause().toString().contains("DUPLICATE_ID_REJECTED"));
        }
        session.rollback((Xid)xid2);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        consumer.receive(250L);
        message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        this.log.debug((Object)"ending session");
        session.end((Xid)xid3, 0x4000000);
        this.log.debug((Object)"preparing session");
        session.prepare((Xid)xid3);
        this.log.debug((Object)"committing session");
        session.commit((Xid)xid3, false);
    }

    private ClientMessage createMessage(ClientSession session, int i) {
        ClientMessage message = session.createMessage(false);
        message.putIntProperty(this.propKey, i);
        return message;
    }

    @Test
    public void testDuplicateCachePersisted() throws Exception {
        this.server.stop();
        this.config = this.createDefaultInVMConfig().setIDCacheSize(10);
        this.server = this.createServer(this.config);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
    }

    @Test
    public void testDuplicateCachePersisted2() throws Exception {
        ClientMessage message2;
        SimpleString dupID;
        ClientMessage message;
        int i;
        this.server.stop();
        int theCacheSize = 5;
        this.config = this.createDefaultInVMConfig().setIDCacheSize(5);
        this.server = this.createServer(this.config);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        for (i = 0; i < 5; ++i) {
            message = this.createMessage(session, i);
            dupID = new SimpleString("abcdefg" + i);
            message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer.send((Message)message);
            message2 = consumer.receive(1000L);
            Assert.assertEquals((Object)i, (Object)message2.getObjectProperty(this.propKey));
        }
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        for (i = 0; i < 5; ++i) {
            message = this.createMessage(session, i);
            dupID = new SimpleString("abcdefg" + i);
            message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
            producer.send((Message)message);
            message2 = consumer.receiveImmediate();
            Assert.assertNull((Object)message2);
        }
    }

    @Test
    public void testNoPersist() throws Exception {
        this.server.stop();
        this.config = this.createDefaultInVMConfig().setIDCacheSize(10).setPersistIDCache(false);
        this.server = this.createServer(this.config);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, true, true);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message2 = consumer.receive(200L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        message2 = consumer.receive(200L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
    }

    @Test
    public void testNoPersistTransactional() throws Exception {
        this.server.stop();
        this.config = this.createDefaultInVMConfig().setIDCacheSize(10).setPersistIDCache(false);
        this.server = this.createServer(this.config);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.commit();
        ClientMessage message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.commit();
        message2 = consumer.receive(1000L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, false, false);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.commit();
        message2 = consumer.receive(200L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.commit();
        message2 = consumer.receive(200L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
    }

    @Test
    public void testPersistTransactional() throws Exception {
        Assume.assumeTrue((String)"This test would restart the server", (boolean)this.persistCache);
        ClientSession session = this.sf.createSession(false, false, false);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        session.commit();
        ClientMessage message2 = consumer.receive(1000L);
        message2.acknowledge();
        session.commit();
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.commit();
        message2 = consumer.receive(1000L);
        message2.acknowledge();
        session.commit();
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(false, false, false);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        try {
            session.commit();
        }
        catch (ActiveMQDuplicateIdException die) {
            session.rollback();
        }
        catch (ActiveMQException e) {
            DuplicateDetectionTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        try {
            session.commit();
        }
        catch (ActiveMQDuplicateIdException die) {
            session.rollback();
        }
        catch (ActiveMQException e) {
            DuplicateDetectionTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
    }

    @Test
    public void testNoPersistXA1() throws Exception {
        this.server.stop();
        this.config = this.createDefaultInVMConfig().setIDCacheSize(10).setPersistIDCache(false);
        this.server = this.createServer(this.config);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.commit((Xid)xid, false);
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.sf.createSession(true, false, false);
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid2, 0);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        ClientMessage message2 = consumer.receive(200L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message2 = consumer.receive(200L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
    }

    @Test
    public void testNoPersistXA2() throws Exception {
        ClientSession session = this.sf.createSession(true, false, false);
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.addClientSession(this.sf.createSession(true, false, false));
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid2, 0);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        session.prepare((Xid)xid2);
        session.commit((Xid)xid2, false);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        ClientMessage message2 = consumer.receive(200L);
        Assert.assertEquals((Object)1, (Object)message2.getObjectProperty(this.propKey));
        message2 = consumer.receive(200L);
        Assert.assertEquals((Object)2, (Object)message2.getObjectProperty(this.propKey));
    }

    @Test
    public void testPersistXA1() throws Exception {
        Assume.assumeTrue((String)"This test would restart the server", (boolean)this.persistCache);
        ClientSession session = this.addClientSession(this.sf.createSession(true, false, false));
        XidImpl xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid, 0);
        session.start();
        SimpleString queueName = new SimpleString("DuplicateDetectionTestQueue");
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(queueName);
        ClientConsumer consumer = session.createConsumer(queueName);
        ClientMessage message = this.createMessage(session, 1);
        SimpleString dupID = new SimpleString("abcdefg");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        SimpleString dupID2 = new SimpleString("hijklmnopqr");
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.end((Xid)xid, 0x4000000);
        session.prepare((Xid)xid);
        session.commit((Xid)xid, false);
        session.close();
        this.sf.close();
        this.server.stop();
        this.waitForServerToStop(this.server);
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        session = this.addClientSession(this.sf.createSession(true, false, false));
        XidImpl xid2 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid2, 0);
        session.start();
        session.createQueue(new QueueConfiguration(queueName).setDurable(Boolean.valueOf(false)));
        producer = session.createProducer(queueName);
        consumer = session.createConsumer(queueName);
        message = this.createMessage(session, 1);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID.getData());
        producer.send((Message)message);
        message = this.createMessage(session, 2);
        message.putBytesProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID2.getData());
        producer.send((Message)message);
        session.end((Xid)xid2, 0x4000000);
        try {
            session.prepare((Xid)xid2);
            DuplicateDetectionTest.fail((String)"Should throw an exception here!");
        }
        catch (XAException xAException) {
            // empty catch block
        }
        session.rollback((Xid)xid2);
        XidImpl xid3 = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        session.start((Xid)xid3, 0);
        ClientMessage message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
        message2 = consumer.receiveImmediate();
        Assert.assertNull((Object)message2);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.config = this.createDefaultInVMConfig().setIDCacheSize(10).setPersistIDCache(this.persistCache);
        this.server = this.createServer(true, this.config);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
    }
}

