/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.web.servlet.filter;

import io.opentracing.propagation.TextMap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpServletRequestExtractAdapter
implements TextMap {
    private Map<String, List<String>> headers;

    public HttpServletRequestExtractAdapter(HttpServletRequest httpServletRequest) {
        this.headers = this.servletHeadersToMultiMap(httpServletRequest);
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return new MultivaluedMapFlatIterator<String, String>(this.headers.entrySet());
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("This class should be used only with Tracer.inject()!");
    }

    protected Map<String, List<String>> servletHeadersToMultiMap(HttpServletRequest httpServletRequest) {
        HashMap<String, List<String>> headersResult = new HashMap<String, List<String>>();
        Enumeration headerNamesIt = httpServletRequest.getHeaderNames();
        while (headerNamesIt.hasMoreElements()) {
            String headerName = (String)headerNamesIt.nextElement();
            Enumeration valuesIt = httpServletRequest.getHeaders(headerName);
            ArrayList valuesList = new ArrayList(1);
            while (valuesIt.hasMoreElements()) {
                valuesList.add(valuesIt.nextElement());
            }
            headersResult.put(headerName, valuesList);
        }
        return headersResult;
    }

    public static final class MultivaluedMapFlatIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator<V> listIterator;

        public MultivaluedMapFlatIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.listIterator != null && this.listIterator.hasNext()) {
                return true;
            }
            return this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.listIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.listIterator = this.mapEntry.getValue().iterator();
            }
            if (this.listIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.listIterator.next());
            }
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

