/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.PrintStream;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.ContainerChanges;
import org.slf4j.Logger;

public class ChangesImpl
implements Changes {
    private String inputResourceName;
    private String outputResourceName;
    private int replacements;

    @Override
    public boolean hasChanges() {
        return this.hasResourceNameChange() || this.hasNonResourceNameChanges();
    }

    @Override
    public void clearChanges() {
        this.inputResourceName = null;
        this.outputResourceName = null;
        this.replacements = 0;
    }

    @Override
    public String getInputResourceName() {
        return this.inputResourceName;
    }

    @Override
    public void setInputResourceName(String inputResourceName) {
        this.inputResourceName = inputResourceName;
    }

    @Override
    public String getOutputResourceName() {
        return this.outputResourceName;
    }

    @Override
    public void setOutputResourceName(String outputResourceName) {
        this.outputResourceName = outputResourceName;
    }

    @Override
    public boolean hasResourceNameChange() {
        return this.inputResourceName != null && !this.inputResourceName.equals(this.outputResourceName);
    }

    @Override
    public int getReplacements() {
        return this.replacements;
    }

    @Override
    public void addReplacement() {
        ++this.replacements;
    }

    @Override
    public void addReplacements(int additions) {
        this.replacements += additions;
    }

    @Override
    public boolean hasNonResourceNameChanges() {
        return this.replacements > 0;
    }

    @Override
    public void addNestedInto(ContainerChanges containerChanges) {
    }

    protected String getChangeTag() {
        return this.hasNonResourceNameChanges() ? "Changed" : "Unchanged";
    }

    @Override
    public void displayTerse(PrintStream printStream, String inputPath, String outputPath) {
        if (!inputPath.equals(outputPath)) {
            printStream.printf("Input [ %s ] as [ %s ]: %s\n", inputPath, outputPath, this.getChangeTag());
        } else {
            printStream.printf("Input [ %s ]: %s\n", inputPath, this.getChangeTag());
        }
    }

    @Override
    public void displayTerse(Logger logger, String inputPath, String outputPath) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        if (!inputPath.equals(outputPath)) {
            if (!inputPath.equals(outputPath)) {
                logger.info("Input [ {} ] as [ {} ]: {}", inputPath, outputPath, this.getChangeTag());
            } else {
                logger.info("Input [ {} ]: {}", (Object)inputPath, (Object)this.getChangeTag());
            }
        }
    }

    @Override
    public void display(PrintStream printStream, String inputPath, String outputPath) {
        this.displayTerse(printStream, inputPath, outputPath);
    }

    @Override
    public void display(Logger logger, String inputPath, String outputPath) {
        this.displayTerse(logger, inputPath, outputPath);
    }

    @Override
    public void displayVerbose(PrintStream printStream, String inputPath, String outputPath) {
        printStream.printf("Input  [ %s ] as [ %s ]\n", this.getInputResourceName(), inputPath);
        printStream.printf("Output [ %s ] as [ %s ]\n", this.getOutputResourceName(), outputPath);
        printStream.printf("Replacements  [ %s ]\n", this.getReplacements());
    }

    @Override
    public void displayVerbose(Logger logger, String inputPath, String outputPath) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        logger.info("Input  [ {} ] as [ {} ]", (Object)this.getInputResourceName(), (Object)inputPath);
        logger.info("Output [ {} ] as [ {} ]", (Object)this.getOutputResourceName(), (Object)outputPath);
        logger.info("Replacements  [ {} ]", (Object)this.getReplacements());
    }
}

