/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.uri;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;

public final class URIUtil {
    private static final Pattern WINDOWS_FILE_PATTERN = Pattern.compile("(?:\\p{Alpha}:[\\\\/]|\\\\\\\\|//)");
    private static final URI EMPTYURI = URI.create("");

    public static URI resolve(URI baseURI, String reference) throws URISyntaxException {
        URI refURI;
        if (reference.isEmpty()) {
            return new URI(baseURI.getScheme(), baseURI.getSchemeSpecificPart(), null);
        }
        if (WINDOWS_FILE_PATTERN.matcher(reference).lookingAt()) {
            return new File(reference).toURI();
        }
        reference = reference.replace('\\', '/');
        try {
            refURI = new URI(reference);
        }
        catch (URISyntaxException e) {
            refURI = new URI(null, reference, null);
        }
        return baseURI.resolve(refURI);
    }

    public static Optional<Path> pathFromURI(String uriString) {
        if (uriString == null) {
            return Optional.empty();
        }
        try {
            URI uri = URIUtil.resolve(EMPTYURI, uriString);
            return URIUtil.pathFromURI(uriString, uri);
        }
        catch (URISyntaxException e1) {
            return Optional.empty();
        }
    }

    public static Optional<Path> pathFromURI(URI uri) {
        if (uri == null) {
            return Optional.empty();
        }
        return URIUtil.pathFromURI(uri.getSchemeSpecificPart(), uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Path> pathFromURI(String uriString, URI uri) {
        try {
            block16: while (!EMPTYURI.equals(uri)) {
                String scheme = uri.getScheme();
                if (scheme == null) {
                    try {
                        return Optional.of(Paths.get(uriString, new String[0]));
                    }
                    catch (InvalidPathException e) {
                        return Optional.empty();
                    }
                }
                switch (scheme.toLowerCase(Locale.ROOT)) {
                    case "file": {
                        return Optional.of(Paths.get(uri));
                    }
                    case "jar": 
                    case "bundle": 
                    case "zip": {
                        uriString = uri.getSchemeSpecificPart();
                        int index = uriString.indexOf("!/");
                        if (index >= 0) {
                            uriString = uriString.substring(0, index);
                        }
                        uri = URIUtil.resolve(EMPTYURI, uriString);
                        continue block16;
                    }
                    case "reference": {
                        uriString = uri.getSchemeSpecificPart();
                        uri = URIUtil.resolve(EMPTYURI, uriString);
                        continue block16;
                    }
                }
                uriString = uri.getSchemeSpecificPart();
                if ((uri = new URI(uriString)).getScheme() == null) return Optional.empty();
            }
            return Optional.empty();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static boolean isRemote(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        switch (scheme.toLowerCase(Locale.ROOT)) {
            case "file": 
            case "jar": 
            case "data": {
                return false;
            }
        }
        return true;
    }

    public static int getDefaultPort(String scheme) {
        switch (scheme) {
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
            case "ftp": {
                return 20;
            }
        }
        return -1;
    }
}

