/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5.service;

import java.util.Map;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.internal.RegionFactoryInitiator;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.as.jpa.hibernate5.JpaLogger;

public class WildFlyCustomRegionFactoryInitiator
extends RegionFactoryInitiator {
    private static final String HIBERNATE_REGION_FACTORY_CLASS = "hibernate.cache.region.factory_class";
    private static final String V53_INFINISPAN_REGION_FACTORY = "org.infinispan.hibernate.cache.v53.InfinispanRegionFactory";
    private static final String UNSPECIFIED = "UNSPECIFIED";
    private static final String NONE = "NONE";

    protected RegionFactory resolveRegionFactory(Map configurationValues, ServiceRegistryImplementor registry) {
        Object useSecondLevelCache = configurationValues.get("hibernate.cache.use_second_level_cache");
        String jpaSharedCodeModeValue = configurationValues.get("jakarta.persistence.sharedCache.mode") != null ? configurationValues.get("jakarta.persistence.sharedCache.mode").toString() : UNSPECIFIED;
        Object regionFactory = configurationValues.get(HIBERNATE_REGION_FACTORY_CLASS);
        if (Boolean.parseBoolean((String)useSecondLevelCache)) {
            JpaLogger.JPA_LOGGER.tracef("WildFlyCustomRegionFactoryInitiator#resolveRegionFactory using %s for 2lc, useSecondLevelCache=%s, jpaSharedCodeModeValue=%s, regionFactory=%s", new Object[]{V53_INFINISPAN_REGION_FACTORY, useSecondLevelCache, jpaSharedCodeModeValue, regionFactory});
            configurationValues.put(HIBERNATE_REGION_FACTORY_CLASS, V53_INFINISPAN_REGION_FACTORY);
            return super.resolveRegionFactory(configurationValues, registry);
        }
        if (UNSPECIFIED.equals(jpaSharedCodeModeValue) || NONE.equals(jpaSharedCodeModeValue)) {
            JpaLogger.JPA_LOGGER.tracef("WildFlyCustomRegionFactoryInitiator#resolveRegionFactory not using a 2lc, useSecondLevelCache=%s, jpaSharedCodeModeValue=%s, regionFactory=%s", useSecondLevelCache, jpaSharedCodeModeValue, regionFactory);
            return NoCachingRegionFactory.INSTANCE;
        }
        JpaLogger.JPA_LOGGER.tracef("WildFlyCustomRegionFactoryInitiator#resolveRegionFactory using %s for 2lc, useSecondLevelCache=%s, jpaSharedCodeModeValue=%s, regionFactory=%s", new Object[]{V53_INFINISPAN_REGION_FACTORY, useSecondLevelCache, jpaSharedCodeModeValue, regionFactory});
        configurationValues.put(HIBERNATE_REGION_FACTORY_CLASS, V53_INFINISPAN_REGION_FACTORY);
        return super.resolveRegionFactory(configurationValues, registry);
    }
}

