/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import jakarta.transaction.Transaction;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.impl.EventImpl;
import org.infinispan.notifications.impl.AbstractListenerImpl;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class CacheManagerNotifierImpl
extends AbstractListenerImpl<Event, ListenerInvocation<Event>>
implements CacheManagerNotifier {
    private static final Log log = LogFactory.getLog(CacheManagerNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(4);
    final List<ListenerInvocation<Event>> cacheStartedListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    final List<ListenerInvocation<Event>> cacheStoppedListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    final List<ListenerInvocation<Event>> viewChangedListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    final List<ListenerInvocation<Event>> mergeListeners = new CopyOnWriteArrayList<ListenerInvocation<Event>>();
    @Inject
    EmbeddedCacheManager cacheManager;

    public CacheManagerNotifierImpl() {
        this.listenersMap.put(CacheStarted.class, this.cacheStartedListeners);
        this.listenersMap.put(CacheStopped.class, this.cacheStoppedListeners);
        this.listenersMap.put(ViewChanged.class, this.viewChangedListeners);
        this.listenersMap.put(Merged.class, this.mergeListeners);
    }

    private CompletionStage<Void> invokeListeners(EventImpl event, List<ListenerInvocation<Event>> listeners) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (ListenerInvocation<Event> listener : listeners) {
            aggregateCompletionStage = CacheManagerNotifierImpl.composeStageIfNeeded(aggregateCompletionStage, this.invokeListener(listener, event));
        }
        if (aggregateCompletionStage != null) {
            return this.resumeOnCPU(aggregateCompletionStage.freeze(), event);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyViewChange(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId) {
        if (!this.viewChangedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setLocalAddress(myAddress);
            e.setMergeView(false);
            e.setViewId(viewId);
            e.setNewMembers(members);
            e.setOldMembers(oldMembers);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.VIEW_CHANGED);
            return this.invokeListeners(e, this.viewChangedListeners);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyMerge(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId, List<List<Address>> subgroupsMerged) {
        if (!this.mergeListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setLocalAddress(myAddress);
            e.setViewId(viewId);
            e.setMergeView(true);
            e.setNewMembers(members);
            e.setOldMembers(oldMembers);
            e.setCacheManager(this.cacheManager);
            e.setSubgroupsMerged(subgroupsMerged);
            e.setType(Event.Type.MERGED);
            return this.invokeListeners(e, this.mergeListeners);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheStarted(String cacheName) {
        if (!this.cacheStartedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCacheName(cacheName);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.CACHE_STARTED);
            return this.invokeListeners(e, this.cacheStartedListeners);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> notifyCacheStopped(String cacheName) {
        if (!this.cacheStoppedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCacheName(cacheName);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.CACHE_STOPPED);
            return this.invokeListeners(e, this.cacheStoppedListeners);
        }
        return CompletableFutures.completedNull();
    }

    private void handleException(Throwable t) {
        log.failedInvokingCacheManagerListener(t);
    }

    private CompletionStage<Void> invokeListener(ListenerInvocation<Event> listener, EventImpl e) {
        try {
            CompletionStage<Void> stage = listener.invoke(e);
            if (stage != null && !CompletionStages.isCompletedSuccessfully(stage)) {
                return stage.exceptionally(t -> {
                    this.handleException((Throwable)t);
                    return null;
                });
            }
        }
        catch (Exception x) {
            this.handleException(x);
        }
        return null;
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        this.validateAndAddListenerInvocations(listener, new DefaultBuilder());
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        this.removeListenerFromMaps(listener);
        return CompletableFutures.completedNull();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener l) {
        return allowedListeners;
    }

    @Override
    protected final Transaction suspendIfNeeded() {
        return null;
    }

    @Override
    protected final void resumeIfNeeded(Transaction transaction) {
    }

    public void start() {
    }

    static {
        allowedListeners.put(CacheStarted.class, CacheStartedEvent.class);
        allowedListeners.put(CacheStopped.class, CacheStoppedEvent.class);
        allowedListeners.put(ViewChanged.class, ViewChangedEvent.class);
        allowedListeners.put(Merged.class, MergeEvent.class);
    }

    protected class DefaultBuilder
    extends AbstractListenerImpl.AbstractInvocationBuilder {
        protected DefaultBuilder() {
            super(CacheManagerNotifierImpl.this);
        }

        public ListenerInvocation<Event> build() {
            return new AbstractListenerImpl.ListenerInvocationImpl<Event>(CacheManagerNotifierImpl.this, this.target, this.method, this.sync, this.classLoader, this.subject);
        }
    }
}

