/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import jakarta.resource.spi.security.PasswordCredential;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.picketbox.datasource.security.GetPrincipalInfoAction;
import org.picketbox.datasource.security.SubjectActions;

public class CallerIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private String userName;
    private char[] password;
    private boolean addRunAsRoles;
    private Set<Principal> runAsRoles;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.userName = (String)options.get("userName");
        String pass = (String)options.get("password");
        if (pass != null) {
            if (SecurityVaultUtil.isVaultFormat(pass)) {
                try {
                    pass = SecurityVaultUtil.getValueAsString(pass);
                }
                catch (SecurityVaultException e) {
                    throw new RuntimeException(e);
                }
                this.password = pass.toCharArray();
            } else {
                this.password = pass.toCharArray();
            }
        }
        String flag = (String)options.get("addRunAsRoles");
        this.addRunAsRoles = Boolean.valueOf(flag);
        PicketBoxLogger.LOGGER.debugModuleOption("userName", this.userName);
        PicketBoxLogger.LOGGER.debugModuleOption("password", this.password != null ? "****" : null);
        PicketBoxLogger.LOGGER.debugModuleOption("addRunAsRoles", this.addRunAsRoles);
    }

    @Override
    public boolean login() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginLogin();
        String username = this.userName;
        try {
            Principal user = GetPrincipalInfoAction.getPrincipal();
            char[] userPassword = GetPrincipalInfoAction.getCredential();
            if (userPassword != null) {
                this.password = userPassword;
                if (SecurityVaultUtil.isVaultFormat(this.password)) {
                    this.password = SecurityVaultUtil.getValue(this.password);
                }
            }
            if (user != null) {
                RunAsIdentity runAs;
                username = user.getName();
                if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                    PicketBoxLogger.LOGGER.traceCurrentCallingPrincipal(username, Thread.currentThread().getName());
                }
                if ((runAs = GetPrincipalInfoAction.peekRunAsIdentity()) != null) {
                    this.runAsRoles = runAs.getRunAsRoles();
                }
            }
        }
        catch (Throwable e) {
            throw PicketBoxMessages.MESSAGES.unableToGetPrincipalOrCredsForAssociation();
        }
        this.userName = username;
        if (super.login()) {
            return true;
        }
        this.sharedState.put("javax.security.auth.login.name", username);
        this.loginOk = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.sharedState.put("javax.security.auth.login.name", this.userName);
        if (this.addRunAsRoles && this.runAsRoles != null) {
            SubjectActions.addRoles(this.subject, this.runAsRoles);
        }
        PasswordCredential cred = new PasswordCredential(this.userName, this.password);
        SubjectActions.addCredentials(this.subject, cred);
        return super.commit();
    }

    @Override
    protected Principal getIdentity() {
        PicketBoxLogger.LOGGER.traceBeginGetIdentity(this.userName);
        SimplePrincipal principal = new SimplePrincipal(this.userName);
        return principal;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        PicketBoxLogger.LOGGER.traceBeginGetRoleSets();
        return new Group[0];
    }
}

