/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.identitystores;

import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStorePermission;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.soteria.identitystores.annotation.Credentials;
import org.glassfish.soteria.identitystores.annotation.EmbeddedIdentityStoreDefinition;

public class EmbeddedIdentityStore
implements IdentityStore {
    private final EmbeddedIdentityStoreDefinition embeddedIdentityStoreDefinition;
    private final Map<String, Credentials> callerToCredentials;
    private final Set<IdentityStore.ValidationType> validationType;

    public EmbeddedIdentityStore(EmbeddedIdentityStoreDefinition embeddedIdentityStoreDefinition) {
        this.embeddedIdentityStoreDefinition = embeddedIdentityStoreDefinition;
        this.callerToCredentials = Arrays.stream(embeddedIdentityStoreDefinition.value()).collect(Collectors.toMap(e -> e.callerName(), e -> e));
        this.validationType = Collections.unmodifiableSet(new HashSet<IdentityStore.ValidationType>(Arrays.asList(embeddedIdentityStoreDefinition.useFor())));
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    public CredentialValidationResult validate(UsernamePasswordCredential usernamePasswordCredential) {
        Credentials credentials = this.callerToCredentials.get(usernamePasswordCredential.getCaller());
        if (credentials != null && usernamePasswordCredential.getPassword().compareTo(credentials.password())) {
            return new CredentialValidationResult(new CallerPrincipal(credentials.callerName()), new HashSet<String>(Arrays.asList(credentials.groups())));
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        Credentials credentials;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        return (credentials = this.callerToCredentials.get(validationResult.getCallerPrincipal().getName())) != null ? new HashSet<String>(Arrays.asList(credentials.groups())) : Collections.emptySet();
    }

    public int priority() {
        return this.embeddedIdentityStoreDefinition.priority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationType;
    }
}

