/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.persistence.jdbc.logging.Log;

public class JdbcUtil {
    public static void safeClose(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                Log.PERSISTENCE.sqlFailureUnexpected(e);
            }
        }
    }

    public static void safeClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                Log.PERSISTENCE.sqlFailureClosingConnection(connection, e);
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                Log.PERSISTENCE.sqlFailureUnexpected(e);
            }
        }
    }

    public static ByteBuffer marshall(Object obj, Marshaller marshaller) {
        try {
            return marshaller.objectToBuffer(obj);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MarshallingException((Throwable)e);
        }
        catch (IOException e) {
            Log.PERSISTENCE.errorMarshallingObject(e, obj);
            throw new MarshallingException("I/O failure while marshalling object: " + obj, (Throwable)e);
        }
    }

    public static <T> T unmarshall(InputStream inputStream, StreamAwareMarshaller marshaller) {
        try {
            return (T)marshaller.readObject(inputStream);
        }
        catch (IOException e) {
            Log.PERSISTENCE.ioErrorUnmarshalling(e);
            throw new MarshallingException("I/O error while unmarshalling from stream", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.PERSISTENCE.unexpectedClassNotFoundException(e);
            throw new MarshallingException((Throwable)e);
        }
    }

    public static <T> T unmarshall(ByteBuffer buf, Marshaller marshaller) {
        try {
            return (T)marshaller.objectFromByteBuffer(buf.getBuf(), buf.getOffset(), buf.getLength());
        }
        catch (IOException e) {
            throw new MarshallingException("I/O error while unmarshalling", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.PERSISTENCE.unexpectedClassNotFoundException(e);
            throw new MarshallingException((Throwable)e);
        }
    }
}

