/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.orm.spi;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class SearchIntegratorHelper {
    private SearchIntegratorHelper() {
    }

    public static SearchIntegrator extractFromSessionFactory(SessionFactory sf) {
        Objects.requireNonNull(sf);
        return ContextHelper.getSearchIntegratorBySF(sf);
    }

    public static SearchIntegrator extractFromEntityManagerFactory(EntityManagerFactory emf) {
        Objects.requireNonNull(emf);
        try {
            SessionFactoryImpl sf = (SessionFactoryImpl)emf.unwrap(SessionFactoryImpl.class);
            return SearchIntegratorHelper.extractFromSessionFactory((SessionFactory)sf);
        }
        catch (PersistenceException cce) {
            throw LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup()).incompatibleEntityManagerFactory(emf.getClass().toString());
        }
    }
}

