/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.el.LegacyValueBinding;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.ValueBinding;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.ActionSource2AttachedObjectHandler;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.io.IOException;
import java.io.Serializable;

public class SetPropertyActionListenerHandler
extends TagHandlerImpl
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute value = this.getRequiredAttribute("value");
    private final TagAttribute target = this.getRequiredAttribute("target");

    public SetPropertyActionListenerHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (null == parent || !ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            if (null == this.getFor()) {
                throw new TagException(this.tag, "actionListener tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type ActionSource, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ActionSource src = (ActionSource)parent;
        ValueExpression valueExpr = this.value.getValueExpression(ctx, Object.class);
        ValueExpression targetExpr = this.target.getValueExpression(ctx, Object.class);
        ActionListener listener = src instanceof ActionSource2 ? new SetPropertyListener(valueExpr, targetExpr) : new LegacySetPropertyListener(new LegacyValueBinding(valueExpr), new LegacyValueBinding(targetExpr));
        src.addActionListener(listener);
    }

    public String getFor() {
        String result = null;
        TagAttribute attr = this.getAttribute("for");
        if (null != attr) {
            if (attr.isLiteral()) {
                result = attr.getValue();
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                FaceletContext ctx = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
                result = (String)attr.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
            }
        }
        return result;
    }

    private static class SetPropertyListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -2760242070551459725L;
        private ValueExpression value;
        private ValueExpression target;

        public SetPropertyListener() {
        }

        public SetPropertyListener(ValueExpression value, ValueExpression target) {
            this.value = value;
            this.target = target;
        }

        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            ELContext el = faces.getELContext();
            Object valueObj = this.value.getValue(el);
            if (valueObj != null) {
                ExpressionFactory factory = faces.getApplication().getExpressionFactory();
                valueObj = factory.coerceToType(valueObj, this.target.getType(el));
            }
            this.target.setValue(el, valueObj);
        }
    }

    private static class LegacySetPropertyListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 3004987947382293693L;
        private ValueBinding value;
        private ValueBinding target;

        public LegacySetPropertyListener() {
        }

        public LegacySetPropertyListener(ValueBinding value, ValueBinding target) {
            this.value = value;
            this.target = target;
        }

        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            Object valueObj = this.value.getValue(faces);
            this.target.setValue(faces, valueObj);
        }
    }
}

