/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.StateContext;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class ComponentSupport {
    private static final String MARK_DELETED = "com.sun.faces.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.faces.facelets.MARK_ID";
    public static final String MARK_CHILDREN_MODIFIED = "com.sun.faces.facelets.MARK_CHILDREN_MODIFIED";
    public static final String REMOVED_CHILDREN = "com.sun.faces.facelets.REMOVED_CHILDREN";
    public static final String MARK_CREATED_REMOVED = StateContext.class.getName() + "_MARK_CREATED_REMOVED";
    private static final String IMPLICIT_PANEL = "com.sun.faces.facelets.IMPLICIT_PANEL";
    public static final String COMPONENT_TO_TAG_MAP_NAME = "com.sun.faces.facelets.COMPONENT_TO_LOCATION_MAP";

    public static boolean handlerIsResourceRelated(ComponentHandler handler) {
        ComponentConfig config = handler.getComponentConfig();
        if (!"jakarta.faces.Output".equals(config.getComponentType())) {
            return false;
        }
        String rendererType = config.getRendererType();
        return "jakarta.faces.resource.Script".equals(rendererType) || "jakarta.faces.resource.Stylesheet".equals(rendererType);
    }

    public static boolean isBuildingNewComponentTree(FacesContext context) {
        return !context.isPostback() || context.getCurrentPhaseId().equals(PhaseId.RESTORE_VIEW);
    }

    public static boolean isImplicitPanel(UIComponent component) {
        return component.getAttributes().containsKey(IMPLICIT_PANEL);
    }

    public static void finalizeForDeletion(UIComponent c) {
        Map facets;
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if ((facets = c.getFacets()).size() > 0) {
            Set col = facets.entrySet();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                Map.Entry curEntry = itr.next();
                UIComponent fc = (UIComponent)curEntry.getValue();
                Map attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_DELETED)) {
                    itr.remove();
                    continue;
                }
                if (!"jakarta.faces.component.COMPOSITE_FACET_NAME".equals(curEntry.getKey()) && (!attrs.containsKey(IMPLICIT_PANEL) || ((String)curEntry.getKey()).equals("jakarta_faces_metadata"))) continue;
                List implicitPanelChildren = fc.getChildren();
                Iterator innerItr = implicitPanelChildren.iterator();
                while (innerItr.hasNext()) {
                    UIComponent innerChild = (UIComponent)innerItr.next();
                    if (!innerChild.getAttributes().containsKey(MARK_DELETED)) continue;
                    innerItr.remove();
                }
            }
        }
    }

    public static Tag setTagForComponent(FacesContext context, UIComponent c, Tag t) {
        Map contextMap = context.getAttributes();
        HashMap<Integer, Tag> componentToTagMap = (HashMap<Integer, Tag>)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null == componentToTagMap) {
            componentToTagMap = new HashMap<Integer, Tag>();
            contextMap.put(COMPONENT_TO_TAG_MAP_NAME, componentToTagMap);
        }
        return componentToTagMap.put(System.identityHashCode(c), t);
    }

    public static Tag getTagForComponent(FacesContext context, UIComponent c) {
        Tag result = null;
        Map contextMap = context.getAttributes();
        Map componentToTagMap = (Map)contextMap.get(COMPONENT_TO_TAG_MAP_NAME);
        if (null != componentToTagMap) {
            result = (Tag)componentToTagMap.get(System.identityHashCode(c));
        }
        return result;
    }

    public static UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static UIComponent findUIInstructionChildByTagId(FacesContext context, UIComponent parent, String id) {
        UIComponent result = null;
        if (ComponentSupport.isBuildingNewComponentTree(context)) {
            return null;
        }
        Map attrs = context.getAttributes();
        if (attrs.containsKey((Object)WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving) && ((Boolean)attrs.get((Object)WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving)).booleanValue()) {
            result = ComponentSupport.findChildByTagId(context, parent, id);
        }
        return result;
    }

    public static UIComponent findChildByTagId(FacesContext context, UIComponent parent, String id) {
        ArrayList components;
        UIComponent c = null;
        UIViewRoot root = context.getViewRoot();
        boolean hasDynamicComponents = null != root && root.getAttributes().containsKey("com.sun.faces.TreeHasDynamicComponents");
        String cid = null;
        String facetName = ComponentSupport.getFacetName(parent);
        if (null != facetName && null != (c = parent.getFacet(facetName)) && id.equals(cid = (String)c.getAttributes().get(MARK_CREATED))) {
            return c;
        }
        if (0 < parent.getFacetCount()) {
            components = new ArrayList();
            components.addAll(parent.getFacets().values());
            components.addAll(parent.getChildren());
        } else {
            components = parent.getChildren();
        }
        int len = components.size();
        for (int i = 0; i < len; ++i) {
            UIComponent foundChild;
            c = (UIComponent)components.get(i);
            cid = (String)c.getAttributes().get(MARK_CREATED);
            if (id.equals(cid)) {
                return c;
            }
            if (c instanceof UIPanel && c.getAttributes().containsKey(IMPLICIT_PANEL)) {
                for (UIComponent c2 : c.getChildren()) {
                    cid = (String)c2.getAttributes().get(MARK_CREATED);
                    if (!id.equals(cid)) continue;
                    return c2;
                }
            }
            if (!hasDynamicComponents || (foundChild = ComponentSupport.findChildByTagId(context, c, id)) == null) continue;
            return foundChild;
        }
        return null;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            try {
                return Util.getLocaleFromString(s);
            }
            catch (IllegalArgumentException iae) {
                throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
            }
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Set col = c.getFacets().entrySet();
            for (Map.Entry entry : col) {
                String facet = (String)entry.getKey();
                UIComponent fc = (UIComponent)entry.getValue();
                Map attrs = fc.getAttributes();
                if (attrs.containsKey(MARK_CREATED)) {
                    attrs.put(MARK_DELETED, Boolean.TRUE);
                    continue;
                }
                if ("jakarta.faces.component.COMPOSITE_FACET_NAME".equals(facet)) {
                    sz = fc.getChildCount();
                    if (sz <= 0) continue;
                    UIComponent cc = null;
                    List cl = fc.getChildren();
                    while (--sz >= 0) {
                        cc = (UIComponent)cl.get(sz);
                        cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
                    }
                    continue;
                }
                if (!attrs.containsKey(IMPLICIT_PANEL)) continue;
                List implicitPanelChildren = fc.getChildren();
                Map innerAttrs = null;
                for (UIComponent cur : implicitPanelChildren) {
                    innerAttrs = cur.getAttributes();
                    if (!innerAttrs.containsKey(MARK_CREATED)) continue;
                    innerAttrs.put(MARK_DELETED, Boolean.TRUE);
                }
            }
        }
    }

    public static void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (viewToRender.isRendered()) {
            viewToRender.encodeBegin(context);
            if (viewToRender.getRendersChildren()) {
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                for (UIComponent kid : viewToRender.getChildren()) {
                    ComponentSupport.encodeRecursive(context, kid);
                }
            }
            viewToRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        ComponentSupport.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
    }

    public static void addComponent(FaceletContext ctx, UIComponent parent, UIComponent child) {
        String facetName = ComponentSupport.getFacetName(parent);
        if (facetName == null) {
            if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                int childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                if (childIndex >= parent.getChildCount() || childIndex == -1) {
                    parent.getChildren().add(child);
                } else {
                    parent.getChildren().add(childIndex, child);
                }
            } else {
                parent.getChildren().add(child);
            }
        } else {
            UIComponent existing = (UIComponent)parent.getFacets().get(facetName);
            if (existing != null && existing != child) {
                if (existing.getAttributes().get(IMPLICIT_PANEL) == null) {
                    UIComponent panelGroup = ctx.getFacesContext().getApplication().createComponent("jakarta.faces.Panel");
                    parent.getFacets().put(facetName, panelGroup);
                    Map attrs = panelGroup.getAttributes();
                    attrs.put(IMPLICIT_PANEL, true);
                    panelGroup.getChildren().add(existing);
                    existing = panelGroup;
                }
                if (existing.getAttributes().get(IMPLICIT_PANEL) != null) {
                    existing.getChildren().add(child);
                } else {
                    parent.getFacets().put(facetName, child);
                }
            } else {
                parent.getFacets().put(facetName, child);
            }
        }
    }

    public static String getFacetName(UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    public static boolean suppressViewModificationEvents(FacesContext ctx) {
        String viewId;
        UIViewRoot root = ctx.getViewRoot();
        if (root != null && (viewId = root.getViewId()) != null) {
            StateContext stateCtx = StateContext.getStateContext(ctx);
            return stateCtx.isPartialStateSaving(ctx, viewId);
        }
        return false;
    }

    public static void copyPassthroughAttributes(FaceletContext ctx, UIComponent c, Tag t) {
        if (null == c || null == t) {
            return;
        }
        TagAttribute[] passthroughAttrs = t.getAttributes().getAll("http://xmlns.jcp.org/jsf/passthrough");
        if (null != passthroughAttrs && 0 < passthroughAttrs.length) {
            Map componentPassthroughAttrs = c.getPassThroughAttributes(true);
            String attrValue = null;
            for (TagAttribute cur : passthroughAttrs) {
                attrValue = cur.isLiteral() ? cur.getValue(ctx) : cur.getValueExpression(ctx, Object.class);
                componentPassthroughAttrs.put(cur.getLocalName(), attrValue);
            }
        }
    }
}

