/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ClientBehaviorRenderer;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.Renderer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RenderKitConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES;
    Map<Class<?>, Annotation> annotatedRenderers;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.annotatedRenderers == null) {
            this.annotatedRenderers = new HashMap();
        }
        this.annotatedRenderers.put(target, annotation);
    }

    @Override
    public void push(FacesContext ctx) {
        if (this.annotatedRenderers != null) {
            RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
            for (Map.Entry<Class<?>, Annotation> entry : this.annotatedRenderers.entrySet()) {
                RenderKit rk;
                Class<?> rClass = entry.getKey();
                if (entry.getValue() instanceof FacesRenderer) {
                    FacesRenderer ra = (FacesRenderer)entry.getValue();
                    try {
                        rk = rkf.getRenderKit(ctx, ra.renderKitId());
                        if (rk == null) {
                            throw new IllegalStateException("Error processing annotated Renderer " + ra.toString() + " on class " + rClass.getName() + ".  Unable to find specified RenderKit.");
                        }
                        rk.addRenderer(ra.componentFamily(), ra.rendererType(), (Renderer)rClass.newInstance());
                        continue;
                    }
                    catch (IllegalAccessException | IllegalStateException | InstantiationException e) {
                        throw new FacesException((Throwable)e);
                    }
                }
                if (!(entry.getValue() instanceof FacesBehaviorRenderer)) continue;
                FacesBehaviorRenderer bra = (FacesBehaviorRenderer)entry.getValue();
                try {
                    rk = rkf.getRenderKit(ctx, bra.renderKitId());
                    if (rk == null) {
                        throw new IllegalStateException("Error processing annotated ClientBehaviorRenderer " + bra.toString() + " on class " + rClass.getName() + ".  Unable to find specified RenderKit.");
                    }
                    rk.addClientBehaviorRenderer(bra.rendererType(), (ClientBehaviorRenderer)rClass.newInstance());
                }
                catch (IllegalAccessException | IllegalStateException | InstantiationException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
    }

    static {
        ArrayList<Class> handles = new ArrayList<Class>(2);
        handles.add(FacesRenderer.class);
        handles.add(FacesBehaviorRenderer.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }
}

