/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PersistenceContexts;
import jakarta.persistence.PersistenceUnit;
import jakarta.persistence.PersistenceUnits;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.structure.SpecDescriptorPropertyReplacement;
import org.jboss.as.jpa.config.JPADeploymentSettings;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.injectors.PersistenceContextInjectionSource;
import org.jboss.as.jpa.injectors.PersistenceUnitInjectionSource;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class JPAAnnotationProcessor
implements DeploymentUnitProcessor {
    private static final DotName PERSISTENCE_CONTEXT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_CONTEXTS_ANNOTATION_NAME = DotName.createSimple((String)PersistenceContexts.class.getName());
    private static final DotName PERSISTENCE_UNIT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final DotName PERSISTENCE_UNITS_ANNOTATION_NAME = DotName.createSimple((String)PersistenceUnits.class.getName());
    private static final String ENTITY_MANAGER_CLASS = "jakarta.persistence.EntityManager";
    private static final String ENTITY_MANAGERFACTORY_CLASS = "jakarta.persistence.EntityManagerFactory";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        List persistenceContexts = index.getAnnotations(PERSISTENCE_CONTEXT_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, persistenceContexts, applicationClasses);
        List collectionPersistenceContexts = index.getAnnotations(PERSISTENCE_CONTEXTS_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, collectionPersistenceContexts, applicationClasses);
        List collectionPersistenceunits = index.getAnnotations(PERSISTENCE_UNITS_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, collectionPersistenceunits, applicationClasses);
        List persistenceUnits = index.getAnnotations(PERSISTENCE_UNIT_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, persistenceUnits, applicationClasses);
        if (!(persistenceContexts.isEmpty() && persistenceUnits.isEmpty() && collectionPersistenceContexts.isEmpty() && collectionPersistenceunits.isEmpty())) {
            JPADeploymentMarker.mark((DeploymentUnit)deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processPersistenceAnnotations(DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, List<AnnotationInstance> persistenceContexts, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        for (AnnotationInstance annotation : persistenceContexts) {
            EEModuleClassDescription eeModuleClassDescription;
            ClassInfo declaringClass;
            AnnotationTarget annotationTarget = annotation.target();
            if (annotationTarget instanceof FieldInfo) {
                FieldInfo fieldInfo = (FieldInfo)annotationTarget;
                declaringClass = fieldInfo.declaringClass();
                eeModuleClassDescription = eeModuleDescription.addOrGetLocalClassDescription(declaringClass.name().toString());
                this.processField(deploymentUnit, annotation, fieldInfo, eeModuleClassDescription);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)annotationTarget;
                declaringClass = methodInfo.declaringClass();
                eeModuleClassDescription = eeModuleDescription.addOrGetLocalClassDescription(declaringClass.name().toString());
                this.processMethod(deploymentUnit, annotation, methodInfo, eeModuleClassDescription);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            declaringClass = (ClassInfo)annotationTarget;
            EEModuleClassDescription eeModuleClassDescription2 = eeModuleDescription.addOrGetLocalClassDescription(declaringClass.name().toString());
            this.processClass(deploymentUnit, annotation, eeModuleClassDescription2);
        }
    }

    private void processField(DeploymentUnit deploymentUnit, AnnotationInstance annotation, FieldInfo fieldInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : declaredName;
        DotName declaredTypeDotName = fieldInfo.type().name();
        DotName injectionTypeDotName = declaredTypeDotName == null || declaredTypeDotName.toString().equals(Object.class.getName()) ? fieldInfo.type().name() : declaredTypeDotName;
        String injectionType = injectionTypeDotName.toString();
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, injectionType, eeModuleClassDescription);
        if (bindingSource != null) {
            BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, bindingSource);
            eeModuleClassDescription.getBindingConfigurations().add(bindingConfiguration);
            FieldInjectionTarget injectionTarget = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, fieldInfo.type().name().toString());
            LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
            ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration((InjectionTarget)injectionTarget, (InjectionSource)injectionSource);
            eeModuleClassDescription.addResourceInjection(injectionConfiguration);
        }
    }

    private void processMethod(DeploymentUnit deploymentUnit, AnnotationInstance annotation, MethodInfo methodInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            eeModuleClassDescription.setInvalid(JpaLogger.ROOT_LOGGER.setterMethodOnlyAnnotation(annotation.name().toString(), methodInfo));
            return;
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4);
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : declaredName;
        String injectionType = methodInfo.args()[0].name().toString();
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, injectionType, eeModuleClassDescription);
        if (bindingSource != null) {
            BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, bindingSource);
            eeModuleClassDescription.getBindingConfigurations().add(bindingConfiguration);
            MethodInjectionTarget injectionTarget = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, methodInfo.args()[0].name().toString());
            LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
            ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration((InjectionTarget)injectionTarget, (InjectionSource)injectionSource);
            eeModuleClassDescription.addResourceInjection(injectionConfiguration);
        }
    }

    private void processClass(DeploymentUnit deploymentUnit, AnnotationInstance annotation, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        this.bindClassSources(deploymentUnit, annotation, eeModuleClassDescription);
    }

    private void bindClassSources(DeploymentUnit deploymentUnit, AnnotationInstance annotation, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
        block7: {
            AnnotationInstance[] arrayPersistenceContexts;
            AnnotationValue containedPersistenceContexts;
            block8: {
                AnnotationInstance[] arrayPersistenceUnits;
                block6: {
                    if (!this.isPersistenceContext(annotation) && !this.isPersistenceUnit(annotation)) break block6;
                    String injectionTypeName = this.getClassLevelInjectionType(annotation);
                    InjectionSource injectionSource = this.getBindingSource(deploymentUnit, annotation, injectionTypeName, classDescription);
                    if (injectionSource == null) break block7;
                    AnnotationValue nameValue = annotation.value("name");
                    if (nameValue == null || nameValue.asString().isEmpty()) {
                        classDescription.setInvalid(JpaLogger.ROOT_LOGGER.classLevelAnnotationParameterRequired(annotation.name().toString(), classDescription.getClassName(), "name"));
                        return;
                    }
                    String name = nameValue.asString();
                    BindingConfiguration bindingConfiguration = new BindingConfiguration(name, injectionSource);
                    classDescription.getBindingConfigurations().add(bindingConfiguration);
                    break block7;
                }
                if (!this.isPersistenceUnits(annotation)) break block8;
                AnnotationValue containedPersistenceUnits = annotation.value("value");
                if (containedPersistenceUnits == null || (arrayPersistenceUnits = containedPersistenceUnits.asNestedArray()) == null) break block7;
                for (int source = 0; source < arrayPersistenceUnits.length; ++source) {
                    String injectionTypeName = this.getClassLevelInjectionType(arrayPersistenceUnits[source]);
                    InjectionSource injectionSource = this.getBindingSource(deploymentUnit, arrayPersistenceUnits[source], injectionTypeName, classDescription);
                    if (injectionSource == null) continue;
                    AnnotationValue nameValue = arrayPersistenceUnits[source].value("name");
                    if (nameValue == null || nameValue.asString().isEmpty()) {
                        classDescription.setInvalid(JpaLogger.ROOT_LOGGER.classLevelAnnotationParameterRequired(arrayPersistenceUnits[source].name().toString(), classDescription.getClassName(), "name"));
                        return;
                    }
                    String name = nameValue.asString();
                    BindingConfiguration bindingConfiguration = new BindingConfiguration(name, injectionSource);
                    classDescription.getBindingConfigurations().add(bindingConfiguration);
                }
                break block7;
            }
            if (this.isPersistenceContexts(annotation) && (containedPersistenceContexts = annotation.value("value")) != null && (arrayPersistenceContexts = containedPersistenceContexts.asNestedArray()) != null) {
                for (int source = 0; source < arrayPersistenceContexts.length; ++source) {
                    String injectionTypeName = this.getClassLevelInjectionType(arrayPersistenceContexts[source]);
                    InjectionSource injectionSource = this.getBindingSource(deploymentUnit, arrayPersistenceContexts[source], injectionTypeName, classDescription);
                    if (injectionSource == null) continue;
                    AnnotationValue nameValue = arrayPersistenceContexts[source].value("name");
                    if (nameValue == null || nameValue.asString().isEmpty()) {
                        classDescription.setInvalid(JpaLogger.ROOT_LOGGER.classLevelAnnotationParameterRequired(arrayPersistenceContexts[source].name().toString(), classDescription.getClassName(), "name"));
                        return;
                    }
                    String name = nameValue.asString();
                    BindingConfiguration bindingConfiguration = new BindingConfiguration(name, injectionSource);
                    classDescription.getBindingConfigurations().add(bindingConfiguration);
                }
            }
        }
    }

    private InjectionSource getBindingSource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, String injectionTypeName, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu = this.getPersistenceUnit(deploymentUnit, annotation, classDescription);
        if (pu == null) {
            return null;
        }
        String scopedPuName = pu.getScopedPersistenceUnitName();
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        if (this.isPersistenceContext(annotation)) {
            HashMap<String, String> properties;
            AnnotationInstance[] props;
            if (pu.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                classDescription.setInvalid(JpaLogger.ROOT_LOGGER.cannotInjectResourceLocalEntityManager());
                return null;
            }
            AnnotationValue pcType = annotation.value("type");
            PersistenceContextType type = pcType == null || PersistenceContextType.TRANSACTION.name().equals(pcType.asString()) ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED;
            AnnotationValue stType = annotation.value("synchronization");
            SynchronizationType synchronizationType = stType == null || SynchronizationType.SYNCHRONIZED.name().equals(stType.asString()) ? SynchronizationType.SYNCHRONIZED : SynchronizationType.UNSYNCHRONIZED;
            AnnotationValue value = annotation.value("properties");
            AnnotationInstance[] annotationInstanceArray = props = value != null ? value.asNestedArray() : null;
            if (props != null) {
                properties = new HashMap<String, String>();
                for (int source = 0; source < props.length; ++source) {
                    properties.put(props[source].value("name").asString(), props[source].value("value").asString());
                }
            } else {
                properties = null;
            }
            JPADeploymentSettings jpaDeploymentSettings = (JPADeploymentSettings)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(JpaAttachments.DEPLOYMENT_SETTINGS_KEY);
            return new PersistenceContextInjectionSource(type, synchronizationType, properties, puServiceName, deploymentUnit.getServiceRegistry(), scopedPuName, injectionTypeName, pu, jpaDeploymentSettings);
        }
        return new PersistenceUnitInjectionSource(puServiceName, deploymentUnit.getServiceRegistry(), injectionTypeName, pu);
    }

    private boolean isPersistenceContext(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceContext");
    }

    private boolean isPersistenceUnit(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceUnit");
    }

    private boolean isPersistenceContexts(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceContexts");
    }

    private boolean isPersistenceUnits(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceUnits");
    }

    private String getClassLevelInjectionType(AnnotationInstance annotation) {
        boolean isPC = annotation.name().local().equals("PersistenceContext");
        return isPC ? ENTITY_MANAGER_CLASS : ENTITY_MANAGERFACTORY_CLASS;
    }

    private PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit deploymentUnit, AnnotationInstance annotation, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
        AnnotationValue puName = annotation.value("unitName");
        String searchName = null;
        if (puName != null && (searchName = puName.asString()) != null) {
            searchName = SpecDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit).replaceProperties(searchName);
        }
        JpaLogger.ROOT_LOGGER.debugf("persistence unit search for unitName=%s referenced from class=%s (annotation=%s)", searchName, classDescription.getClassName(), annotation.toString());
        PersistenceUnitMetadata pu = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName);
        if (null == pu) {
            classDescription.setInvalid(JpaLogger.ROOT_LOGGER.persistenceUnitNotFound(searchName, deploymentUnit));
            return null;
        }
        return pu;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitServiceImpl.getPUServiceName(scopedPuName);
    }
}

