/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ModelNodeFormatter;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.OperationCommandWithDescription;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.common.Assert;

public class GenericTypeOperationHandler
extends BatchModeCommandHandler {
    private static final int DASH_OFFSET = 22;
    protected final String commandName;
    protected final String idProperty;
    protected final String nodeType;
    protected final ArgumentWithValue profile;
    protected final ArgumentWithValue name;
    protected final ArgumentWithValue operation;
    protected final Set<String> excludedOps;
    protected final ArgumentWithoutValue helpProperties;
    protected final ArgumentWithoutValue helpCommands;
    private final Map<String, CommandArgument> staticArgs = new HashMap<String, CommandArgument>();
    private Map<String, ArgumentValueConverter> propConverters;
    private Map<String, CommandLineCompleter> valueCompleters;
    private Map<String, OperationCommandWithDescription> customHandlers;
    private WritePropertyHandler writePropHandler;
    private Map<String, OperationCommand> opHandlers;
    private final boolean isChildNode;

    public GenericTypeOperationHandler(CommandContext ctx, String nodeType, String idProperty) {
        this(null, ctx, nodeType, idProperty);
    }

    public GenericTypeOperationHandler(String commandName, CommandContext ctx, String nodeType, String idProperty) {
        this(commandName, ctx, nodeType, idProperty, false);
    }

    public GenericTypeOperationHandler(String commandName, CommandContext ctx, String nodeType, String idProperty, boolean isChildNode) {
        this(commandName, ctx, nodeType, idProperty, isChildNode, "read-attribute", "read-children-names", "read-children-resources", "read-children-types", "read-operation-description", "read-operation-names", "read-resource-description", "validate-address", "write-attribute", "undefine-attribute", "whoami");
    }

    public GenericTypeOperationHandler(CommandContext ctx, String nodeType, String idProperty, String ... excludeOperations) {
        this(null, ctx, nodeType, idProperty, excludeOperations);
    }

    public GenericTypeOperationHandler(String commandName, CommandContext ctx, String nodeType, String idProperty, String ... excludeOperations) {
        this(commandName, ctx, nodeType, idProperty, false, excludeOperations);
    }

    public GenericTypeOperationHandler(String commandName, CommandContext ctx, String nodeType, String idProperty, final boolean isChildNode, String ... excludeOperations) {
        super(ctx, "generic-type-operation", true);
        String cmdName;
        this.isChildNode = isChildNode;
        Assert.checkNotEmptyParam("nodeType", nodeType);
        if (nodeType.startsWith("/profile=") || nodeType.startsWith("profile=")) {
            int nextSep = nodeType.indexOf(47, 7);
            if (nextSep < 0) {
                throw new IllegalArgumentException("Failed to determine the path after the profile in '" + nodeType + "'.");
            }
            this.nodeType = nodeType = nodeType.substring(nextSep);
        } else {
            this.nodeType = nodeType;
        }
        this.helpArg = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--help", "-h");
        this.addRequiredPath(nodeType);
        String string = cmdName = commandName == null ? this.getRequiredType() : commandName;
        if (isChildNode) {
            if (cmdName == null) {
                cmdName = this.requiredAddress.getNodeName();
            } else if (commandName == null) {
                throw new IllegalArgumentException("The child node path appears to end on a type: '" + nodeType + "'");
            }
        }
        this.commandName = cmdName;
        if (this.commandName == null) {
            throw new IllegalArgumentException("The node path doesn't end on a type: '" + nodeType + "'");
        }
        this.idProperty = idProperty;
        if (excludeOperations != null) {
            this.excludedOps = new HashSet<String>(Arrays.asList(excludeOperations));
            if (isChildNode) {
                this.excludedOps.add("add");
            }
        } else if (isChildNode) {
            this.excludedOps = new HashSet<String>();
            this.excludedOps.add("add");
        } else {
            this.excludedOps = Collections.emptySet();
        }
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!GenericTypeOperationHandler.this.isDependsOnProfile()) {
                    return false;
                }
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (profileName == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                if (!isChildNode) {
                    address.toNode(GenericTypeOperationHandler.this.getRequiredType(), "?");
                }
                Collection<String> ops = Util.getOperationNames(ctx, address);
                ops.removeAll(GenericTypeOperationHandler.this.excludedOps);
                if (GenericTypeOperationHandler.this.customHandlers != null) {
                    if (ops.isEmpty()) {
                        ops = GenericTypeOperationHandler.this.customHandlers.keySet();
                    } else {
                        ops = new HashSet<String>(ops);
                        for (Map.Entry entry : GenericTypeOperationHandler.this.customHandlers.entrySet()) {
                            if (((OperationCommandWithDescription)entry.getValue()).isAvailable(ctx)) {
                                ops.add((String)entry.getKey());
                                continue;
                            }
                            ops.remove(entry.getKey());
                        }
                    }
                }
                return ops;
            }
        }), 0, "--operation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation.addCantAppearAfter(this.helpArg);
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null || isChildNode) {
                    return Collections.emptyList();
                }
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    if (GenericTypeOperationHandler.this.profile == null) {
                        return Collections.emptyList();
                    }
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                return Util.getNodeNames(ctx.getModelControllerClient(), address, GenericTypeOperationHandler.this.getRequiredType());
            }
        }), idProperty == null ? "--name" : "--" + idProperty){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine()) || isChildNode) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name.addCantAppearAfter(this.helpArg);
        this.helpArg.addCantAppearAfter(this.name);
        this.helpProperties = new ArgumentWithoutValue(this, "--properties");
        this.helpProperties.addRequiredPreceding(this.helpArg);
        this.helpProperties.addCantAppearAfter(this.operation);
        this.helpCommands = new ArgumentWithoutValue(this, "--commands");
        this.helpCommands.addRequiredPreceding(this.helpArg);
        this.helpCommands.addCantAppearAfter(this.operation);
        this.helpCommands.addCantAppearAfter(this.helpProperties);
        this.helpProperties.addCantAppearAfter(this.helpCommands);
        this.staticArgs.put(this.helpArg.getFullName(), this.helpArg);
        this.staticArgs.put(this.helpCommands.getFullName(), this.helpCommands);
        this.staticArgs.put(this.helpProperties.getFullName(), this.helpProperties);
        this.staticArgs.put(this.profile.getFullName(), this.profile);
        this.staticArgs.put(this.name.getFullName(), this.name);
        this.staticArgs.put(this.operation.getFullName(), this.operation);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void addValueConverter(String propertyName, ArgumentValueConverter converter) {
        if (this.propConverters == null) {
            this.propConverters = new HashMap<String, ArgumentValueConverter>();
        }
        this.propConverters.put(propertyName, converter);
    }

    public void addValueCompleter(String propertyName, CommandLineCompleter completer) {
        if (this.valueCompleters == null) {
            this.valueCompleters = new HashMap<String, CommandLineCompleter>();
        }
        this.valueCompleters.put(propertyName, completer);
    }

    public void addHandler(String name, OperationCommandWithDescription handler) {
        if (this.customHandlers == null) {
            this.customHandlers = Collections.singletonMap(name, handler);
        } else {
            if (this.customHandlers.size() == 1) {
                Map<String, OperationCommandWithDescription> tmp = this.customHandlers;
                this.customHandlers = new HashMap<String, OperationCommandWithDescription>();
                this.customHandlers.putAll(tmp);
            }
            this.customHandlers.put(name, handler);
        }
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        OperationCommand handler;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs.get(name);
            }
        }
        catch (CommandFormatException e) {
            return null;
        }
        String op = this.operation.getValue(args);
        try {
            handler = this.getHandler(ctx, op);
        }
        catch (CommandLineException e) {
            return null;
        }
        return handler.getArgument(ctx, name);
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        OperationCommand handler;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        ArrayList<CommandArgument> arguments = new ArrayList<CommandArgument>();
        try {
            if (this.isChildNode) {
                arguments.addAll(this.staticArgs.values());
            } else if (!this.name.isValueComplete(args)) {
                return this.staticArgs.values();
            }
        }
        catch (CommandFormatException e) {
            return Collections.emptyList();
        }
        String op = this.operation.getValue(args);
        try {
            handler = this.getHandler(ctx, op);
        }
        catch (CommandLineException e) {
            return arguments;
        }
        arguments.addAll(handler.getArguments(ctx));
        return arguments;
    }

    private OperationCommand getHandler(CommandContext ctx, String op) throws CommandLineException {
        OperationCommand opHandler;
        if (op == null) {
            if (this.writePropHandler == null) {
                this.writePropHandler = new WritePropertyHandler();
                Iterator<AttributeDescription> props = this.getNodeProperties(ctx);
                while (props.hasNext()) {
                    AttributeDescription prop = props.next();
                    if (!prop.isWriteAllowed()) continue;
                    CommandLineCompleter valueCompleter = null;
                    ArgumentValueConverter valueConverter = null;
                    if (this.propConverters != null) {
                        valueConverter = this.propConverters.get(prop.getName());
                    }
                    if (this.valueCompleters != null) {
                        valueCompleter = this.valueCompleters.get(prop.getName());
                    }
                    if (valueConverter == null) {
                        valueConverter = ArgumentValueConverter.DEFAULT;
                        ModelType propType = prop.getType();
                        if (propType != null) {
                            if (ModelType.BOOLEAN == propType) {
                                if (valueCompleter == null) {
                                    valueCompleter = SimpleTabCompleter.BOOLEAN;
                                }
                            } else if (ModelType.STRING == propType) {
                                valueConverter = ArgumentValueConverter.NON_OBJECT;
                            } else if (prop.getName().endsWith("properties")) {
                                valueConverter = ArgumentValueConverter.PROPERTIES;
                            } else if (ModelType.LIST == propType) {
                                valueConverter = this.asType(prop.getProperty("value-type")) == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                            }
                        }
                    }
                    ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                    this.writePropHandler.addArgument(arg);
                }
            }
            return this.writePropHandler;
        }
        if (this.customHandlers != null && this.customHandlers.containsKey(op) && (opHandler = (OperationCommand)this.customHandlers.get(op)) != null) {
            return opHandler;
        }
        if (this.opHandlers != null && (opHandler = this.opHandlers.get(op)) != null) {
            return opHandler;
        }
        ModelNode descr = this.getOperationDescription(ctx, op);
        if (this.opHandlers == null) {
            this.opHandlers = new HashMap<String, OperationCommand>();
        }
        OpHandler opHandler2 = new OpHandler(op);
        this.opHandlers.put(op, opHandler2);
        opHandler2.addArgument(this.headers);
        if (descr != null && descr.has("request-properties")) {
            List<Property> propList = descr.get("request-properties").asPropertyList();
            for (Property prop : propList) {
                ModelNode propDescr = prop.getValue();
                CommandLineCompleter valueCompleter = null;
                ArgumentValueConverter valueConverter = null;
                if (this.propConverters != null) {
                    valueConverter = this.propConverters.get(prop.getName());
                }
                if (this.valueCompleters != null) {
                    valueCompleter = this.valueCompleters.get(prop.getName());
                }
                if (valueConverter == null) {
                    valueConverter = ArgumentValueConverter.DEFAULT;
                    if (propDescr.has("type")) {
                        ModelType type = propDescr.get("type").asType();
                        if (ModelType.BOOLEAN == type) {
                            if (valueCompleter == null) {
                                valueCompleter = SimpleTabCompleter.BOOLEAN;
                            }
                        } else if (ModelType.STRING == type) {
                            valueConverter = ArgumentValueConverter.NON_OBJECT;
                        } else if (prop.getName().endsWith("properties")) {
                            valueConverter = ArgumentValueConverter.PROPERTIES;
                        } else if (ModelType.LIST == type) {
                            valueConverter = propDescr.hasDefined("value-type") && this.asType(propDescr.get("value-type")) == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                        }
                    }
                }
                ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                opHandler2.addArgument(arg);
            }
        }
        return opHandler2;
    }

    protected ModelType asType(ModelNode type) {
        if (type == null) {
            return null;
        }
        try {
            return type.asType();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return true;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        return true;
    }

    @Override
    public void addArgument(CommandArgument arg) {
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        OperationCommand opHandler;
        String operation = this.operation.getValue(ctx.getParsedCommandLine());
        try {
            opHandler = this.getHandler(ctx, operation);
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (CommandLineException e) {
            throw new CommandFormatException("Command is not supported or unavailable in the current context", e);
        }
        return opHandler.buildRequest(ctx);
    }

    @Override
    public void cliEvent(CliEvent event, CommandContext ctx) {
        super.cliEvent(event, ctx);
        if (event == CliEvent.DISCONNECTED) {
            this.opHandlers = null;
            this.writePropHandler = null;
        }
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode opResponse, boolean composite) throws CommandFormatException {
        if (!Util.isSuccess(opResponse)) {
            throw new CommandFormatException(Util.getFailureDescription(opResponse));
        }
        StringBuilder buf = this.formatResponse(ctx, opResponse, composite, null);
        if (buf != null) {
            ctx.printLine(buf.toString());
        }
    }

    protected StringBuilder formatResponse(CommandContext ctx, ModelNode opResponse, boolean composite, StringBuilder buf) throws CommandFormatException {
        Set<String> keys;
        if (opResponse.hasDefined("result")) {
            ModelNode result = opResponse.get("result");
            if (composite) {
                try {
                    keys = result.keys();
                }
                catch (Exception e) {
                    throw new CommandFormatException("Failed to get step results from a composite operation response " + opResponse);
                }
                for (String key : keys) {
                    ModelNode stepResponse = result.get(key);
                    buf = this.formatResponse(ctx, stepResponse, false, buf);
                }
            } else {
                ModelNodeFormatter.ModelNodeFormatterBase formatter = ModelNodeFormatter.Factory.forType(result.getType());
                if (buf == null) {
                    buf = new StringBuilder();
                }
                formatter.format(buf, 0, result);
            }
        }
        if (opResponse.hasDefined("response-headers")) {
            ModelNode headers = opResponse.get("response-headers");
            keys = headers.keys();
            SimpleTable table = new SimpleTable(2, ctx.getTerminalWidth());
            for (String key : keys) {
                table.addLine(key + ':', headers.get(key).asString());
            }
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(Util.LINE_SEPARATOR);
            }
            table.append(buf, false);
        }
        return buf;
    }

    @Override
    protected void printHelp(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.helpProperties.isPresent(args)) {
            this.printProperties(ctx, this.getNodeProperties(ctx));
            return;
        }
        if (this.helpCommands.isPresent(args)) {
            this.printSupportedCommands(ctx);
            return;
        }
        String operationName = this.operation.getValue(args);
        if (operationName == null) {
            this.printNodeDescription(ctx);
            return;
        }
        ModelNode result = this.getOperationDescription(ctx, operationName);
        if (!result.hasDefined("description")) {
            throw new CommandLineException("Operation description is not available.");
        }
        ctx.printLine("\nDESCRIPTION:\n");
        this.formatText(ctx, result.get("description").asString(), 2);
        if (result.hasDefined("request-properties")) {
            this.printProperties(ctx, this.getAttributeIterator(result.get("request-properties").asPropertyList(), null));
        } else {
            this.printProperties(ctx, Collections.emptyIterator());
        }
    }

    protected void printProperties(CommandContext ctx, Iterator<AttributeDescription> props) {
        LinkedHashMap<String, StringBuilder> requiredProps = new LinkedHashMap<String, StringBuilder>();
        requiredProps.put(this.name.getFullName(), new StringBuilder().append("Required argument in commands which identifies the instance to execute the command against."));
        LinkedHashMap<String, StringBuilder> optionalProps = new LinkedHashMap<String, StringBuilder>();
        String accessType = null;
        while (props.hasNext()) {
            AttributeDescription attr = props.next();
            accessType = attr.getAccess();
            boolean required = attr.getBooleanProperty("required");
            StringBuilder descr = new StringBuilder();
            ModelType modelType = attr.getType();
            String type = modelType == null ? "no type info" : modelType.toString();
            String attrDescr = attr.getDescription();
            if (attrDescr != null) {
                descr.append('(');
                descr.append(type);
                if (accessType != null) {
                    descr.append(',').append(accessType);
                }
                descr.append(") ");
                descr.append(attrDescr);
            } else if (descr.length() == 0) {
                descr.append("no description.");
            }
            if (required) {
                if (this.idProperty != null && this.idProperty.equals(attr.getName())) {
                    if (descr.charAt(descr.length() - 1) != '.') {
                        descr.append('.');
                    }
                    ((StringBuilder)requiredProps.get(this.name.getFullName())).insert(0, ' ').insert(0, descr.toString());
                    continue;
                }
                requiredProps.put("--" + attr.getName(), descr);
                continue;
            }
            optionalProps.put("--" + attr.getName(), descr);
        }
        ctx.printLine("\n");
        if (accessType == null) {
            ctx.printLine("REQUIRED ARGUMENTS:\n");
        }
        for (String argName : requiredProps.keySet()) {
            this.formatProperty(ctx, argName, (CharSequence)requiredProps.get(argName));
        }
        if (!optionalProps.isEmpty()) {
            if (accessType == null) {
                ctx.printLine("\n\nOPTIONAL ARGUMENTS:\n");
            }
            for (String argName : optionalProps.keySet()) {
                this.formatProperty(ctx, argName, (CharSequence)optionalProps.get(argName));
            }
        }
    }

    public void printDescription(CommandContext ctx) throws CommandFormatException {
        this.printNodeDescription(ctx);
    }

    protected void printNodeDescription(CommandContext ctx) throws CommandFormatException {
        int i;
        int offset = 2;
        ctx.printLine("\nSYNOPSIS\n");
        StringBuilder buf = new StringBuilder();
        buf.append("  ").append(this.commandName).append(" --help [--properties | --commands] |\n");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            for (i = 0; i <= this.commandName.length() + offset; ++i) {
                buf.append(' ');
            }
            buf.append("--profile=<profile_name>\n");
        }
        for (i = 0; i <= this.commandName.length() + offset; ++i) {
            buf.append(' ');
        }
        buf.append('(').append(this.name.getFullName()).append("=<resource_id> (--<property>=<value>)*) |\n");
        for (i = 0; i <= this.commandName.length() + offset; ++i) {
            buf.append(' ');
        }
        buf.append("(<command> ").append(this.name.getFullName()).append("=<resource_id> (--<parameter>=<value>)*)");
        buf.append('\n');
        for (i = 0; i <= this.commandName.length() + offset; ++i) {
            buf.append(' ');
        }
        buf.append("[--headers={<operation_header> (;<operation_header>)*}]");
        ctx.printLine(buf.toString());
        ctx.printLine("\n\nDESCRIPTION\n");
        buf.setLength(0);
        buf.append("The command is used to manage resources of type ");
        buf.append(this.nodeType);
        buf.append(".");
        this.formatText(ctx, buf, offset);
        ctx.printLine("\n\nRESOURCE DESCRIPTION\n");
        if (this.isDependsOnProfile() && ctx.isDomainMode() && this.profile.getValue(ctx.getParsedCommandLine()) == null) {
            buf.setLength(0);
            buf.append("(Execute '");
            buf.append(this.commandName).append(" --profile=<profile_name> --help' to include the resource description here.)");
            this.formatText(ctx, buf, offset);
        } else if (ctx.getModelControllerClient() == null) {
            buf.setLength(0);
            buf.append("(Connection to the controller is required to be able to load the resource description)");
            this.formatText(ctx, buf, offset);
        } else {
            ModelNode request = this.initRequest(ctx);
            if (request == null) {
                return;
            }
            request.get("operation").set("read-resource-description");
            ModelNode result = null;
            try {
                result = ctx.getModelControllerClient().execute(request);
                if (!result.hasDefined("result")) {
                    throw new CommandFormatException("Node description is not available.");
                }
                if (!(result = result.get("result")).hasDefined("description")) {
                    throw new CommandFormatException("Node description is not available.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.setLength(0);
            if (result != null) {
                buf.append(result.get("description").asString());
            } else {
                buf.append("N/A. Please, open a jira issue at https://issues.jboss.org/browse/WFLY to get this fixed. Thanks!");
            }
            this.formatText(ctx, buf, offset);
        }
        ctx.printLine("\n\nARGUMENTS\n");
        this.formatProperty(ctx, "--help", "prints this content.");
        this.formatProperty(ctx, "--help --properties", "prints the list of the resource properties including their access-type (read/write/metric), value type, and the description.");
        this.formatProperty(ctx, "--help --commands", "prints the list of the commands available for the resource. To get the complete description of a specific command (including its parameters, their types and descriptions), execute " + this.commandName + " <command> --help.");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            this.formatProperty(ctx, "--profile", "the name of the profile the target resource belongs to.");
        }
        buf.setLength(0);
        if (this.idProperty == null) {
            buf.append("is the name of the resource that completes the path ").append(this.nodeType).append(" and ");
        } else {
            buf.append("corresponds to a property of the resource which ");
        }
        buf.append("is used to identify the resource against which the command should be executed.");
        this.formatProperty(ctx, this.name.getFullName(), buf);
        this.formatProperty(ctx, "<property>", "property name of the resource whose value should be updated. For a complete list of available property names, their types and descriptions, execute " + this.commandName + " --help --properties.");
        this.formatProperty(ctx, "<command>", "command name provided by the resource. For a complete list of available commands execute " + this.commandName + " --help --commands.");
        this.formatProperty(ctx, "<parameter>", "parameter name of the <command> provided by the resource. For a complete list of available parameter names of a specific <command>, their types and descriptions execute " + this.commandName + " <command> --help.");
        this.formatProperty(ctx, "--headers", "a list of operation headers separated by a semicolon. For the list of supported headers, please, refer to the domain management documentation or use tab-completion.");
    }

    protected void formatText(CommandContext ctx, CharSequence text, int offset) {
        int terminalWidth = ctx.getTerminalWidth();
        if (terminalWidth <= 0) {
            terminalWidth = 80;
        }
        StringBuilder target = new StringBuilder();
        if (offset >= terminalWidth) {
            target.append(text);
        } else {
            int startIndex = 0;
            while (startIndex < text.length()) {
                if (startIndex > 0) {
                    target.append(Util.LINE_SEPARATOR);
                }
                for (int i = 0; i < offset; ++i) {
                    target.append(' ');
                }
                int endIndex = startIndex + terminalWidth - offset;
                if (endIndex > text.length()) {
                    endIndex = text.length();
                    target.append(text.subSequence(startIndex, endIndex));
                    startIndex = endIndex;
                    continue;
                }
                while (endIndex >= startIndex && !Character.isWhitespace(text.charAt(endIndex))) {
                    --endIndex;
                }
                if (endIndex <= startIndex) {
                    endIndex = startIndex + terminalWidth - 2;
                    target.append(text.subSequence(startIndex, endIndex));
                    startIndex = endIndex;
                    continue;
                }
                target.append(text.subSequence(startIndex, endIndex));
                startIndex = endIndex + 1;
            }
        }
        ctx.printLine(target.toString());
    }

    protected void formatProperty(CommandContext ctx, String argName, CharSequence descr) {
        StringBuilder prop = new StringBuilder();
        prop.append(' ').append(argName);
        int spaces = 22 - prop.length();
        do {
            prop.append(' ');
        } while (--spaces >= 0);
        int terminalWidth = ctx.getTerminalWidth();
        if (terminalWidth <= 0) {
            terminalWidth = 80;
        }
        int dashIndex = prop.length();
        int textOffset = dashIndex + 3;
        int textLength = terminalWidth - textOffset;
        prop.append(" - ");
        if (descr.length() <= textLength) {
            prop.append(descr);
            prop.append(Util.LINE_SEPARATOR);
        } else {
            int lineStart = 0;
            int lineNo = 1;
            while (lineStart < descr.length()) {
                int lastCharIndex;
                prop.ensureCapacity(terminalWidth);
                if (lineStart > 0) {
                    if (lineNo == 3 && dashIndex > 22) {
                        textOffset = 24;
                        textLength = terminalWidth - textOffset;
                    }
                    for (int i = 0; i < textOffset; ++i) {
                        prop.append(' ');
                    }
                }
                if ((lastCharIndex = lineStart + textLength) >= descr.length()) {
                    lastCharIndex = descr.length();
                    prop.append(descr.subSequence(lineStart, lastCharIndex));
                    lineStart = lastCharIndex;
                } else {
                    while (lastCharIndex >= lineStart && !Character.isWhitespace(descr.charAt(lastCharIndex))) {
                        --lastCharIndex;
                    }
                    if (lastCharIndex <= lineStart) {
                        lastCharIndex = lineStart + textLength;
                        prop.append(descr.subSequence(lineStart, lastCharIndex));
                        lineStart = lastCharIndex;
                    } else {
                        prop.append(descr.subSequence(lineStart, lastCharIndex));
                        lineStart = lastCharIndex + 1;
                    }
                }
                prop.append(Util.LINE_SEPARATOR);
                ++lineNo;
            }
        }
        ctx.printLine(prop.toString());
    }

    protected void printSupportedCommands(CommandContext ctx) throws CommandLineException {
        List<String> list = this.getSupportedCommands(ctx);
        list.add("To read the description of a specific command execute '" + this.commandName + " command_name --help'.");
        for (String name : list) {
            ctx.printLine(name);
        }
    }

    protected List<String> getSupportedCommands(CommandContext ctx) throws CommandLineException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        request.get("operation").set("read-operation-names");
        if (ctx.getConfig().isAccessControl()) {
            request.get("access-control").set(true);
        }
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load a list of commands.", e);
        }
        if (!result.hasDefined("result")) {
            throw new CommandLineException("Operation names aren't available.");
        }
        List<ModelNode> nodeList = result.get("result").asList();
        ArrayList<String> supportedCommands = new ArrayList<String>(nodeList.size());
        if (!nodeList.isEmpty()) {
            for (ModelNode node : nodeList) {
                String opName = node.asString();
                if (this.excludedOps.contains(opName) || this.customHandlers != null && this.customHandlers.containsKey(opName)) continue;
                supportedCommands.add(opName);
            }
        }
        if (this.customHandlers != null) {
            supportedCommands.addAll(this.customHandlers.keySet());
        }
        Collections.sort(supportedCommands);
        return supportedCommands;
    }

    protected Iterator<AttributeDescription> getNodeProperties(CommandContext ctx) throws CommandLineException {
        ModelNode result;
        if (ctx.getModelControllerClient() == null) {
            throw new CommandLineException("Failed to load target attributes: not connected");
        }
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return Collections.emptyIterator();
        }
        request.get("operation").set("read-resource-description");
        if (ctx.getConfig().isAccessControl()) {
            request.get("access-control").set("combined-descriptions");
        }
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return Collections.emptyIterator();
        }
        if (!result.hasDefined("result")) {
            return Collections.emptyIterator();
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            return Collections.emptyIterator();
        }
        ModelNode accessControl = ctx.getConfig().isAccessControl() ? (result.has("access-control") ? result.get("access-control") : null) : null;
        return this.getAttributeIterator(result.get("attributes").asPropertyList(), accessControl);
    }

    protected Iterator<AttributeDescription> getAttributeIterator(final List<Property> props, ModelNode accessControl) {
        ModelNode def;
        final ModelNode attrAccessControl = accessControl != null ? (accessControl.has("default") ? ((def = accessControl.get("default")).has("attributes") ? def.get("attributes") : null) : null) : null;
        return new Iterator<AttributeDescription>(){
            final Iterator<Property> properties;
            private Property current;
            private AttributeDescription descr;
            {
                this.properties = props.iterator();
                this.descr = new AttributeDescription(){

                    @Override
                    public String getName() {
                        return current.getName();
                    }

                    @Override
                    public ModelType getType() {
                        ModelNode value = this.getProperty("type");
                        return value == null ? null : value.asType();
                    }

                    @Override
                    public String getAccess() {
                        if (attrAccessControl != null && attrAccessControl.has(current.getName())) {
                            ModelNode accessSpec = attrAccessControl.get(current.getName());
                            StringBuilder buf = new StringBuilder();
                            if (accessSpec.get("read").asBoolean()) {
                                buf.append("read").append('-');
                            }
                            if (accessSpec.get("write").asBoolean()) {
                                buf.append("write");
                                if (buf.length() == 5) {
                                    buf.append("-only");
                                }
                            } else {
                                buf.append("only");
                            }
                            return buf.toString();
                        }
                        ModelNode value = this.getProperty("access-type");
                        return value == null ? null : value.asString();
                    }

                    @Override
                    public boolean isWriteAllowed() {
                        if (attrAccessControl != null && attrAccessControl.has(current.getName())) {
                            ModelNode accessSpec = attrAccessControl.get(current.getName());
                            return accessSpec.get("write").asBoolean();
                        }
                        ModelNode value = this.getProperty("access-type");
                        if (value == null) {
                            return false;
                        }
                        return "read-write".equals(value.asString());
                    }

                    @Override
                    public String getDescription() {
                        ModelNode value = this.getProperty("description");
                        return value == null ? null : value.asString();
                    }

                    @Override
                    public ModelNode getProperty(String name) {
                        if (current.getValue().has(name)) {
                            return current.getValue().get(name);
                        }
                        return null;
                    }

                    @Override
                    public boolean getBooleanProperty(String name) {
                        if (current.getValue().has(name)) {
                            return current.getValue().get(name).asBoolean();
                        }
                        return false;
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return this.properties.hasNext();
            }

            @Override
            public AttributeDescription next() {
                this.current = this.properties.next();
                return this.descr;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ModelNode getOperationDescription(CommandContext ctx, String operationName) throws CommandLineException {
        ModelNode result;
        OperationCommandWithDescription handler;
        if (this.customHandlers != null && (handler = this.customHandlers.get(operationName)) != null) {
            return handler.getOperationDescription(ctx);
        }
        if (ctx.getModelControllerClient() == null) {
            throw new CommandLineException("Failed to load operation description: not connected");
        }
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return null;
        }
        request.get("operation").set("read-operation-description");
        request.get("name").set(operationName);
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute read-operation-description.", e);
        }
        if (!result.hasDefined("result")) {
            String msg = Util.getFailureDescription(result);
            if (msg == null) {
                msg = "Failed to load description for '" + operationName + "': " + result;
            }
            throw new CommandLineException(msg);
        }
        return result.get("result");
    }

    protected ModelNode initRequest(CommandContext ctx) throws CommandFormatException {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            String profileName = this.profile.getValue(ctx.getParsedCommandLine());
            if (profileName == null) {
                throw new CommandFormatException("WARNING: --profile argument is required for the complete description.");
            }
            address.add("profile", profileName);
        }
        for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
            address.add(node.getType(), node.getName());
        }
        if (!this.isChildNode) {
            address.add(this.getRequiredType(), "?");
        }
        return request;
    }

    class OpHandler
    extends ActionHandler {
        private final String opName;

        OpHandler(String opName) {
            this.opName = Assert.checkNotEmptyParam("opName", opName);
        }

        @Override
        public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
            ParsedCommandLine parsedArgs = ctx.getParsedCommandLine();
            ModelNode request = new ModelNode();
            ModelNode address = request.get("address");
            if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                String profile = GenericTypeOperationHandler.this.profile.getValue(parsedArgs);
                if (profile == null) {
                    throw new OperationFormatException("Required argument --profile is missing.");
                }
                address.add("profile", profile);
            }
            for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                address.add(node.getType(), node.getName());
            }
            if (!GenericTypeOperationHandler.this.isChildNode) {
                String name = GenericTypeOperationHandler.this.name.getValue(ctx.getParsedCommandLine(), true);
                address.add(GenericTypeOperationHandler.this.getRequiredType(), name);
            }
            request.get("operation").set(this.opName);
            for (String argName : parsedArgs.getPropertyNames()) {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && argName.equals("--profile")) continue;
                if (this.args.isEmpty()) {
                    if (argName.equals(GenericTypeOperationHandler.this.name.getFullName())) continue;
                    throw new CommandFormatException("Command '" + GenericTypeOperationHandler.this.operation + "' is not expected to have arguments other than " + GenericTypeOperationHandler.this.name.getFullName() + ".");
                }
                ArgumentWithValue arg = (ArgumentWithValue)this.args.get(argName);
                if (arg == null) {
                    if (argName.equals(GenericTypeOperationHandler.this.name.getFullName())) continue;
                    throw new CommandFormatException("Unrecognized argument " + argName + " for command '" + this.opName + "'.");
                }
                String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
                ModelNode nodeValue = arg.toModelNode(ctx);
                request.get(propName).set(nodeValue);
            }
            return request;
        }
    }

    private class WritePropertyHandler
    extends ActionHandler {
        private WritePropertyHandler() {
        }

        @Override
        public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
            String profile;
            String name = GenericTypeOperationHandler.this.name.getValue(ctx.getParsedCommandLine(), false);
            if (!GenericTypeOperationHandler.this.isChildNode && name == null) {
                throw new CommandFormatException("Required argument '" + GenericTypeOperationHandler.this.name.getFullName() + "' is missing.");
            }
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            ParsedCommandLine args = ctx.getParsedCommandLine();
            if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                profile = GenericTypeOperationHandler.this.profile.getValue(args);
                if (profile == null) {
                    throw new OperationFormatException("--profile argument value is missing.");
                }
            } else {
                profile = null;
            }
            Map nodeProps = this.args;
            for (String argName : args.getPropertyNames()) {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && argName.equals("--profile") || GenericTypeOperationHandler.this.name.getFullName().equals(argName)) continue;
                ArgumentWithValue arg = (ArgumentWithValue)nodeProps.get(argName);
                if (arg == null) {
                    throw new CommandFormatException("Unrecognized argument name '" + argName + "'");
                }
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                if (profile != null) {
                    builder.addNode("profile", profile);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    builder.addNode(node.getType(), node.getName());
                }
                builder.addNode(GenericTypeOperationHandler.this.getRequiredType(), name);
                builder.setOperationName("write-attribute");
                String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
                builder.addProperty("name", propName);
                ModelNode nodeValue = arg.toModelNode(ctx);
                builder.getModelNode().get("value").set(nodeValue);
                steps.add(builder.buildRequest());
            }
            return composite;
        }
    }

    private abstract class ActionHandler
    implements CommandHandler,
    OperationCommand {
        protected Map<String, CommandArgument> args = Collections.emptyMap();

        private ActionHandler() {
        }

        void addArgument(CommandArgument arg) {
            Assert.checkNotNullParam("arg", arg);
            if (this.args.isEmpty()) {
                this.args = new HashMap<String, CommandArgument>();
            }
            this.args.put(arg.getFullName(), arg);
        }

        @Override
        public boolean isAvailable(CommandContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBatchMode(CommandContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handle(CommandContext ctx) throws CommandLineException {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommandArgument getArgument(CommandContext ctx, String name) {
            return this.args.get(name);
        }

        @Override
        public boolean hasArgument(CommandContext ctx, String name) {
            return this.args.containsKey(name);
        }

        @Override
        public boolean hasArgument(CommandContext ctx, int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CommandArgument> getArguments(CommandContext ctx) {
            return this.args.values();
        }
    }

    static interface AttributeDescription {
        public String getName();

        public ModelType getType();

        public String getAccess();

        public boolean isWriteAllowed();

        public String getDescription();

        public ModelNode getProperty(String var1);

        public boolean getBooleanProperty(String var1);
    }
}

