/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.deployment;

import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYOTELEXT", length=4)
public interface OpenTelemetryExtensionLogger
extends BasicLogger {
    public static final OpenTelemetryExtensionLogger OTEL_LOGGER = (OpenTelemetryExtensionLogger)Logger.getMessageLogger(OpenTelemetryExtensionLogger.class, (String)OpenTelemetryExtensionLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating OpenTelemetry Subsystem")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2, value="OpenTelemetry Subsystem is processing deployment")
    public void processingDeployment();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping OpenTelemetry integration.")
    public void noCdiDeployment();

    @Message(id=4, value="Deployment %s requires use of the '%s' capability but it is not currently registered")
    public DeploymentUnitProcessingException deploymentRequiresCapability(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Error resolving the OpenTelemetry instance.")
    public void errorResolvingTelemetry(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="Deriving service name based on the deployment unit's name: %s")
    public void serviceNameDerivedFromDeploymentUnit(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=7, value="Registering %s as the OpenTelemetry Tracer")
    public void registeringTracer(String var1);

    @Message(id=8, value="An unsupported exporter was specified: '%s'.")
    public IllegalArgumentException unsupportedExporter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="Error resolving the tracer.")
    public void errorResolvingTracer(@Cause Exception var1);

    @Message(id=10, value="An unsupported span processor was specified: '%s'.")
    public IllegalArgumentException unsupportedSpanProcessor(String var1);

    @Message(id=11, value="Unrecognized value for sampler: '%s'.")
    public IllegalArgumentException unsupportedSampler(String var1);

    @Message(id=12, value="Invalid ratio. Must be between 0.0 and 1.0 inclusive")
    public IllegalArgumentException invalidRatio();
}

