/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator;

import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.annotation.Annotation;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaField;

public class WrapperBeanFieldAnnotator
implements Annotator {
    public void annotate(JavaAnnotatable field) {
        JavaField jField = null;
        if (!(field instanceof JavaField)) {
            throw new RuntimeException("WrapperBeanFiledAnnotator expect JavaField as input");
        }
        jField = (JavaField)field;
        String rawName = jField.getRawName();
        boolean hasEl = false;
        for (Annotation ann : jField.getJaxbAnnotaions()) {
            JAnnotation jaxbAnn;
            if (ann instanceof XmlMimeType) {
                JAnnotation mimeAnno = new JAnnotation(XmlMimeType.class);
                mimeAnno.addElement(new JAnnotationElement("value", (Object)((XmlMimeType)ann).value()));
                jField.addAnnotation(mimeAnno);
                continue;
            }
            if (ann instanceof XmlJavaTypeAdapter) {
                jaxbAnn = new JAnnotation(XmlJavaTypeAdapter.class);
                jaxbAnn.addElement(new JAnnotationElement("value", (Object)((XmlJavaTypeAdapter)ann).value()));
                jaxbAnn.addElement(new JAnnotationElement("type", (Object)((XmlJavaTypeAdapter)ann).type()));
                jField.addAnnotation(jaxbAnn);
                continue;
            }
            if (ann instanceof XmlAttachmentRef) {
                jaxbAnn = new JAnnotation(XmlAttachmentRef.class);
                jField.addAnnotation(jaxbAnn);
                continue;
            }
            if (ann instanceof XmlList) {
                jaxbAnn = new JAnnotation(XmlList.class);
                jField.addAnnotation(jaxbAnn);
                continue;
            }
            if (!(ann instanceof XmlElement)) continue;
            hasEl = true;
            XmlElement el = (XmlElement)ann;
            JAnnotation xmlElementAnnotation = new JAnnotation(XmlElement.class);
            xmlElementAnnotation.addElement(new JAnnotationElement("name", (Object)el.name()));
            if (!StringUtils.isEmpty((String)el.namespace())) {
                xmlElementAnnotation.addElement(new JAnnotationElement("namespace", (Object)el.namespace()));
            }
            if (el.nillable()) {
                xmlElementAnnotation.addElement(new JAnnotationElement("nillable", (Object)el.nillable(), true));
            }
            if (el.required()) {
                xmlElementAnnotation.addElement(new JAnnotationElement("required", (Object)el.required(), true));
            }
            if (!StringUtils.isEmpty((String)el.defaultValue())) {
                xmlElementAnnotation.addElement(new JAnnotationElement("defaultValue", (Object)el.defaultValue()));
            }
            jField.addAnnotation(xmlElementAnnotation);
        }
        if (!hasEl) {
            JAnnotation xmlElementAnnotation = new JAnnotation(XmlElement.class);
            xmlElementAnnotation.addElement(new JAnnotationElement("name", (Object)rawName));
            if (!StringUtils.isEmpty((String)jField.getTargetNamespace())) {
                xmlElementAnnotation.addElement(new JAnnotationElement("namespace", (Object)jField.getTargetNamespace()));
            }
            jField.addAnnotation(xmlElementAnnotation);
        }
    }
}

