/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.SynchronizationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.jpa.config.JPADeploymentSettings;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.injectors.PersistenceContextInjectionSource;
import org.jboss.as.jpa.injectors.PersistenceUnitInjectionSource;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextSynchronizationType;
import org.jboss.metadata.javaee.spec.PersistenceContextTypeDescription;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceRefProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ResourceInjectionTarget resourceInjectionTarget, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        bindings.addAll(this.getPersistenceUnitRefs(deploymentUnit, environment, classLoader, deploymentReflectionIndex, resourceInjectionTarget));
        bindings.addAll(this.getPersistenceContextRefs(deploymentUnit, environment, classLoader, deploymentReflectionIndex, resourceInjectionTarget));
        return bindings;
    }

    private List<BindingConfiguration> getPersistenceUnitRefs(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, ResourceInjectionTarget resourceInjectionTarget) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
        if (environment.getEnvironment() == null) {
            return bindingConfigurations;
        }
        PersistenceUnitReferencesMetaData persistenceUnitRefs = environment.getEnvironment().getPersistenceUnitRefs();
        if (persistenceUnitRefs != null) {
            if (!persistenceUnitRefs.isEmpty()) {
                JPADeploymentMarker.mark((DeploymentUnit)deploymentUnit);
            }
            for (PersistenceUnitReferenceMetaData puRef : persistenceUnitRefs) {
                String name = puRef.getName();
                String persistenceUnitName = puRef.getPersistenceUnitName();
                String lookup = puRef.getLookupName();
                if (!this.isEmpty(lookup) && !this.isEmpty(persistenceUnitName)) {
                    throw JpaLogger.ROOT_LOGGER.cannotSpecifyBoth("<lookup-name>", lookup, "persistence-unit-name", persistenceUnitName, "<persistence-unit-ref/>", resourceInjectionTarget);
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                LookupInjectionSource injectionSource = new LookupInjectionSource(name);
                this.processInjectionTargets(resourceInjectionTarget, (InjectionSource)injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)puRef, EntityManagerFactory.class);
                BindingConfiguration bindingConfiguration = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else {
                    InjectionSource puBindingSource = this.getPersistenceUnitBindingSource(deploymentUnit, persistenceUnitName);
                    bindingConfiguration = new BindingConfiguration(name, puBindingSource);
                }
                bindingConfigurations.add(bindingConfiguration);
            }
        }
        return bindingConfigurations;
    }

    private List<BindingConfiguration> getPersistenceContextRefs(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, ResourceInjectionTarget resourceInjectionTarget) throws DeploymentUnitProcessingException {
        PersistenceContextReferencesMetaData persistenceUnitRefs;
        ArrayList<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
        RemoteEnvironment remoteEnvironment = environment.getEnvironment();
        if (remoteEnvironment == null) {
            return bindingConfigurations;
        }
        if (remoteEnvironment instanceof Environment && (persistenceUnitRefs = ((Environment)remoteEnvironment).getPersistenceContextRefs()) != null) {
            for (PersistenceContextReferenceMetaData puRef : persistenceUnitRefs) {
                String name = puRef.getName();
                String persistenceUnitName = puRef.getPersistenceUnitName();
                String lookup = puRef.getLookupName();
                if (!this.isEmpty(lookup) && !this.isEmpty(persistenceUnitName)) {
                    throw JpaLogger.ROOT_LOGGER.cannotSpecifyBoth("<lookup-name>", lookup, "persistence-unit-name", persistenceUnitName, "<persistence-context-ref/>", resourceInjectionTarget);
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                LookupInjectionSource injectionSource = new LookupInjectionSource(name);
                this.processInjectionTargets(resourceInjectionTarget, (InjectionSource)injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)puRef, EntityManager.class);
                BindingConfiguration bindingConfiguration = null;
                if (!this.isEmpty(lookup)) {
                    bindingConfiguration = new BindingConfiguration(name, (InjectionSource)new LookupInjectionSource(lookup));
                } else {
                    PropertiesMetaData properties = puRef.getProperties();
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (properties != null) {
                        for (PropertyMetaData prop : properties) {
                            map.put(prop.getKey(), prop.getValue());
                        }
                    }
                    PersistenceContextType type = puRef.getPersistenceContextType() == null || puRef.getPersistenceContextType() == PersistenceContextTypeDescription.TRANSACTION ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED;
                    SynchronizationType synchronizationType = puRef.getPersistenceContextSynchronization() == null || PersistenceContextSynchronizationType.Synchronized.equals((Object)puRef.getPersistenceContextSynchronization()) ? SynchronizationType.SYNCHRONIZED : SynchronizationType.UNSYNCHRONIZED;
                    InjectionSource pcBindingSource = this.getPersistenceContextBindingSource(deploymentUnit, persistenceUnitName, type, synchronizationType, map);
                    bindingConfiguration = new BindingConfiguration(name, pcBindingSource);
                }
                bindingConfigurations.add(bindingConfiguration);
            }
        }
        return bindingConfigurations;
    }

    private InjectionSource getPersistenceUnitBindingSource(DeploymentUnit deploymentUnit, String unitName) throws DeploymentUnitProcessingException {
        String searchName = this.isEmpty(unitName) ? null : unitName;
        PersistenceUnitMetadata pu = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName);
        if (null == pu) {
            throw new DeploymentUnitProcessingException(JpaLogger.ROOT_LOGGER.persistenceUnitNotFound(searchName, deploymentUnit));
        }
        String scopedPuName = pu.getScopedPersistenceUnitName();
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        return new PersistenceUnitInjectionSource(puServiceName, deploymentUnit.getServiceRegistry(), EntityManagerFactory.class.getName(), pu);
    }

    private InjectionSource getPersistenceContextBindingSource(DeploymentUnit deploymentUnit, String unitName, PersistenceContextType type, SynchronizationType synchronizationType, Map properties) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu = this.getPersistenceUnit(deploymentUnit, unitName);
        String scopedPuName = pu.getScopedPersistenceUnitName();
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        JPADeploymentSettings jpaDeploymentSettings = (JPADeploymentSettings)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(JpaAttachments.DEPLOYMENT_SETTINGS_KEY);
        return new PersistenceContextInjectionSource(type, synchronizationType, properties, puServiceName, deploymentUnit.getServiceRegistry(), scopedPuName, EntityManager.class.getName(), pu, jpaDeploymentSettings);
    }

    private PersistenceUnitMetadata getPersistenceUnit(DeploymentUnit deploymentUnit, String puName) throws DeploymentUnitProcessingException {
        PersistenceUnitMetadata pu = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, puName);
        if (null == pu) {
            throw new DeploymentUnitProcessingException(JpaLogger.ROOT_LOGGER.persistenceUnitNotFound(puName, deploymentUnit));
        }
        return pu;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitServiceImpl.getPUServiceName(scopedPuName);
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

