/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.SecurityActions;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.permission.ElytronPermission;

public class JaspiAuthenticationContext {
    static final ElytronPermission CREATE_AUTH_CONTEXT = ElytronPermission.forName("createServerAuthenticationContext");
    private final SecurityDomain securityDomain;
    private final boolean integrated;
    private volatile SecurityIdentity securityIdentity = null;
    private final Set<String> roles = new HashSet<String>();

    JaspiAuthenticationContext(SecurityDomain securityDomain, boolean integrated) {
        this.securityDomain = securityDomain;
        this.integrated = integrated;
    }

    public static JaspiAuthenticationContext newInstance(SecurityDomain securityDomain, boolean integrated) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_AUTH_CONTEXT);
        }
        return new JaspiAuthenticationContext(Assert.checkNotNullParam("securityDomain", securityDomain), integrated);
    }

    public CallbackHandler createCallbackHandler() {
        return this.createCommonCallbackHandler(this.integrated);
    }

    private CallbackHandler createCommonCallbackHandler(final boolean integrated) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                try {
                    SecurityActions.doPrivileged(() -> {
                        this.handleOne(callbacks, 0);
                        return null;
                    });
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        if (e.getCause() instanceof UnsupportedCallbackException) {
                            throw (UnsupportedCallbackException)e.getCause();
                        }
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                    }
                    throw new IOException(e);
                }
            }

            /*
             * Unable to fully structure code
             */
            private void handleOne(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
                block31: {
                    block30: {
                        if (callbacks.length == index) {
                            return;
                        }
                        callback = callbacks[index];
                        if (!(callback instanceof PasswordValidationCallback)) break block30;
                        pvc = (PasswordValidationCallback)callback;
                        username = pvc.getUsername();
                        ElytronMessages.log.tracef("Handling PasswordValidationCallback for '%s'", (Object)username);
                        evidence = new PasswordGuessEvidence(pvc.getPassword());
                        try {
                            authenticated = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).authenticate(username, (Evidence)evidence);
                            pvc.setResult(true);
                            JaspiAuthenticationContext.access$102(JaspiAuthenticationContext.this, authenticated);
                        }
                        catch (Exception e) {
                            ElytronMessages.log.trace("Authentication failed", e);
                            pvc.setResult(false);
                        }
                        break block31;
                    }
                    if (!(callback instanceof CallerPrincipalCallback)) ** GOTO lbl72
                    ElytronMessages.log.trace("Handling CallerPrincipalCallback");
                    cpc = (CallerPrincipalCallback)callback;
                    originalPrincipal = cpc.getPrincipal();
                    callerName = cpc.getName();
                    callerPrincipal = originalPrincipal != null ? originalPrincipal : (callerName != null ? new NamePrincipal(callerName) : null);
                    ElytronMessages.log.tracef("Original Principal = '%s', Caller Name = '%s', Resulting Principal = '%s'", (Object)originalPrincipal, (Object)callerName, (Object)callerPrincipal);
                    authorizedIdentity = null;
                    if (JaspiAuthenticationContext.access$100(JaspiAuthenticationContext.this) != null) {
                        if (callerPrincipal != null) {
                            authorizationRequired = integrated != false && JaspiAuthenticationContext.access$100(JaspiAuthenticationContext.this).getPrincipal().equals(callerPrincipal) == false;
                            authorizedIdentity = JaspiAuthenticationContext.access$100(JaspiAuthenticationContext.this).createRunAsIdentity(callerPrincipal, authorizationRequired);
                        } else if (integrated) {
                            sac = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createNewAuthenticationContext();
                            try {
                                sac.importIdentity(JaspiAuthenticationContext.access$100(JaspiAuthenticationContext.this));
                                sac.authorize();
                                authorizedIdentity = sac.getAuthorizedIdentity();
                            }
                            finally {
                                if (sac != null) {
                                    sac.close();
                                }
                            }
                        } else {
                            authorizedIdentity = JaspiAuthenticationContext.access$100(JaspiAuthenticationContext.this);
                        }
                    } else {
                        if (callerPrincipal == null) {
                            this.handleOne(callbacks, index + 1);
                            return;
                        }
                        if (integrated) {
                            sac = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createNewAuthenticationContext();
                            try {
                                sac.setAuthenticationPrincipal(callerPrincipal);
                                if (!sac.authorize()) ** GOTO lbl63
                                authorizedIdentity = sac.getAuthorizedIdentity();
                            }
                            finally {
                                if (sac != null) {
                                    sac.close();
                                }
                            }
                        } else {
                            authorizedIdentity = JaspiAuthenticationContext.access$000(JaspiAuthenticationContext.this).createAdHocIdentity(callerPrincipal);
                        }
                    }
lbl63:
                    // 6 sources

                    if (authorizedIdentity != null) {
                        JaspiAuthenticationContext.access$102(JaspiAuthenticationContext.this, authorizedIdentity);
                        subject = cpc.getSubject();
                        if (subject != null && !subject.isReadOnly()) {
                            subject.getPrincipals().add(authorizedIdentity.getPrincipal());
                        }
                    } else {
                        throw ElytronMessages.log.authorizationFailed();
lbl72:
                        // 1 sources

                        if (callback instanceof GroupPrincipalCallback) {
                            ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                            ElytronMessages.log.trace("Handling GroupPrincipalCallback");
                            gpc = (GroupPrincipalCallback)callback;
                            groups = gpc.getGroups();
                            if (groups != null && groups.length > 0) {
                                JaspiAuthenticationContext.access$200(JaspiAuthenticationContext.this).addAll(Arrays.asList(groups));
                            }
                        } else {
                            CallbackUtil.unsupported(callback);
                            this.handleOne(callbacks, index + 1);
                        }
                    }
                }
                this.handleOne(callbacks, index + 1);
            }
        };
    }

    public SecurityIdentity getAuthorizedIdentity() throws IllegalStateException {
        SecurityIdentity securityIdentity = this.securityIdentity;
        if (securityIdentity != null && this.roles.size() > 0) {
            if (ElytronMessages.log.isTraceEnabled()) {
                Iterator<String> rolesIterator = this.roles.iterator();
                StringBuilder sb = new StringBuilder(rolesIterator.next());
                while (rolesIterator.hasNext()) {
                    sb.append(",").append(rolesIterator.next());
                }
                ElytronMessages.log.tracef("Assigning roles '%s' to resulting SecurityIdentity", (Object)sb.toString());
            }
            Roles roles = Roles.fromSet(this.roles);
            RoleMapper roleMapper = RoleMapper.constant(roles);
            SecurityIdentity temp = securityIdentity;
            securityIdentity = SecurityActions.doPrivileged(() -> temp.withDefaultRoleMapper(roleMapper));
        } else {
            ElytronMessages.log.trace("No roles request of CallbackHandler.");
        }
        return securityIdentity;
    }

    static /* synthetic */ SecurityDomain access$000(JaspiAuthenticationContext x0) {
        return x0.securityDomain;
    }

    static /* synthetic */ SecurityIdentity access$102(JaspiAuthenticationContext x0, SecurityIdentity x1) {
        x0.securityIdentity = x1;
        return x0.securityIdentity;
    }

    static /* synthetic */ SecurityIdentity access$100(JaspiAuthenticationContext x0) {
        return x0.securityIdentity;
    }

    static /* synthetic */ Set access$200(JaspiAuthenticationContext x0) {
        return x0.roles;
    }
}

