/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.metrics.MetricCollector;
import org.wildfly.extension.metrics.MetricRegistration;
import org.wildfly.extension.metrics.MetricsCollectorService;
import org.wildfly.extension.metrics.MetricsContextService;
import org.wildfly.extension.metrics.MetricsSubsystemDefinition;
import org.wildfly.extension.metrics.WildFlyMetricRegistry;
import org.wildfly.extension.metrics.WildFlyMetricRegistryService;
import org.wildfly.extension.metrics._private.MetricsLogger;
import org.wildfly.extension.metrics.deployment.DeploymentMetricProcessor;

class MetricsSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final MetricsSubsystemAdd INSTANCE = new MetricsSubsystemAdd();

    MetricsSubsystemAdd() {
        super(MetricsSubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        final List exposedSubsystems = MetricsSubsystemDefinition.EXPOSED_SUBSYSTEMS.unwrap((ExpressionResolver)context, model);
        final boolean exposeAnySubsystem = exposedSubsystems.remove("*");
        final String prefix = MetricsSubsystemDefinition.PREFIX.resolveModelAttribute(context, model).asStringOrNull();
        boolean securityEnabled = MetricsSubsystemDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean();
        WildFlyMetricRegistryService.install(context);
        MetricsCollectorService.install(context);
        MetricsContextService.install(context, securityEnabled);
        if (!context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.metrics.scan")) {
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                public void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor("metrics", Phase.INSTALL, 14165, (DeploymentUnitProcessor)new DeploymentMetricProcessor(exposeAnySubsystem, exposedSubsystems, prefix));
                }
            }, OperationContext.Stage.RUNTIME);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext operationContext, ModelNode modelNode) {
                    ServiceController serviceController = context.getServiceRegistry(false).getService(MetricsSubsystemDefinition.WILDFLY_COLLECTOR);
                    MetricCollector metricCollector = (MetricCollector)MetricCollector.class.cast(serviceController.getValue());
                    ServiceController wildflyRegistryController = context.getServiceRegistry(false).getService(MetricsSubsystemDefinition.METRICS_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
                    WildFlyMetricRegistry metricRegistry = (WildFlyMetricRegistry)WildFlyMetricRegistry.class.cast(wildflyRegistryController.getValue());
                    ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                    Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
                    MetricRegistration registration = new MetricRegistration(metricRegistry);
                    metricCollector.collectResourceMetrics(rootResource, rootResourceRegistration, Function.identity(), exposeAnySubsystem, exposedSubsystems, prefix, registration);
                }
            }, OperationContext.Stage.VERIFY);
        }
        MetricsLogger.LOGGER.activatingSubsystem();
    }
}

