/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.logic;

import com.google.common.base.Predicate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProxiedRequesterContext;

public class ProxiedRequesterPredicate
implements Predicate<MessageContext<?>> {
    @Nonnull
    @NonnullElements
    private final Set<String> entityIds;

    public ProxiedRequesterPredicate(@Nonnull @NonnullElements Collection<String> ids) {
        Constraint.isNotNull(ids, (String)"EntityID collection cannot be null");
        this.entityIds = new HashSet<String>(StringSupport.normalizeStringCollection(ids));
    }

    @Nullable
    public boolean apply(@Nullable MessageContext<?> input) {
        ProxiedRequesterContext ctx;
        ProxiedRequesterContext proxiedRequesterContext = ctx = input != null ? (ProxiedRequesterContext)input.getSubcontext(ProxiedRequesterContext.class) : null;
        if (ctx != null) {
            return !Collections.disjoint(this.entityIds, ctx.getRequesters());
        }
        return false;
    }
}

