/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointTypeFilter;
import org.jboss.wsf.spi.deployment.Service;

public class DefaultService
extends AbstractExtensible
implements Service {
    private final Deployment dep;
    private final List<Endpoint> endpoints = new LinkedList<Endpoint>();
    private volatile String contextRoot;
    private volatile String virtualHost;

    DefaultService(Deployment dep) {
        super(4, 4);
        this.dep = dep;
    }

    public Deployment getDeployment() {
        return this.dep;
    }

    public void addEndpoint(Endpoint endpoint) {
        endpoint.setService((Service)this);
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(Endpoint endpoint) {
        boolean done = this.endpoints.remove(endpoint);
        if (done) {
            endpoint.setService(null);
        }
        return done;
    }

    public List<Endpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public List<Endpoint> getEndpoints(EndpointTypeFilter filter) {
        LinkedList<Endpoint> result = new LinkedList<Endpoint>();
        for (Endpoint endpoint : this.endpoints) {
            if (!filter.accept(endpoint.getType())) continue;
            result.add(endpoint);
        }
        return Collections.unmodifiableList(result);
    }

    public Endpoint getEndpointByName(String shortName) {
        Endpoint retEndpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!ep.getShortName().equals(shortName)) continue;
            retEndpoint = ep;
            break;
        }
        return retEndpoint;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }
}

