/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.ContainerStateVerificationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartException;

class ServiceVerificationHelper
implements OperationStepHandler {
    static final OperationContext.AttachmentKey<Boolean> DEFFERED_ROLLBACK_ATTACHMENT = OperationContext.AttachmentKey.create(Boolean.class);
    private final StabilityMonitor monitor = new StabilityMonitor();

    ServiceVerificationHelper() {
    }

    StabilityMonitor getMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(OperationContext context, ModelNode operation) {
        HashSet failed = new HashSet();
        HashSet problems = new HashSet();
        try {
            this.monitor.awaitStability(failed, problems);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.operationCancelled());
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        finally {
            this.monitor.clear();
        }
        if (!failed.isEmpty() || !problems.isEmpty()) {
            ModelNode failureDescription = context.getFailureDescription();
            HashSet<ServiceName> unavailableServices = new HashSet<ServiceName>();
            HashSet<ServiceName> failedSet = new HashSet<ServiceName>();
            ModelNode failedList = null;
            for (ServiceController controller : failed) {
                if (failedList == null) {
                    failedList = failureDescription.get(ControllerLogger.ROOT_LOGGER.failedServices());
                }
                ServiceName serviceName = controller.getName();
                failedSet.add(serviceName);
                failedList.get(serviceName.getCanonicalName()).set(ServiceVerificationHelper.getServiceFailureDescription(controller.getStartException()));
            }
            ServiceRegistry registry = context.getServiceRegistry(false);
            ArrayList<String> problemList = new ArrayList<String>();
            for (ServiceController controller : problems) {
                Collection immediatelyUnavailable = controller.getUnavailableDependencies();
                StringBuilder missing = new StringBuilder();
                boolean direct = false;
                for (ServiceName missingSvc : immediatelyUnavailable) {
                    ServiceController depController = registry.getService(missingSvc);
                    if (depController != null && depController.getMode() != ServiceController.Mode.NEVER) continue;
                    unavailableServices.add(missingSvc);
                    direct = true;
                    if (missing.length() != 0) {
                        missing.append(", ");
                    }
                    missing.append(missingSvc.getCanonicalName());
                }
                if (!direct) continue;
                StringBuilder problem = new StringBuilder();
                problem.append(controller.getName().getCanonicalName());
                problem.append(" ").append(ControllerLogger.ROOT_LOGGER.servicesMissing(missing));
                problemList.add(problem.toString());
            }
            ServiceVerificationHelper.reportUnavailableRequiredServices(unavailableServices, failureDescription);
            ServiceVerificationHelper.reportImmediateDependants(problemList, failureDescription);
            if (context.isRollbackOnRuntimeFailure()) {
                context.attach(DEFFERED_ROLLBACK_ATTACHMENT, Boolean.TRUE);
                context.addStep(new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        context.setRollbackOnly();
                    }
                }, OperationContext.Stage.VERIFY);
            }
            context.attach(ContainerStateVerificationHandler.FAILURE_REPORTED_ATTACHMENT, Boolean.TRUE);
        }
    }

    private static void reportUnavailableRequiredServices(Set<ServiceName> unavailableServices, ModelNode failureDescription) {
        if (!unavailableServices.isEmpty()) {
            ModelNode requiredServicesNode = failureDescription.get(ControllerLogger.ROOT_LOGGER.missingRequiredServices());
            for (ServiceName serviceName : unavailableServices) {
                requiredServicesNode.add(serviceName.getCanonicalName());
            }
        }
    }

    private static void reportImmediateDependants(List<String> problemList, ModelNode failureDescription) {
        if (!problemList.isEmpty()) {
            ModelNode problemListNode = failureDescription.get(ControllerLogger.ROOT_LOGGER.servicesMissingDependencies());
            for (String problem : problemList) {
                problemListNode.add(problem);
            }
        }
    }

    private static ModelNode getServiceFailureDescription(StartException exception) {
        ModelNode result = new ModelNode();
        if (exception != null) {
            String msg = exception.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = exception.toString();
            }
            StringBuilder sb = new StringBuilder(msg);
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                sb.append("\n    Caused by: ");
                sb.append(cause.toString());
            }
            result.set(sb.toString());
        }
        return result;
    }

    static ModelNode extractFailedServicesDescription(ModelNode failureDescription) {
        return ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.failedServices(), failureDescription);
    }

    static ModelNode extractMissingServicesDescription(ModelNode failureDescription) {
        return ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.servicesMissingDependencies(), failureDescription);
    }

    static ModelNode extractTransitiveDependencyProblemDescription(ModelNode failureDescription) {
        ModelNode transitiveDependencyProblemDescription = null;
        ModelNode missingTransitiveDesc = ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencyProblem(), failureDescription);
        if (missingTransitiveDesc != null) {
            ModelNode missingTransitiveDeps = ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependents(), missingTransitiveDesc);
            ModelNode allMissingList = ServiceVerificationHelper.extractIfPresent(ControllerLogger.ROOT_LOGGER.missingTransitiveDependencies(), missingTransitiveDesc);
            if (allMissingList != null || missingTransitiveDeps != null) {
                transitiveDependencyProblemDescription = new ModelNode();
                if (missingTransitiveDeps != null) {
                    transitiveDependencyProblemDescription.get("services-missing-transitive-dependencies").set(missingTransitiveDeps);
                }
                if (allMissingList != null) {
                    transitiveDependencyProblemDescription.get("possible-causes").set(allMissingList);
                }
            }
        }
        return transitiveDependencyProblemDescription;
    }

    private static ModelNode extractIfPresent(String key, ModelNode modelNode) {
        ModelNode result = null;
        if (modelNode.hasDefined(key)) {
            result = modelNode.get(key);
        }
        return result;
    }
}

