/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.IOException;
import java.io.Writer;
import org.infinispan.commons.configuration.io.AbstractConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;

public class YamlConfigurationWriter
extends AbstractConfigurationWriter {
    public static final int INDENT = 2;
    private boolean openTag;
    private boolean attributes;

    public YamlConfigurationWriter(Writer writer) {
        super(writer, 2, true, NamingStrategy.CAMEL_CASE);
    }

    @Override
    public void writeStartDocument() {
    }

    @Override
    public void writeStartElement(String name) {
        this.writeStartElement0(name, false, true);
    }

    private void writeStartElement0(String name, boolean repeated, boolean explicit) {
        try {
            if (this.openTag) {
                this.nl();
            }
            AbstractConfigurationWriter.Tag parent = (AbstractConfigurationWriter.Tag)this.tagStack.peek();
            this.tagStack.push(new AbstractConfigurationWriter.Tag(name, repeated, explicit));
            this.writeIndent();
            if (parent != null && parent.isRepeating()) {
                this.writer.write("- ");
                if (!parent.getName().equals(name)) {
                    this.writeName(name);
                }
            } else {
                this.writeName(name);
            }
            this.openTag = true;
            this.attributes = false;
            this.indent();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    private void writeName(String name) throws IOException {
        this.writer.write(this.naming.convert(name));
        this.writer.write(": ");
    }

    @Override
    public void writeStartElement(String prefix, String namespace, String name) {
        this.writeStartElement(this.prefixName(prefix, namespace, name));
    }

    private String prefixName(String prefix, String namespace, String name) {
        if (prefix == null) {
            return name;
        }
        if (this.namespaces.containsKey(prefix)) {
            return prefix + ":" + name;
        }
        return namespace + ":" + name;
    }

    @Override
    public void writeStartListElement(String name, boolean explicit) {
        this.writeStartRepeatedElement(name, explicit);
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, String name, boolean explicit) {
        this.writeStartListElement(this.prefixName(prefix, namespace, name), explicit);
    }

    @Override
    public void writeStartMapElement(String name) {
        this.writeStartRepeatedElement(name, false);
    }

    @Override
    public void writeEndMapElement() {
        this.writeEndElement();
    }

    @Override
    public void writeStartMapEntry(String name, String key, String value) {
        this.writeStartElement(value);
    }

    private void writeStartRepeatedElement(String name, boolean explicit) {
        this.writeStartElement0(name, true, explicit);
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeEndElement() {
        this.openTag = false;
        this.attributes = false;
        this.tagStack.pop();
        this.outdent();
    }

    @Override
    public void writeEndDocument() {
        if (!this.tagStack.isEmpty()) {
            throw new ConfigurationWriterException("Tag stack not empty: " + this.tagStack);
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        try {
            this.openTag = false;
            if (!this.attributes) {
                this.nl();
                this.attributes = true;
            }
            this.writeIndent();
            this.writer.write(this.naming.convert(name));
            this.writer.write(": \"");
            this.writer.write(value);
            this.writer.write(34);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeCharacters(String chars) {
        try {
            if (this.attributes) {
                this.writeAttribute("value", chars);
            } else {
                this.writer.write("\"");
                this.writer.write(chars);
                this.writer.write(34);
                this.nl();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEmptyElement(String name) {
        try {
            this.writeStartElement(name);
            this.writer.write(126);
            this.nl();
            this.writeEndElement();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeComment(String comment) {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }
}

