/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;
import org.slf4j.Logger;

public class PropertiesActionImpl
extends ActionImpl {
    public PropertiesActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public String getAcceptExtension() {
        return ".properties";
    }

    @Override
    protected ByteData apply(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        String outputName = this.transformBinaryType(inputName);
        if (outputName != null) {
            this.verbose("Properties file %s, relocated to %s", inputName, outputName);
            this.setResourceNames(inputName, outputName);
            return new ByteData(outputName, inputBytes, 0, inputLength);
        }
        this.setResourceNames(inputName, inputName);
        return new ByteData(inputName, inputBytes, 0, inputLength);
    }

    @Override
    public String getName() {
        return "Properties file relocate";
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PROPERTIES;
    }
}

