/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.health.HealthReporter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ApplicationScoped
public class HealthCenter {
    @Inject
    @Any
    Instance<HealthReporter> reporters;
    List<ReportedFailure> failures = new CopyOnWriteArrayList<ReportedFailure>();
    private volatile boolean initialized = false;

    public HealthReport getReadiness() {
        HealthReport.HealthReportBuilder builder = HealthReport.builder();
        for (HealthReporter r : this.reporters) {
            for (HealthReport.ChannelInfo channelInfo : r.getReadiness().getChannels()) {
                builder.add(channelInfo);
            }
        }
        for (ReportedFailure rf : this.failures) {
            builder.add(rf.source, false, rf.failure.getMessage());
        }
        return builder.build();
    }

    public HealthReport getLiveness() {
        HealthReport.HealthReportBuilder builder = HealthReport.builder();
        for (HealthReporter r : this.reporters) {
            for (HealthReport.ChannelInfo channelInfo : r.getLiveness().getChannels()) {
                builder.add(channelInfo);
            }
        }
        for (ReportedFailure rf : this.failures) {
            builder.add(rf.source, false, rf.failure.getMessage());
        }
        return builder.build();
    }

    public HealthReport getStartup() {
        HealthReport.HealthReportBuilder builder = HealthReport.builder();
        for (HealthReporter r : this.reporters) {
            for (HealthReport.ChannelInfo channelInfo : r.getStartup().getChannels()) {
                builder.add(channelInfo);
            }
        }
        return builder.build();
    }

    public void report(String source, Throwable cause) {
        this.failures.add(new ReportedFailure(source, cause));
    }

    public void reportApplicationFailure(String method, Throwable cause) {
        this.failures.add(new ReportedFailure("application-" + method, cause));
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void markInitialized() {
        this.initialized = true;
    }

    public static class ReportedFailure {
        final String source;
        final Throwable failure;

        public ReportedFailure(String source, Throwable failure) {
            this.source = source;
            this.failure = failure;
        }
    }
}

