/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public abstract class RetryOnFailureOperation<T>
extends HotRodOperation<T>
implements ChannelOperation {
    protected static final Log log = LogFactory.getLog(RetryOnFailureOperation.class, Log.class);
    private int retryCount = 0;
    private Set<SocketAddress> failedServers = null;
    private boolean triedCompleteRestart = false;
    private String currentClusterName;

    protected RetryOnFailureOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, DataFormat dataFormat) {
        super(requestCode, responseCode, codec, flags, cfg, cacheName, topologyId, channelFactory, dataFormat);
    }

    @Override
    public CompletableFuture<T> execute() {
        assert (!this.isDone());
        try {
            this.currentClusterName = this.channelFactory.getCurrentClusterName();
            if (log.isTraceEnabled()) {
                log.tracef("Requesting channel for operation %s", this);
            }
            this.fetchChannelAndInvoke(this.retryCount, this.failedServers);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return this;
    }

    @Override
    public void invoke(Channel channel) {
        try {
            if (log.isTraceEnabled()) {
                log.tracef("About to start executing operation %s on %s", this, channel);
            }
            this.executeOperation(channel);
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
        finally {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        if ((cause = this.handleException(cause, null, address)) != null) {
            this.completeExceptionally(cause);
        }
    }

    private void retryIfNotDone() {
        if (this.isDone()) {
            if (log.isTraceEnabled()) {
                log.tracef("Not retrying as done (exceptionally=%s), retryCount=%d", this.isCompletedExceptionally(), this.retryCount);
            }
        } else {
            this.reset();
            this.currentClusterName = this.channelFactory.getCurrentClusterName();
            this.fetchChannelAndInvoke(this.retryCount, this.failedServers);
        }
    }

    protected void reset() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }

    private Set<SocketAddress> updateFailedServers(SocketAddress address) {
        if (this.failedServers == null) {
            this.failedServers = new HashSet<SocketAddress>();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Add %s to failed servers", address);
        }
        this.failedServers.add(address);
        return this.failedServers;
    }

    @Override
    public void channelInactive(Channel channel) {
        if (this.isDone()) {
            return;
        }
        SocketAddress address = ChannelRecord.of(channel).getUnresolvedAddress();
        this.updateFailedServers(address);
        this.logAndRetryOrFail(Log.HOTROD.connectionClosed(address, address), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(Channel channel, Throwable cause) {
        SocketAddress address = channel == null ? null : ChannelRecord.of(channel).getUnresolvedAddress();
        if ((cause = this.handleException(cause, channel, address)) != null) {
            try {
                this.completeExceptionally(cause);
            }
            finally {
                if (channel != null) {
                    Log.HOTROD.closingChannelAfterError(channel, cause);
                    channel.close();
                }
            }
        }
    }

    protected Throwable handleException(Throwable cause, Channel channel, SocketAddress address) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof RemoteIllegalLifecycleStateException || cause instanceof IOException || cause instanceof TransportException) {
            if (Thread.interrupted()) {
                this.completeExceptionally(new InterruptedException());
                return null;
            }
            if (address != null) {
                this.updateFailedServers(address);
            }
            if (channel != null) {
                HeaderDecoder headerDecoder = (HeaderDecoder)channel.pipeline().get("header-decoder");
                if (headerDecoder != null) {
                    channel.pipeline().remove("header-decoder");
                }
                Log.HOTROD.closingChannelAfterError(channel, cause);
                channel.close();
                if (headerDecoder != null) {
                    headerDecoder.failoverClientListeners();
                }
            }
            this.logAndRetryOrFail(cause, true);
            return null;
        }
        if (cause instanceof RemoteNodeSuspectException) {
            this.logAndRetryOrFail(cause, false);
            return null;
        }
        if (cause instanceof HotRodClientException && ((HotRodClientException)cause).isServerError()) {
            this.completeExceptionally(cause);
            return null;
        }
        return cause;
    }

    protected void logAndRetryOrFail(Throwable e, boolean canSwitchCluster) {
        if (this.retryCount < this.channelFactory.getMaxRetries()) {
            if (log.isTraceEnabled()) {
                log.tracef(e, "Exception encountered in %s. Retry %d out of %d", this, this.retryCount, this.channelFactory.getMaxRetries());
            }
            ++this.retryCount;
            this.channelFactory.incrementRetryCount();
            this.retryIfNotDone();
        } else if (canSwitchCluster && !this.cfg.clusters().isEmpty()) {
            this.channelFactory.trySwitchCluster(this.currentClusterName, this.cacheName).whenComplete((status, throwable) -> {
                if (throwable != null) {
                    this.completeExceptionally((Throwable)throwable);
                    return;
                }
                switch (status) {
                    case SWITCHED: {
                        this.triedCompleteRestart = true;
                        this.retryCount = 0;
                        this.failedServers.clear();
                        break;
                    }
                    case NOT_SWITCHED: {
                        Log.HOTROD.exceptionAndNoRetriesLeft(this.retryCount, this.channelFactory.getMaxRetries(), e);
                        this.completeExceptionally(e);
                        break;
                    }
                    case IN_PROGRESS: {
                        log.trace("Cluster switch in progress, retry operation without increasing retry count");
                        break;
                    }
                    default: {
                        this.completeExceptionally(new IllegalStateException("Unknown cluster switch status: " + (Object)status));
                    }
                }
                this.retryIfNotDone();
            });
        } else {
            Log.HOTROD.exceptionAndNoRetriesLeft(this.retryCount, this.channelFactory.getMaxRetries(), e);
            this.completeExceptionally(e);
        }
    }

    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.channelFactory.fetchChannelAndInvoke(failedServers, this.cacheName, this);
    }

    protected abstract void executeOperation(Channel var1);
}

