/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakeConsumer;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakeFilter;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakePostOffice;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueueImplTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(QueueImplTest.class);
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService executor;
    private static final SimpleString queue1 = new SimpleString("queue1");
    private static final SimpleString address1 = new SimpleString("address1");

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
    }

    @After
    public void tearDown() throws Exception {
        this.scheduledExecutor.shutdownNow();
        this.executor.shutdownNow();
        super.tearDown();
    }

    @Test
    public void testName() {
        SimpleString name = new SimpleString("oobblle");
        QueueImpl queue = this.getNamedQueue(name);
        Assert.assertEquals((Object)name, (Object)queue.getName());
    }

    @Test
    public void testDurable() {
        QueueImpl queue = this.getNonDurableQueue();
        Assert.assertFalse((boolean)queue.isDurable());
        queue = this.getDurableQueue();
        Assert.assertTrue((boolean)queue.isDurable());
    }

    @Test
    public void testAddRemoveConsumer() throws Exception {
        FakeConsumer cons1 = new FakeConsumer();
        FakeConsumer cons2 = new FakeConsumer();
        FakeConsumer cons3 = new FakeConsumer();
        QueueImpl queue = this.getTemporaryQueue();
        Assert.assertEquals((long)0L, (long)queue.getConsumerCount());
        queue.addConsumer((Consumer)cons1);
        Assert.assertEquals((long)1L, (long)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons1);
        Assert.assertEquals((long)0L, (long)queue.getConsumerCount());
        queue.addConsumer((Consumer)cons1);
        queue.addConsumer((Consumer)cons2);
        queue.addConsumer((Consumer)cons3);
        Assert.assertEquals((long)3L, (long)queue.getConsumerCount());
        queue.removeConsumer((Consumer)new FakeConsumer());
        Assert.assertEquals((long)3L, (long)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons1);
        Assert.assertEquals((long)2L, (long)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons2);
        Assert.assertEquals((long)1L, (long)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons3);
        Assert.assertEquals((long)0L, (long)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons3);
    }

    @Test
    public void testGetFilter() {
        QueueImpl queue = this.getTemporaryQueue();
        Assert.assertNull((Object)queue.getFilter());
        Filter filter = new Filter(){

            public boolean match(Message message) {
                return false;
            }

            public boolean match(Map<String, String> map) {
                return false;
            }

            public boolean match(Filterable filterable) {
                return false;
            }

            public SimpleString getFilterString() {
                return null;
            }
        };
        queue = this.getFilteredQueue(filter);
        Assert.assertEquals((Object)filter, (Object)queue.getFilter());
    }

    @Test
    public void testSimpleadd() {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testRate() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            queue.addTail(ref);
        }
        Thread.sleep(1000L);
        Method getRate = QueueImpl.class.getDeclaredMethod("getRate", null);
        getRate.setAccessible(true);
        float rate = ((Float)getRate.invoke((Object)queue, null)).floatValue();
        Assert.assertTrue((rate <= 10.0f ? (byte)1 : 0) != 0);
        log.debug((Object)("Rate: " + rate));
    }

    @Test
    public void testSimpleNonDirectDelivery() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        queue.deliverNow();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testBusyConsumer() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer();
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        consumer.setStatusImmediate(HandleStatus.HANDLED);
        queue.deliverNow();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testBusyConsumerThenAddMoreMessages() throws Exception {
        MessageReference ref;
        int i;
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer();
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (i = 0; i < 10; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        for (i = 10; i < 20; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)20L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        consumer.setStatusImmediate(HandleStatus.HANDLED);
        for (i = 20; i < 30; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.deliverNow();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assert.assertEquals((long)30L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)30L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testaddHeadadd() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs1 = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs1.add(ref);
            queue.addTail(ref);
        }
        LinkedList<MessageReference> refs2 = new LinkedList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i + 10);
            refs2.addFirst(ref);
            queue.addHead(ref, false);
        }
        ArrayList<MessageReference> refs3 = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i + 20);
            refs3.add(ref);
            queue.addTail(ref);
        }
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        ArrayList<MessageReference> allRefs = new ArrayList<MessageReference>();
        allRefs.addAll(refs2);
        allRefs.addAll(refs1);
        allRefs.addAll(refs3);
        this.assertRefListsIdenticalRefs(allRefs, consumer.getReferences());
    }

    @Test
    public void testChangeConsumersAndDeliver() throws Exception {
        MessageReference ref4;
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref2 = this.generateReference((Queue)queue, i);
            refs.add(ref2);
            queue.addTail(ref2);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        FakeConsumer cons1 = new FakeConsumer();
        queue.addConsumer((Consumer)cons1);
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, cons1.getReferences());
        FakeConsumer cons2 = new FakeConsumer();
        queue.addConsumer((Consumer)cons2);
        Assert.assertEquals((long)2L, (long)queue.getConsumerCount());
        cons1.getReferences().clear();
        for (MessageReference ref3 : refs) {
            ref3.getMessage().refUp();
            queue.acknowledge(ref3);
        }
        refs.clear();
        for (int i = 0; i < 20; ++i) {
            MessageReference ref3;
            ref3 = this.generateReference((Queue)queue, i);
            refs.add(ref3);
            queue.addTail(ref3);
        }
        queue.deliverNow();
        Assert.assertEquals((long)20L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)20L, (long)queue.getDeliveringCount());
        Assert.assertEquals((long)10L, (long)cons1.getReferences().size());
        Assert.assertEquals((long)10L, (long)cons2.getReferences().size());
        cons1.getReferences().clear();
        cons2.getReferences().clear();
        for (MessageReference ref3 : refs) {
            queue.acknowledge(ref3);
        }
        refs.clear();
        FakeConsumer cons3 = new FakeConsumer();
        queue.addConsumer((Consumer)cons3);
        Assert.assertEquals((long)3L, (long)queue.getConsumerCount());
        for (int i = 0; i < 30; ++i) {
            ref4 = this.generateReference((Queue)queue, i);
            refs.add(ref4);
            queue.addTail(ref4);
        }
        queue.deliverNow();
        Assert.assertEquals((long)30L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)30L, (long)queue.getDeliveringCount());
        Assert.assertEquals((long)10L, (long)cons1.getReferences().size());
        Assert.assertEquals((long)10L, (long)cons2.getReferences().size());
        Assert.assertEquals((long)10L, (long)cons3.getReferences().size());
        queue.removeConsumer((Consumer)cons1);
        cons3.getReferences().clear();
        cons2.getReferences().clear();
        for (MessageReference ref4 : refs) {
            queue.acknowledge(ref4);
        }
        refs.clear();
        for (int i = 0; i < 20; ++i) {
            ref4 = this.generateReference((Queue)queue, i);
            refs.add(ref4);
            queue.addTail(ref4);
        }
        queue.deliverNow();
        Assert.assertEquals((long)20L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)20L, (long)queue.getDeliveringCount());
        Assert.assertEquals((long)10L, (long)cons2.getReferences().size());
        Assert.assertEquals((long)10L, (long)cons3.getReferences().size());
        queue.removeConsumer((Consumer)cons3);
        cons2.getReferences().clear();
        for (MessageReference ref4 : refs) {
            queue.acknowledge(ref4);
        }
        refs.clear();
        for (int i = 0; i < 10; ++i) {
            ref4 = this.generateReference((Queue)queue, i);
            refs.add(ref4);
            queue.addTail(ref4);
        }
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
        Assert.assertEquals((long)10L, (long)cons2.getReferences().size());
    }

    @Test
    public void testRoundRobinWithQueueing() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        queue.pause();
        FakeConsumer cons1 = new FakeConsumer();
        FakeConsumer cons2 = new FakeConsumer();
        queue.addConsumer((Consumer)cons1);
        queue.addConsumer((Consumer)cons2);
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.resume();
        long timeout = System.currentTimeMillis() + 5000L;
        while (cons1.getReferences().size() != 5 && timeout > System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
        while (cons2.getReferences().size() != 5 && timeout > System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
        Assert.assertEquals((long)5L, (long)cons1.getReferences().size());
        Assert.assertEquals((long)5L, (long)cons2.getReferences().size());
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = i % 2 == 0 ? cons1.getReferences().get(i / 2) : cons2.getReferences().get(i / 2);
            Assert.assertEquals(refs.get(i), (Object)ref);
        }
    }

    @Test
    public void testWithPriorities() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            ref.getMessage().setPriority((byte)i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.deliverNow();
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        List<MessageReference> receivedRefs = consumer.getReferences();
        Assert.assertEquals((long)refs.size(), (long)receivedRefs.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals(refs.get(i), (Object)receivedRefs.get(9 - i));
        }
    }

    @Test
    public void testConsumerWithFiltersDirect() throws Exception {
        this.testConsumerWithFilters(true);
    }

    @Test
    public void testConsumerWithFiltersQueueing() throws Exception {
        this.testConsumerWithFilters(false);
    }

    @Test
    public void testConsumerWithFilterAddAndRemove() {
        QueueImpl queue = this.getTemporaryQueue();
        FakeFilter filter = new FakeFilter("fruit", "orange");
        FakeConsumer consumer = new FakeConsumer(filter);
    }

    @Test
    public void testIterator() {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 20;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 20; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            queue.addTail(ref);
            refs.add(ref);
        }
        Assert.assertEquals((long)20L, (long)this.getMessageCount((Queue)queue));
        LinkedListIterator iterator = queue.iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        this.assertRefListsIdenticalRefs(refs, list);
    }

    private void awaitExecution() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        future.await(10000L);
    }

    @Test
    public void testConsumeWithFiltersAddAndRemoveConsumer() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeFilter filter = new FakeFilter("fruit", "orange");
        FakeConsumer consumer = new FakeConsumer(filter);
        queue.addConsumer((Consumer)consumer);
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        MessageReference ref1 = this.generateReference((Queue)queue, 1L);
        ref1.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("banana"));
        queue.addTail(ref1);
        MessageReference ref2 = this.generateReference((Queue)queue, 2L);
        ref2.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("orange"));
        queue.addTail(ref2);
        refs.add(ref2);
        Assert.assertEquals((long)2L, (long)this.getMessageCount((Queue)queue));
        this.awaitExecution();
        Assert.assertEquals((long)1L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)1L, (long)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        queue.acknowledge(ref2);
        queue.removeConsumer((Consumer)consumer);
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        refs.clear();
        consumer.clearReferences();
        MessageReference ref3 = this.generateReference((Queue)queue, 3L);
        ref3.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("banana"));
        queue.addTail(ref3);
        MessageReference ref4 = this.generateReference((Queue)queue, 4L);
        ref4.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("orange"));
        queue.addTail(ref4);
        refs.add(ref4);
        Assert.assertEquals((long)3L, (long)this.getMessageCount((Queue)queue));
        this.awaitExecution();
        Assert.assertEquals((long)1L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)1L, (long)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
    }

    @Test
    public void testBusyConsumerWithFilterFirstCallBusy() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "green");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        queue.deliverNow();
        consumer.setStatusImmediate(null);
        queue.deliverNow();
        List<MessageReference> receeivedRefs = consumer.getReferences();
        int currId = 0;
        for (MessageReference receeivedRef : receeivedRefs) {
            Assert.assertEquals((String)"messages received out of order", (long)receeivedRef.getMessage().getMessageID(), (long)currId++);
        }
    }

    @Test
    public void testBusyConsumerWithFilterThenAddMoreMessages() throws Exception {
        MessageReference ref;
        int i;
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (i = 0; i < 10; ++i) {
            ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "red");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        for (i = 10; i < 20; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            ref.getMessage().putStringProperty("color", "green");
            queue.addTail(ref);
        }
        Assert.assertEquals((long)20L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        consumer.setStatusImmediate(null);
        for (i = 20; i < 30; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)30L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
        List<MessageReference> receeivedRefs = consumer.getReferences();
        int currId = 10;
        for (MessageReference receeivedRef : receeivedRefs) {
            Assert.assertEquals((String)"messages received out of order", (long)receeivedRef.getMessage().getMessageID(), (long)currId++);
        }
    }

    @Test
    public void testConsumerWithFilterThenAddMoreMessages() throws Exception {
        MessageReference ref;
        int i;
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (i = 0; i < 10; ++i) {
            ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "red");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        queue.deliverNow();
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        for (i = 10; i < 20; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            ref.getMessage().putStringProperty("color", "green");
            queue.addTail(ref);
        }
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        Assert.assertEquals((long)20L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
        for (int i2 = 20; i2 < 30; ++i2) {
            MessageReference ref2 = this.generateReference((Queue)queue, i2);
            refs.add(ref2);
            ref2.getMessage().putStringProperty("color", "green");
            queue.addTail(ref2);
        }
        queue.deliverNow();
        Assert.assertEquals((long)20L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)30L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)20L, (long)queue.getDeliveringCount());
    }

    private void testConsumerWithFilters(boolean direct) throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeFilter filter = new FakeFilter("fruit", "orange");
        FakeConsumer consumer = new FakeConsumer(filter);
        if (direct) {
            queue.addConsumer((Consumer)consumer);
        }
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        MessageReference ref1 = this.generateReference((Queue)queue, 1L);
        ref1.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("banana"));
        queue.addTail(ref1);
        MessageReference ref2 = this.generateReference((Queue)queue, 2L);
        ref2.getMessage().putStringProperty(new SimpleString("cheese"), new SimpleString("stilton"));
        queue.addTail(ref2);
        MessageReference ref3 = this.generateReference((Queue)queue, 3L);
        ref3.getMessage().putStringProperty(new SimpleString("cake"), new SimpleString("sponge"));
        queue.addTail(ref3);
        MessageReference ref4 = this.generateReference((Queue)queue, 4L);
        ref4.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("orange"));
        refs.add(ref4);
        queue.addTail(ref4);
        MessageReference ref5 = this.generateReference((Queue)queue, 5L);
        ref5.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("apple"));
        queue.addTail(ref5);
        MessageReference ref6 = this.generateReference((Queue)queue, 6L);
        ref6.getMessage().putStringProperty(new SimpleString("fruit"), new SimpleString("orange"));
        refs.add(ref6);
        queue.addTail(ref6);
        if (!direct) {
            queue.addConsumer((Consumer)consumer);
            queue.deliverNow();
        }
        Assert.assertEquals((long)6L, (long)this.getMessageCount((Queue)queue));
        this.awaitExecution();
        Assert.assertEquals((long)2L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)2L, (long)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        queue.acknowledge(ref5);
        queue.acknowledge(ref6);
        queue.removeConsumer((Consumer)consumer);
        consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        Assert.assertEquals((long)4L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)4L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)4L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testMessageOrder() throws Exception {
        FakeConsumer consumer = new FakeConsumer();
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addHead(messageReference, false);
        queue.addTail(messageReference2);
        queue.addHead(messageReference3, false);
        Assert.assertEquals((long)0L, (long)consumer.getReferences().size());
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        Assert.assertEquals((long)3L, (long)consumer.getReferences().size());
        Assert.assertEquals((Object)messageReference3, (Object)consumer.getReferences().get(0));
        Assert.assertEquals((Object)messageReference, (Object)consumer.getReferences().get(1));
        Assert.assertEquals((Object)messageReference2, (Object)consumer.getReferences().get(2));
    }

    @Test
    public void testMessagesAdded() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addTail(messageReference);
        queue.addTail(messageReference2);
        queue.addTail(messageReference3);
        Assert.assertEquals((long)this.getMessagesAdded((Queue)queue), (long)3L);
    }

    @Test
    public void testGetReference() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addHead(messageReference, false);
        queue.addHead(messageReference2, false);
        queue.addHead(messageReference3, false);
        Assert.assertEquals((Object)queue.getReference(2L), (Object)messageReference2);
    }

    @Test
    public void testGetNonExistentReference() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addHead(messageReference, false);
        queue.addHead(messageReference2, false);
        queue.addHead(messageReference3, false);
        Assert.assertNull((Object)queue.getReference(5L));
    }

    @Test
    public void testPauseAndResumeWithAsync() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        queue.pause();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        queue.deliverNow();
        Assert.assertEquals((long)0L, (long)consumer.getReferences().size());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        queue.resume();
        this.awaitExecution();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testPauseAndResumeWithDirect() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.pause();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)0L, (long)queue.getScheduledCount());
        Assert.assertEquals((long)0L, (long)queue.getDeliveringCount());
        Assert.assertTrue((boolean)consumer.getReferences().isEmpty());
        queue.resume();
        this.awaitExecution();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assert.assertEquals((long)10L, (long)this.getMessageCount((Queue)queue));
        Assert.assertEquals((long)10L, (long)queue.getDeliveringCount());
    }

    @Test
    public void testResetMessagesAdded() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        queue.addTail(messageReference);
        queue.addTail(messageReference2);
        Assert.assertEquals((long)2L, (long)this.getMessagesAdded((Queue)queue));
        queue.resetMessagesAdded();
        Assert.assertEquals((long)0L, (long)this.getMessagesAdded((Queue)queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalIteratorOrder() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)true));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession(false, true, true));
        session.createQueue(new QueueConfiguration("myQueue").setAddress("myAddress"));
        ClientProducer producer = this.addClientProducer(session.createProducer("myAddress"));
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[1024]);
            message.putIntProperty("order", i);
            producer.send((Message)message);
        }
        producer.close();
        session.close();
        factory.close();
        locator.close();
        Queue queue = ((LocalQueueBinding)server.getPostOffice().getBinding(new SimpleString("myQueue"))).getQueue();
        LinkedListIterator totalIterator = queue.browserIterator();
        try {
            int i = 0;
            while (totalIterator.hasNext()) {
                MessageReference ref = (MessageReference)totalIterator.next();
                Assert.assertEquals((long)i++, (long)ref.getMessage().getIntProperty("order").intValue());
            }
        }
        finally {
            totalIterator.close();
            server.stop();
        }
    }

    @Test
    public void testGroupMessageWithManyConsumers() throws Exception {
        final CountDownLatch firstMessageHandled = new CountDownLatch(1);
        final CountDownLatch finished = new CountDownLatch(2);
        FakeConsumer groupConsumer = new FakeConsumer(){
            int count = 0;

            @Override
            public synchronized HandleStatus handle(MessageReference reference) {
                if (this.count == 0) {
                    ++this.count;
                    firstMessageHandled.countDown();
                    return HandleStatus.HANDLED;
                }
                if (this.count <= 2) {
                    ++this.count;
                    finished.countDown();
                    return HandleStatus.BUSY;
                }
                return HandleStatus.HANDLED;
            }
        };
        FakeConsumer noConsumer = new FakeConsumer(){

            @Override
            public synchronized HandleStatus handle(MessageReference reference) {
                Assert.fail((String)"this consumer isn't allowed to consume any message");
                throw new AssertionError();
            }
        };
        QueueImpl queue = new QueueImpl(1L, new SimpleString("address1"), queue1, null, null, false, true, false, this.scheduledExecutor, null, null, null, ArtemisExecutor.delegate((Executor)this.executor), null, null);
        queue.addConsumer((Consumer)groupConsumer);
        queue.addConsumer((Consumer)noConsumer);
        MessageReference firstMessageReference = this.generateReference((Queue)queue, 1L);
        SimpleString groupName = SimpleString.toSimpleString((String)"group");
        firstMessageReference.getMessage().putStringProperty(Message.HDR_GROUP_ID, groupName);
        MessageReference secondMessageReference = this.generateReference((Queue)queue, 2L);
        secondMessageReference.getMessage().putStringProperty(Message.HDR_GROUP_ID, groupName);
        queue.addTail(firstMessageReference, true);
        Assert.assertTrue((String)"first message isn't handled", (boolean)firstMessageHandled.await(3000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"group consumer isn't correctly set", (Object)groupConsumer, queue.getGroups().get(groupName));
        queue.addTail(secondMessageReference, true);
        boolean atLeastTwoDeliverAttempts = finished.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)atLeastTwoDeliverAttempts);
        Thread.sleep(1000L);
        Assert.assertEquals((String)"The second message should be in the queue", (long)1L, (long)queue.getMessageCount());
    }

    private QueueImpl getNonDurableQueue() {
        return this.getQueue(queue1, false, false, null);
    }

    private QueueImpl getDurableQueue() {
        return this.getQueue(queue1, true, false, null);
    }

    private QueueImpl getNamedQueue(SimpleString name) {
        return this.getQueue(name, false, true, null);
    }

    private QueueImpl getFilteredQueue(Filter filter) {
        return this.getQueue(queue1, false, true, filter);
    }

    private QueueImpl getTemporaryQueue() {
        return this.getQueue(queue1, false, true, null);
    }

    private QueueImpl getQueue(SimpleString name, boolean durable, boolean temporary, Filter filter) {
        return new QueueImpl(1L, address1, name, filter, null, durable, temporary, false, this.scheduledExecutor, (PostOffice)new FakePostOffice(), null, null, ArtemisExecutor.delegate((Executor)this.executor), null, null);
    }

    class AddtoQueueRunner
    implements Runnable {
        QueueImpl queue;
        MessageReference messageReference;
        boolean added = false;
        CountDownLatch countDownLatch;
        boolean first;

        AddtoQueueRunner(boolean first, QueueImpl queue, MessageReference messageReference, CountDownLatch countDownLatch) {
            this.queue = queue;
            this.messageReference = messageReference;
            this.countDownLatch = countDownLatch;
            this.first = first;
        }

        @Override
        public void run() {
            if (this.first) {
                this.queue.addHead(this.messageReference, false);
            } else {
                this.queue.addTail(this.messageReference);
            }
            this.added = true;
            this.countDownLatch.countDown();
        }
    }
}

