/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.ssl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SSLSupportTest
extends ActiveMQTestBase {
    private String storeProvider;
    private String storeType;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;

    @Parameterized.Parameters(name="storeProvider={0}, storeType={1}")
    public static Collection getParameters() {
        if (System.getProperty("java.vendor").contains("IBM")) {
            return Arrays.asList({TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS"}, {"IBMJCE", "JCEKS"});
        }
        return Arrays.asList({TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS"}, {"SunJCE", "JCEKS"}, {"SUN", "JKS"}, {"SunJSSE", "PKCS12"});
    }

    public SSLSupportTest(String storeProvider, String storeType) {
        this.storeProvider = storeProvider;
        this.storeType = storeType;
        String suffix = storeType.toLowerCase();
        if (storeType.equals("PKCS12")) {
            suffix = "p12";
        }
        this.keyStorePath = "server-keystore." + suffix;
        this.trustStorePath = "client-ca-truststore." + suffix;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.trustStorePassword = this.keyStorePassword = "securepass";
    }

    @Test
    public void testContextWithRightParameters() throws Exception {
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @Test
    public void testContextWithNullParameters() throws Exception {
        new SSLSupport().createContext();
    }

    @Test
    public void testContextWithKeyStorePathAsURL() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.keyStorePath);
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(url.toString()).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @Test
    public void testContextWithKeyStorePathAsFile() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.keyStorePath);
        File file = new File(url.toURI());
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(file.getAbsolutePath()).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @Test
    public void testContextWithBadKeyStorePath() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath("not a keystore").setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContextWithNullKeyStorePath() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(null).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testContextWithKeyStorePathAsRelativePath() throws Exception {
        File currentDir = new File(System.getProperty("user.dir"));
        if (!currentDir.getAbsolutePath().endsWith("tests")) {
            return;
        }
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath("../security-resources/" + this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @Test
    public void testContextWithBadKeyStorePassword() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword("bad password").setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContextWithNullKeyStorePassword() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(null).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
            Assert.fail();
        }
        catch (Exception e) {
            SSLSupportTest.assertFalse((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testContextWithBadTrustStorePath() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath("not a trust store").setTruststorePassword(this.trustStorePassword).createContext();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContextWithBadTrustStorePassword() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword("bad passord").createContext();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContextWithTrustAll() throws Exception {
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword("bad passord").setTrustAll(true).createContext();
    }
}

