/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.junit.Before;
import org.junit.Test;

public class StompWebSocketTest
extends StompTestBase {
    private ActiveMQServer server;

    @Test
    public void testConnect() throws Exception {
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.server = this.createServer();
        this.server.start();
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("protocols", "STOMP");
        params.put("port", 61614);
        TransportConfiguration stompTransport = new TransportConfiguration(NettyAcceptorFactory.class.getName(), params);
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(stompTransport).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).setPersistenceEnabled(this.isPersistenceEnabled()).addQueueConfiguration(new QueueConfiguration(StompWebSocketTest.getQueueName()).setDurable(Boolean.valueOf(false)));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config));
        return this.server;
    }

    protected static String getQueueName() {
        return "/queue/test";
    }
}

