/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class QueuePeristPauseTest
extends ActiveMQTestBase {
    @Test
    public void testPauseQueue() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(true, false);
        server.start();
        Queue queue = server.createQueue(new QueueConfiguration("q1").setRoutingType(RoutingType.ANYCAST));
        queue.pause(true);
        server.stop();
        server.start();
        for (i = 0; i < 4; ++i) {
            server.stop();
            server.start();
            queue = server.locateQueue(SimpleString.toSimpleString((String)"q1"));
            Assert.assertTrue((boolean)queue.isPaused());
        }
        queue.resume();
        for (i = 0; i < 4; ++i) {
            server.stop();
            server.start();
            queue = server.locateQueue(SimpleString.toSimpleString((String)"q1"));
            Assert.assertFalse((boolean)queue.isPaused());
        }
        server.stop();
    }
}

