/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SecurityPerAcceptorJmsTest
extends ActiveMQTestBase {
    @Parameterized.Parameter(value=0)
    public Protocol protocol;
    private ConnectionFactory cf;
    private final String URL = "tcp://127.0.0.1:61616";

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Protocol.CORE}, {Protocol.AMQP}, {Protocol.OPENWIRE});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        switch (this.protocol) {
            case CORE: {
                this.cf = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
                break;
            }
            case OPENWIRE: {
                this.cf = new ActiveMQConnectionFactory("tcp://127.0.0.1:61616");
                break;
            }
            case AMQP: {
                this.cf = new JmsConnectionFactory("amqp://localhost:61616");
            }
        }
    }

    @Test
    public void testJAASSecurityManagerAuthentication() throws Exception {
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true).addAcceptorConfiguration("netty", "tcp://127.0.0.1:61616?securityDomain=PropertiesLogin"), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQJAASSecurityManager(), (boolean)false));
        server.start();
        try (Connection c = this.cf.createConnection("first", "secret");){
            Thread.sleep(200L);
        }
        catch (JMSException e) {
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationNegative() throws Exception {
        SimpleString ADDRESS = new SimpleString("address");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager();
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().addAcceptorConfiguration("netty", "tcp://127.0.0.1:61616?securityDomain=PropertiesLogin").setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        roles = new HashSet();
        roles.add(new Role("programmers", false, true, false, false, true, true, false, false, true, false));
        server.getConfiguration().putSecurityRoles("ActiveMQ.Advisory.#", roles);
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(ADDRESS).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        Connection c = this.cf.createConnection("first", "secret");
        Session s = c.createSession(false, 1);
        try {
            MessageProducer producer = s.createProducer((Destination)s.createQueue(ADDRESS.toString()));
            producer.send(s.createMessage());
            Assert.fail((String)"should throw exception here");
        }
        catch (JMSException e) {
            e.printStackTrace();
            SecurityPerAcceptorJmsTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='SEND' on address address"));
        }
        try {
            MessageConsumer consumer = s.createConsumer((Destination)s.createQueue(ADDRESS.toString()));
            Assert.fail((String)"should throw exception here");
        }
        catch (JMSException e) {
            SecurityPerAcceptorJmsTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CONSUME' for queue address on address address"));
        }
        try {
            QueueBrowser browser = s.createBrowser(s.createQueue(ADDRESS.toString()));
            browser.getEnumeration();
            Assert.fail((String)"should throw exception here");
        }
        catch (JMSException e) {
            SecurityPerAcceptorJmsTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='BROWSE' for queue address on address address"));
        }
        c.close();
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositive() throws Exception {
        String ADDRESS = "address";
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true).addAcceptorConfiguration("netty", "tcp://127.0.0.1:61616?securityDomain=PropertiesLogin"), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)new ActiveMQJAASSecurityManager(), (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        Connection c = this.cf.createConnection("first", "secret");
        Session s = c.createSession(false, 1);
        try {
            MessageProducer producer = s.createProducer((Destination)s.createQueue("address"));
            producer.send(s.createMessage());
        }
        catch (JMSException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            MessageConsumer e = s.createConsumer((Destination)s.createQueue("address"));
        }
        catch (JMSException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            QueueBrowser browser = s.createBrowser(s.createQueue("address"));
            browser.getEnumeration();
        }
        catch (JMSException e) {
            Assert.fail((String)"should not throw exception here");
        }
        c.close();
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityPerAcceptorJmsTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }

    private static enum Protocol {
        CORE,
        AMQP,
        OPENWIRE;

    }
}

