/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RetryRule;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ReconnectTest
extends ActiveMQTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);

    @Test
    public void testReconnectNetty() throws Exception {
        this.internalTestReconnect(true);
    }

    @Test
    public void testReconnectInVM() throws Exception {
        this.internalTestReconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestReconnect(boolean isNetty) throws Exception {
        int pingPeriod = 1000;
        ActiveMQServer server = this.createServer(false, isNetty);
        server.start();
        ClientSessionInternal session = null;
        try {
            ServerLocator locator = this.createFactory(isNetty).setClientFailureCheckPeriod(1000L).setRetryInterval(500L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(-1).setConfirmationWindowSize(0x100000);
            ClientSessionFactory factory = this.createSessionFactory(locator);
            session = (ClientSessionInternal)factory.createSession();
            final AtomicInteger count = new AtomicInteger(0);
            final CountDownLatch latch = new CountDownLatch(1);
            session.addFailureListener(new SessionFailureListener(){

                public void connectionFailed(ActiveMQException me, boolean failedOver) {
                    count.incrementAndGet();
                    latch.countDown();
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                    this.connectionFailed(me, failedOver);
                }

                public void beforeReconnect(ActiveMQException exception) {
                }
            });
            server.stop();
            Thread.sleep(2000L);
            server.start();
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Thread.sleep(500L);
            Assert.assertEquals((long)1L, (long)count.get());
            locator.close();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            server.stop();
        }
    }

    @Test
    public void testMetadataAfterReconnectionNetty() throws Exception {
        this.internalMetadataAfterRetry(true);
    }

    @Test
    public void testMetadataAfterReconnectionInVM() throws Exception {
        this.internalMetadataAfterRetry(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalMetadataAfterRetry(boolean isNetty) throws Exception {
        int pingPeriod = 1000;
        ActiveMQServer server = this.createServer(false, isNetty);
        server.start();
        ClientSessionInternal session = null;
        try {
            for (int i = 0; i < 100; ++i) {
                ServerLocator locator = this.createFactory(isNetty);
                locator.setClientFailureCheckPeriod(1000L);
                locator.setRetryInterval(1L);
                locator.setRetryIntervalMultiplier(1.0);
                locator.setReconnectAttempts(-1);
                locator.setConfirmationWindowSize(-1);
                ClientSessionFactory factory = this.createSessionFactory(locator);
                session = (ClientSessionInternal)factory.createSession();
                session.addMetaData("meta1", "meta1");
                ServerSession[] sessions = this.countMetadata(server, "meta1", 1);
                Assert.assertEquals((long)1L, (long)sessions.length);
                AtomicInteger count = new AtomicInteger(0);
                final CountDownLatch latch = new CountDownLatch(1);
                session.addFailoverListener(new FailoverEventListener(){

                    public void failoverEvent(FailoverEventType eventType) {
                        if (eventType == FailoverEventType.FAILOVER_COMPLETED) {
                            latch.countDown();
                        }
                    }
                });
                sessions[0].getRemotingConnection().fail(new ActiveMQException("failure!"));
                Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
                sessions = this.countMetadata(server, "meta1", 1);
                Assert.assertEquals((long)1L, (long)sessions.length);
                locator.close();
            }
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable throwable) {}
            server.stop();
        }
    }

    private ServerSession[] countMetadata(ActiveMQServer server, String parameter, int expected) throws Exception {
        LinkedList<ServerSession> sessionList = new LinkedList<ServerSession>();
        for (int i = 0; i < 10 && sessionList.size() != expected; ++i) {
            sessionList.clear();
            for (ServerSession sess : server.getSessions()) {
                if (sess.getMetaData(parameter) == null) continue;
                sessionList.add(sess);
            }
            if (sessionList.size() == expected) continue;
            Thread.sleep(100L);
        }
        return sessionList.toArray(new ServerSession[sessionList.size()]);
    }

    @Test
    public void testInterruptReconnectNetty() throws Exception {
        this.internalTestInterruptReconnect(true, false);
    }

    @Test
    public void testInterruptReconnectInVM() throws Exception {
        this.internalTestInterruptReconnect(false, false);
    }

    @Test
    public void testInterruptReconnectNettyInterruptMainThread() throws Exception {
        this.internalTestInterruptReconnect(true, true);
    }

    @Test
    public void testInterruptReconnectInVMInterruptMainThread() throws Exception {
        this.internalTestInterruptReconnect(false, true);
    }

    public void internalTestInterruptReconnect(boolean isNetty, boolean interruptMainThread) throws Exception {
        int pingPeriod = 1000;
        ActiveMQServer server = this.createServer(false, isNetty);
        server.start();
        ServerLocator locator = this.createFactory(isNetty).setClientFailureCheckPeriod(1000L).setRetryInterval(500L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(-1).setConfirmationWindowSize(0x100000);
        ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)locator.createSessionFactory();
        final CountDownLatch latchCommit = new CountDownLatch(2);
        final ArrayList threadToBeInterrupted = new ArrayList();
        factory.addFailureListener(new SessionFailureListener(){

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                this.connectionFailed(me, failedOver);
            }

            public void beforeReconnect(ActiveMQException exception) {
                threadToBeInterrupted.add(Thread.currentThread());
                latchCommit.countDown();
            }
        });
        final ClientSessionInternal session = (ClientSessionInternal)factory.createSession();
        final AtomicInteger count = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(1);
        session.addFailureListener(new SessionFailureListener(){

            public void connectionFailed(ActiveMQException me, boolean failedOver) {
                count.incrementAndGet();
                latch.countDown();
            }

            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                this.connectionFailed(me, failedOver);
            }

            public void beforeReconnect(ActiveMQException exception) {
            }
        });
        server.stop();
        Thread tcommitt = new Thread(){

            @Override
            public void run() {
                latchCommit.countDown();
                try {
                    session.commit();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                }
            }
        };
        tcommitt.start();
        ReconnectTest.assertTrue((boolean)latchCommit.await(10L, TimeUnit.SECONDS));
        ReconnectTest.assertEquals((long)1L, (long)threadToBeInterrupted.size());
        if (interruptMainThread) {
            tcommitt.interrupt();
        } else {
            for (Thread tint : threadToBeInterrupted) {
                tint.interrupt();
            }
        }
        tcommitt.join(5000L);
        ReconnectTest.assertFalse((boolean)tcommitt.isAlive());
        locator.close();
    }

    @Test
    public void testReattachTimeout() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        server.start();
        Interceptor reattachInterceptor = new Interceptor(){
            boolean reattached;

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (!this.reattached && packet.getType() == 32) {
                    this.reattached = true;
                    return false;
                }
                return true;
            }
        };
        server.getRemotingService().addIncomingInterceptor((BaseInterceptor)reattachInterceptor);
        long retryInterval = 50L;
        double retryMultiplier = 1.0;
        boolean reconnectAttempts = true;
        ServerLocator locator = this.createFactory(true).setCallTimeout(2000L).setRetryInterval(50L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(1).setConfirmationWindowSize(-1);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(locator);
        CountDownLatch latch = new CountDownLatch(1);
        sf.addFailoverListener(eventType -> {
            if (eventType == FailoverEventType.FAILOVER_FAILED) {
                latch.countDown();
            }
        });
        ClientSession session = sf.createSession(false, true, true);
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        ReconnectTest.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        ReconnectTest.assertTrue((boolean)session.isClosed());
        session.close();
        sf.close();
        server.stop();
    }

    @Test
    public void testClosingConsumerTimeout() throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        server.start();
        final AtomicBoolean consumerClosed = new AtomicBoolean(false);
        Interceptor reattachInterceptor = new Interceptor(){

            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                if (!consumerClosed.get() && packet.getType() == 74) {
                    consumerClosed.set(true);
                    return false;
                }
                return true;
            }
        };
        server.getRemotingService().addIncomingInterceptor((BaseInterceptor)reattachInterceptor);
        long retryInterval = 500L;
        double retryMultiplier = 1.0;
        int reconnectAttempts = 10;
        ServerLocator locator = this.createFactory(true).setCallTimeout(200L).setRetryInterval(500L).setRetryIntervalMultiplier(1.0).setReconnectAttempts(10).setConfirmationWindowSize(-1);
        ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(locator);
        ClientSessionInternal session = (ClientSessionInternal)sf.createSession(false, true, true);
        SimpleString queueName1 = new SimpleString("my_queue_one");
        SimpleString addressName1 = new SimpleString("my_address_one");
        server.addAddressInfo(new AddressInfo(addressName1, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(queueName1).setAddress(addressName1).setRoutingType(RoutingType.ANYCAST));
        ClientConsumer clientConsumer1 = session.createConsumer(queueName1);
        ClientConsumer clientConsumer2 = session.createConsumer(queueName1);
        clientConsumer1.close();
        Wait.assertTrue(consumerClosed::get);
        Wait.assertEquals((int)1, () -> this.getConsumerCount(server, session));
        Set serverConsumers = server.getSessionByID(session.getName()).getServerConsumers();
        ServerConsumer serverConsumer = (ServerConsumer)serverConsumers.iterator().next();
        ReconnectTest.assertEquals((long)clientConsumer2.getConsumerContext().getId(), (long)serverConsumer.getID());
        session.close();
        sf.close();
        server.stop();
    }

    private int getConsumerCount(ActiveMQServer server, ClientSessionInternal session) {
        ServerSession serverSession = server.getSessionByID(session.getName());
        if (serverSession == null) {
            return 0;
        }
        Set serverConsumers = serverSession.getServerConsumers();
        return serverConsumers.size();
    }
}

