/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Message;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ApplicationServerInternalException;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransaction;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionManager;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.Test;

public class ActiveMQMessageHandlerXATest
extends ActiveMQRATestBase {
    @Override
    public boolean useSecurity() {
        return false;
    }

    @Test
    public void testXACommit() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        XADummyEndpoint endpoint = new XADummyEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, true);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        ActiveMQMessageHandlerXATest.assertNotNull((Object)endpoint.lastMessage);
        ActiveMQMessageHandlerXATest.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        endpoint.prepare();
        endpoint.commit();
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testXABeginFails() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        XADummyEndpointBegin endpoint = new XADummyEndpointBegin(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, true);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        DummyTransaction transaction = (DummyTransaction)ServiceUtils.getTransactionManager().getTransaction();
        ActiveMQMessageHandlerXATest.assertTrue((boolean)transaction.rollbackOnly);
        ActiveMQMessageHandlerXATest.assertTrue((boolean)endpoint.afterDelivery);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testXACommitWhenStopping() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setMaxSession(Integer.valueOf(1));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch beforeDeliveryLatch = new CountDownLatch(1);
        PausingXADummyEndpoint endpoint = new PausingXADummyEndpoint(latch, beforeDeliveryLatch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, true);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientMessage message2 = session.createMessage(true);
        message2.getBodyBuffer().writeString("teststring2");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message2);
        session.close();
        beforeDeliveryLatch.await(5L, TimeUnit.SECONDS);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
        ActiveMQMessageHandlerXATest.assertFalse((boolean)endpoint.interrupted);
        ActiveMQMessageHandlerXATest.assertNotNull((Object)endpoint.lastMessage);
        ActiveMQMessageHandlerXATest.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        Binding binding = this.server.getPostOffice().getBinding(MDBQUEUEPREFIXEDSIMPLE);
        long messageCount = this.getMessageCount((Queue)binding.getBindable());
        ActiveMQMessageHandlerXATest.assertEquals((long)1L, (long)messageCount);
    }

    @Test
    public void testXACommitInterruptsWhenStopping() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setCallTimeout(Long.valueOf(500L));
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setMaxSession(Integer.valueOf(1));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch beforeDeliveryLatch = new CountDownLatch(1);
        PausingXADummyEndpoint endpoint = new PausingXADummyEndpoint(latch, beforeDeliveryLatch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, true);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        ClientMessage message2 = session.createMessage(true);
        message2.getBodyBuffer().writeString("teststring2");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message2);
        session.close();
        beforeDeliveryLatch.await(5L, TimeUnit.SECONDS);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
        ActiveMQMessageHandlerXATest.assertTrue((boolean)endpoint.interrupted);
        ActiveMQMessageHandlerXATest.assertNotNull((Object)endpoint.lastMessage);
        ActiveMQMessageHandlerXATest.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
    }

    @Test
    public void testXARollback() throws Exception {
        this.setupDLQ(10);
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setMaxSession(Integer.valueOf(1));
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        XADummyEndpoint endpoint = new XADummyEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, true);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        ActiveMQMessageHandlerXATest.assertNotNull((Object)endpoint.lastMessage);
        ActiveMQMessageHandlerXATest.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        latch = new CountDownLatch(1);
        endpoint.reset(latch);
        endpoint.rollback();
        latch.await(5L, TimeUnit.SECONDS);
        ActiveMQMessageHandlerXATest.assertNotNull((Object)endpoint.lastMessage);
        ActiveMQMessageHandlerXATest.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    class XADummyEndpointBegin
    extends XADummyEndpoint {
        private boolean afterDelivery;

        XADummyEndpointBegin(CountDownLatch latch) {
            super(latch);
            this.afterDelivery = false;
        }

        @Override
        public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
            super.beforeDelivery(method);
            DummyTransactionManager dummyTransactionManager = (DummyTransactionManager)ServiceUtils.getTransactionManager();
            DummyTransaction tx = new DummyTransaction();
            dummyTransactionManager.tx = tx;
            throw new ApplicationServerInternalException();
        }

        @Override
        public void afterDelivery() throws ResourceException {
            this.afterDelivery = true;
            this.latch.countDown();
        }
    }

    class PausingXADummyEndpoint
    extends XADummyEndpoint {
        private final CountDownLatch beforeDeliveryLatch;
        boolean interrupted;

        PausingXADummyEndpoint(CountDownLatch latch, CountDownLatch beforeDeliveryLatch) {
            super(latch);
            this.interrupted = false;
            this.beforeDeliveryLatch = beforeDeliveryLatch;
        }

        @Override
        public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
            super.beforeDelivery(method);
            this.beforeDeliveryLatch.countDown();
        }

        @Override
        public void onMessage(Message message) {
            super.onMessage(message);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.interrupted = true;
            }
        }

        @Override
        public void release() {
            try {
                this.prepare();
                this.commit();
            }
            catch (XAException e) {
                e.printStackTrace();
            }
            super.release();
        }
    }

    class XADummyEndpoint
    extends ActiveMQRATestBase.DummyMessageEndpoint {
        private Xid xid;

        XADummyEndpoint(CountDownLatch latch) {
            super(latch);
            this.xid = new XidImpl("xa1".getBytes(), 1, UUIDGenerator.getInstance().generateStringUUID().getBytes());
        }

        @Override
        public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
            super.beforeDelivery(method);
            try {
                this.xaResource.start(this.xid, 0);
            }
            catch (XAException e) {
                throw new ResourceException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void afterDelivery() throws ResourceException {
            try {
                this.xaResource.end(this.xid, 0x4000000);
            }
            catch (XAException e) {
                throw new ResourceException(e.getMessage(), (Throwable)e);
            }
            super.afterDelivery();
        }

        public void rollback() throws XAException {
            this.xaResource.rollback(this.xid);
        }

        public void prepare() throws XAException {
            this.xaResource.prepare(this.xid);
        }

        public void commit() throws XAException {
            this.xaResource.commit(this.xid, false);
        }
    }
}

