/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.amq.ProducerFlowControlBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProducerFlowControlSendFailTest
extends ProducerFlowControlBaseTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        String match = "#";
        Map asMap = serverConfig.getAddressesSettings();
        ((AddressSettings)asMap.get(match)).setMaxSizeBytes(1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
    }

    @Test
    public void testPublishWithTX() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.getConnectionFactory();
        factory.setUseAsyncSend(true);
        this.flowControlConnection = (ActiveMQConnection)factory.createConnection();
        this.flowControlConnection.start();
        Session session = this.flowControlConnection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)this.queueA);
        int successSent = 0;
        boolean exception = false;
        try {
            for (int i = 0; i < 5000; ++i) {
                producer.send((Message)session.createTextMessage("Test message"));
                session.commit();
                ++successSent;
            }
        }
        catch (Exception e) {
            exception = true;
            e.printStackTrace();
        }
        Assert.assertTrue((boolean)exception);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < successSent; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            Assert.assertNotNull((Object)msg);
            if (msg != null) {
                msg.acknowledge();
            }
            session.commit();
        }
        consumer.close();
    }

    @Test
    public void testPublisherRecoverAfterBlockWithSyncSend() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.getConnectionFactory();
        factory.setExceptionListener(null);
        factory.setUseAsyncSend(false);
        this.flowControlConnection = (ActiveMQConnection)factory.createConnection();
        this.flowControlConnection.start();
        final Session session = this.flowControlConnection.createSession(false, 2);
        final MessageProducer producer = session.createProducer((Destination)this.queueA);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        final AtomicInteger exceptionCount = new AtomicInteger(0);
        Thread thread = new Thread("Filler"){

            @Override
            public void run() {
                while (keepGoing.get()) {
                    try {
                        producer.send((Message)session.createTextMessage("Test message"));
                    }
                    catch (JMSException arg0) {
                        if (!(arg0 instanceof ResourceAllocationException)) continue;
                        ProducerFlowControlSendFailTest.this.gotResourceException.set(true);
                        exceptionCount.incrementAndGet();
                    }
                }
            }
        };
        thread.start();
        this.waitForBlockedOrResourceLimit(new AtomicBoolean(false));
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < 10; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            if (msg == null) continue;
            msg.acknowledge();
        }
        ProducerFlowControlSendFailTest.assertTrue((String)"we were blocked at least 5 times", (5 < exceptionCount.get() ? (byte)1 : 0) != 0);
        keepGoing.set(false);
    }

    protected ConnectionFactory getConnectionFactory() throws Exception {
        this.factory.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException arg0) {
                if (arg0 instanceof ResourceAllocationException) {
                    ProducerFlowControlSendFailTest.this.gotResourceException.set(true);
                }
            }
        });
        return this.factory;
    }
}

