/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.EOFException;
import java.net.ProtocolException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.client.Tracer;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PUBLISH;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTTest
extends MQTTTestSupport {
    private static final Logger log = LoggerFactory.getLogger(MQTTTest.class);
    private static final String AMQP_URI = "tcp://localhost:61616";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithLargePassword() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            String longString = new String(new char[65535]);
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(longString);
                mqtt.setPassword(longString);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                BlockingConnection finalConnection = connection;
                MQTTTest.assertTrue((String)"Should be connected", (boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)5000L, (long)100L));
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveMQTT() throws Exception {
        this.testSendAndReceiveMQTT("");
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveMQTTHugePayload() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        while (builder.length() < 112640) {
            builder.append("huge payload huge payload huge payload huge payload ");
        }
        this.testSendAndReceiveMQTT(builder.toString());
    }

    public void testSendAndReceiveMQTT(String extraPayload) throws Exception {
        final MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah", 0);
        final CountDownLatch latch = new CountDownLatch(250);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 250; ++i) {
                    try {
                        byte[] payload = subscriptionProvider.receive(10000);
                        Assert.assertNotNull((String)"Should get a message", (Object)payload);
                        latch.countDown();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i + extraPayload;
            publishProvider.publish("foo/bah", payload.getBytes(), 1);
        }
        latch.await(10L, TimeUnit.SECONDS);
        MQTTTest.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
    }

    @Test(timeout=60000L)
    public void testDirectDeliverFalse() throws Exception {
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bah", 0);
        for (Binding b : IterableStream.iterableOf(this.server.getPostOffice().getAllBindings().filter(QueueBinding.class::isInstance))) {
            Assert.assertFalse((String)("Queue " + ((QueueBinding)b).getQueue().getName()), (boolean)((QueueBinding)b).getQueue().isDirectDeliver());
        }
        subscriptionProvider.disconnect();
    }

    @Test(timeout=60000L)
    public void testUnsubscribeMQTT() throws Exception {
        final MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        String topic = "foo/bah";
        subscriptionProvider.subscribe(topic, 0);
        final CountDownLatch latch = new CountDownLatch(125);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 250; ++i) {
                    try {
                        byte[] payload = subscriptionProvider.receive(10000);
                        Assert.assertNotNull((String)"Should get a message", (Object)payload);
                        latch.countDown();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        });
        thread.start();
        MQTTClientProvider publishProvider = this.getMQTTClientProvider();
        this.initializeConnection(publishProvider);
        for (int i = 0; i < 250; ++i) {
            String payload = "Message " + i;
            if (i == 125) {
                subscriptionProvider.unsubscribe(topic);
            }
            publishProvider.publish(topic, payload.getBytes(), 1);
        }
        latch.await(20L, TimeUnit.SECONDS);
        MQTTTest.assertEquals((long)0L, (long)latch.getCount());
        subscriptionProvider.disconnect();
        publishProvider.disconnect();
    }

    @Test(timeout=60000L)
    public void testSendAtMostOnceReceiveExactlyOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 0);
            byte[] message = provider.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test(timeout=120000L)
    public void testManagementQueueMessagesAreAckd() throws Exception {
        String clientId = "test.client.id";
        MQTTClientProvider provider = this.getMQTTClientProvider();
        provider.setClientId(clientId);
        this.initializeConnection(provider);
        provider.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 2);
            byte[] message = provider.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        Queue queue = this.server.locateQueue(new SimpleString("$sys.mqtt.queue.qos2." + clientId));
        Wait.waitFor(() -> queue.getMessageCount() == 0L, (long)1000L, (long)100L);
        MQTTTest.assertEquals((long)0L, (long)queue.getMessageCount());
        provider.disconnect();
    }

    @Test(timeout=120000L)
    public void testSendAtLeastOnceReceiveExactlyOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 1);
            byte[] message = provider.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test(timeout=120000L)
    public void testSendAtLeastOnceReceiveAtMostOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 0);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 1);
            byte[] message = provider.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveAtMostOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 0);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 0);
            byte[] message = provider.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test(timeout=120000L)
    public void testSendAndReceiveAtLeastOnce() throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo", 1);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            provider.publish("foo", payload.getBytes(), 1);
            byte[] message = provider.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        provider.disconnect();
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveExactlyOnceWithInterceptors() throws Exception {
        MQTTTestSupport.MQTTIncomingInterceptor.clear();
        MQTTTestSupport.MQTTOutoingInterceptor.clear();
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        subscriber.subscribe("foo", 2);
        for (int i = 0; i < 250; ++i) {
            String payload = "Test Message: " + i;
            publisher.publish("foo", payload.getBytes(), 2);
            byte[] message = subscriber.receive(5000);
            MQTTTest.assertNotNull((String)("Should get a message + [" + i + "]"), (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
        }
        subscriber.disconnect();
        publisher.disconnect();
        MQTTTest.assertEquals((long)250L, (long)MQTTTestSupport.MQTTIncomingInterceptor.getMessageCount());
        MQTTTest.assertEquals((long)250L, (long)MQTTTestSupport.MQTTOutoingInterceptor.getMessageCount());
    }

    @Ignore
    @Test(timeout=600000L)
    public void testSendMoreThanUniqueId() throws Exception {
        int messages = 65535;
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        int count = 0;
        subscriber.subscribe("foo", 2);
        for (int i = 0; i < messages; ++i) {
            String payload = "Test Message: " + i;
            publisher.publish("foo", payload.getBytes(), 2);
            byte[] message = subscriber.receive(5000);
            MQTTTest.assertNotNull((String)("Should get a message + [" + i + "]"), (Object)message);
            MQTTTest.assertEquals((Object)payload, (Object)new String(message));
            ++count;
        }
        MQTTTest.assertEquals((long)messages, (long)count);
        subscriber.disconnect();
        publisher.disconnect();
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveLargeMessages() throws Exception {
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 50;
        }
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        subscriber.subscribe("foo", 1);
        for (int i = 0; i < 10; ++i) {
            publisher.publish("foo", payload, 1);
            byte[] message = subscriber.receive(5000);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            MQTTTest.assertArrayEquals((byte[])payload, (byte[])message);
        }
        subscriber.disconnect();
        publisher.disconnect();
    }

    @Test(timeout=60000L)
    public void testSendAndReceiveRetainedMessages() throws Exception {
        int i;
        MQTTClientProvider publisher = this.getMQTTClientProvider();
        this.initializeConnection(publisher);
        MQTTClientProvider subscriber = this.getMQTTClientProvider();
        this.initializeConnection(subscriber);
        String RETAINED = "retained";
        publisher.publish("foo", RETAINED.getBytes(), 1, true);
        ArrayList<String> messages = new ArrayList<String>();
        for (i = 0; i < 10; ++i) {
            messages.add("TEST MESSAGE:" + i);
        }
        subscriber.subscribe("foo", 1);
        for (i = 0; i < 10; ++i) {
            publisher.publish("foo", ((String)messages.get(i)).getBytes(), 1);
        }
        byte[] msg = subscriber.receive(5000);
        MQTTTest.assertNotNull((Object)msg);
        MQTTTest.assertEquals((Object)RETAINED, (Object)new String(msg));
        for (int i2 = 0; i2 < 10; ++i2) {
            msg = subscriber.receive(5000);
            MQTTTest.assertNotNull((Object)msg);
            MQTTTest.assertEquals(messages.get(i2), (Object)new String(msg));
        }
        subscriber.disconnect();
        publisher.disconnect();
    }

    @Test(timeout=30000L)
    public void testValidZeroLengthClientId() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("");
        mqtt.setCleanSession(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
    }

    @Test(timeout=120000L)
    public void testMQTTPathPatterns() throws Exception {
        String[] wildcards;
        String[] topics;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("");
        mqtt.setCleanSession(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String RETAINED = "RETAINED";
        for (String topic : topics = new String[]{"TopicA", "/TopicA", "/", "TopicA/", "//"}) {
            connection.publish(topic, ("RETAINED" + topic).getBytes(), QoS.AT_LEAST_ONCE, true);
            connection.subscribe(new Topic[]{new Topic(topic, QoS.AT_LEAST_ONCE)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5L, TimeUnit.SECONDS);
            MQTTTest.assertNotNull((String)("No message for " + topic), (Object)msg);
            MQTTTest.assertEquals((Object)("RETAINED" + topic), (Object)new String(msg.getPayload()));
            msg.ack();
            connection.publish(topic, topic.getBytes(), QoS.AT_LEAST_ONCE, false);
            msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((Object)msg);
            MQTTTest.assertEquals((Object)topic, (Object)new String(msg.getPayload()));
            msg.ack();
            connection.unsubscribe(new String[]{topic});
        }
        connection.disconnect();
        for (String wildcard : wildcards = new String[]{"#", "+", "+/#", "/+", "+/", "+/+", "+/+/", "+/+/+"}) {
            Pattern pattern = Pattern.compile(wildcard.replaceAll("/?#", "(/?.*)*").replaceAll("\\+", "[^/]*"));
            connection = mqtt.blockingConnection();
            connection.connect();
            byte[] qos = connection.subscribe(new Topic[]{new Topic(wildcard, QoS.AT_LEAST_ONCE)});
            MQTTTest.assertNotEquals((String)("Subscribe failed " + wildcard), (long)-128L, (long)qos[0]);
            org.fusesource.mqtt.client.Message msg = connection.receive(5L, TimeUnit.SECONDS);
            do {
                MQTTTest.assertNotNull((String)("RETAINED null " + wildcard), (Object)msg);
                String msgPayload = new String(msg.getPayload());
                MQTTTest.assertTrue((String)("RETAINED prefix " + wildcard + " msg " + msgPayload), (boolean)msgPayload.startsWith("RETAINED"));
                MQTTTest.assertTrue((String)("RETAINED matching " + wildcard + " " + msg.getTopic()), (boolean)pattern.matcher(msg.getTopic()).matches());
                msg.ack();
            } while ((msg = connection.receive(500L, TimeUnit.MILLISECONDS)) != null);
            for (String topic : topics) {
                connection.publish(topic, topic.getBytes(), QoS.AT_LEAST_ONCE, false);
            }
            msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            do {
                MQTTTest.assertNotNull((String)("Non-retained Null " + wildcard), (Object)msg);
                MQTTTest.assertTrue((String)("Non-retained matching " + wildcard + " " + msg.getTopic()), (boolean)pattern.matcher(msg.getTopic()).matches());
                msg.ack();
            } while ((msg = connection.receive(500L, TimeUnit.MILLISECONDS)) != null);
            connection.unsubscribe(new String[]{wildcard});
            connection.disconnect();
        }
    }

    @Test(timeout=60000L)
    public void testMQTTRetainQoS() throws Exception {
        String[] topics = new String[]{"AT_MOST_ONCE", "AT_LEAST_ONCE", "EXACTLY_ONCE"};
        for (int i = 0; i < topics.length; ++i) {
            String topic = topics[i];
            MQTT mqtt = this.createMQTTConnection();
            mqtt.setClientId("foo");
            mqtt.setKeepAlive((short)2);
            final int[] actualQoS = new int[]{-1};
            mqtt.setTracer(new Tracer(){

                public void onReceive(MQTTFrame frame) {
                    if (frame.messageType() == 3) {
                        actualQoS[0] = frame.qos().ordinal();
                    }
                }
            });
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish(topic, topic.getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic(topic, QoS.valueOf((String)topic))});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((Object)msg);
            MQTTTest.assertEquals((Object)topic, (Object)new String(msg.getPayload()));
            Wait.assertEquals((int)i, () -> actualQoS[0]);
            msg.ack();
            connection.unsubscribe(new String[]{topic});
            connection.disconnect();
        }
    }

    @Test(timeout=60000L)
    public void testDuplicateSubscriptions() throws Exception {
        QoS[] qoss;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)20);
        final int[] actualQoS = new int[]{-1};
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                if (frame.messageType() == 3) {
                    actualQoS[0] = frame.qos().ordinal();
                }
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String RETAIN = "RETAIN";
        connection.publish("TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
        for (QoS qos : qoss = new QoS[]{QoS.AT_MOST_ONCE, QoS.AT_MOST_ONCE, QoS.AT_LEAST_ONCE, QoS.EXACTLY_ONCE}) {
            connection.subscribe(new Topic[]{new Topic("TopicA", qos)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No message for " + qos), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            Wait.assertEquals((int)qos.ordinal(), () -> actualQoS[0]);
            actualQoS[0] = -1;
        }
        connection.unsubscribe(new String[]{"TopicA"});
        connection.disconnect();
    }

    @Test(timeout=120000L)
    public void testRetainedMessage() throws Exception {
        String[] clientIds;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setKeepAlive((short)60);
        String RETAIN = "RETAIN";
        String TOPICA = "TopicA";
        for (String clientId : clientIds = new String[]{null, "foo", "durable"}) {
            log.debug("Testing now with Client ID: {}", (Object)clientId);
            mqtt.setClientId(clientId);
            mqtt.setCleanSession(!"durable".equals(clientId));
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No retained message for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(15000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No retained message on duplicate subscription for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.unsubscribe(new String[]{"TopicA"});
            connection.publish("TopicA", "".getBytes(), QoS.AT_MOST_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(100L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNull((String)("Retained message not cleared for " + clientId), (Object)msg);
            connection.unsubscribe(new String[]{"TopicA"});
            connection.publish("TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No reset retained message for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.disconnect();
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(new Topic[]{new Topic("TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No reset retained message for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.unsubscribe(new String[]{"TopicA"});
            connection.disconnect();
        }
    }

    @Ignore
    @Test(timeout=120000L)
    public void testRetainedMessageOnVirtualTopics() throws Exception {
        String[] clientIds;
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setKeepAlive((short)60);
        String RETAIN = "RETAIN";
        String TOPICA = "VirtualTopic/TopicA";
        for (String clientId : clientIds = new String[]{null, "foo", "durable"}) {
            log.debug("Testing now with Client ID: {}", (Object)clientId);
            mqtt.setClientId(clientId);
            mqtt.setCleanSession(!"durable".equals(clientId));
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("VirtualTopic/TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No retained message for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(15000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No retained message on duplicate subscription for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.unsubscribe(new String[]{"VirtualTopic/TopicA"});
            connection.publish("VirtualTopic/TopicA", "".getBytes(), QoS.AT_MOST_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(500L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNull((String)("Retained message not cleared for " + clientId), (Object)msg);
            connection.unsubscribe(new String[]{"VirtualTopic/TopicA"});
            connection.publish("VirtualTopic/TopicA", "RETAIN".getBytes(), QoS.EXACTLY_ONCE, true);
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No reset retained message for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            connection.disconnect();
            connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(new Topic[]{new Topic("VirtualTopic/TopicA", QoS.AT_LEAST_ONCE)});
            msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((String)("No reset retained message for " + clientId), (Object)msg);
            MQTTTest.assertEquals((Object)"RETAIN", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertNull((Object)connection.receive(100L, TimeUnit.MILLISECONDS));
            log.debug("Test now unsubscribing from: {} for the last time", (Object)"VirtualTopic/TopicA");
            connection.unsubscribe(new String[]{"VirtualTopic/TopicA"});
            connection.disconnect();
        }
    }

    @Test(timeout=60000L)
    public void testUniqueMessageIds() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)2);
        mqtt.setCleanSession(true);
        final ArrayList publishList = new ArrayList();
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                log.debug("Client received:\n" + frame);
                if (frame.messageType() == 3) {
                    PUBLISH publish = new PUBLISH();
                    try {
                        publish.decode(frame);
                    }
                    catch (ProtocolException e) {
                        Assert.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                    publishList.add(publish);
                }
            }

            public void onSend(MQTTFrame frame) {
                log.debug("Client sent:\n" + frame);
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        QoS[] qoss = new QoS[]{QoS.AT_MOST_ONCE, QoS.AT_LEAST_ONCE, QoS.EXACTLY_ONCE};
        String TOPIC = "TopicA/";
        connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, true);
        String[] subs = new String[]{"TopicA/", "TopicA/#", "TopicA/+"};
        for (int i = 0; i < qoss.length; ++i) {
            connection.subscribe(new Topic[]{new Topic(subs[i], qoss[i])});
        }
        connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
        int received = 0;
        org.fusesource.mqtt.client.Message msg = connection.receive(5000L, TimeUnit.MILLISECONDS);
        do {
            MQTTTest.assertNotNull((Object)msg);
            MQTTTest.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
            for (int waitCount = 0; publishList.size() <= received && waitCount < 10; ++waitCount) {
                Thread.sleep(1000L);
            }
        } while ((msg = connection.receive(5000L, TimeUnit.MILLISECONDS)) != null && received++ < subs.length * 2);
        MQTTTest.assertEquals((String)"Unexpected number of messages", (long)(subs.length * 2), (long)(received + 1));
        for (int i = 0; i < publishList.size(); ++i) {
            for (int j = i + 1; j < publishList.size(); ++j) {
                PUBLISH publish1 = (PUBLISH)publishList.get(i);
                PUBLISH publish2 = (PUBLISH)publishList.get(j);
                boolean qos0 = false;
                if (publish1.qos() == QoS.AT_MOST_ONCE) {
                    qos0 = true;
                    MQTTTest.assertEquals((long)0L, (long)publish1.messageId());
                }
                if (publish2.qos() == QoS.AT_MOST_ONCE) {
                    qos0 = true;
                    MQTTTest.assertEquals((long)0L, (long)publish2.messageId());
                }
                if (qos0) continue;
                MQTTTest.assertNotEquals((long)publish1.messageId(), (long)publish2.messageId());
            }
        }
        connection.unsubscribe(subs);
        connection.disconnect();
    }

    @Test(timeout=60000L)
    public void testResendMessageId() throws Exception {
        MQTT mqtt = this.createMQTTConnection("resend", false);
        mqtt.setKeepAlive((short)5);
        final ArrayList publishList = new ArrayList();
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                log.debug("Client received:\n" + frame);
                if (frame.messageType() == 3) {
                    PUBLISH publish = new PUBLISH();
                    try {
                        publish.decode(frame);
                    }
                    catch (ProtocolException e) {
                        Assert.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                    publishList.add(publish);
                }
            }

            public void onSend(MQTTFrame frame) {
                log.debug("Client sent:\n" + frame);
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String TOPIC = "TopicA/";
        String[] topics = new String[]{"TopicA/", "TopicA/+"};
        connection.subscribe(new Topic[]{new Topic(topics[0], QoS.AT_LEAST_ONCE), new Topic(topics[1], QoS.EXACTLY_ONCE)});
        connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
        MQTTTest.assertTrue((boolean)Wait.waitFor(() -> publishList.size() == 2, (long)5000L));
        connection.disconnect();
        connection = mqtt.blockingConnection();
        connection.connect();
        MQTTTest.assertTrue((boolean)Wait.waitFor(() -> publishList.size() == 4, (long)5000L));
        connection.unsubscribe(topics);
        connection.disconnect();
    }

    @Test(timeout=90000L)
    public void testPacketIdGeneratorNonCleanSession() throws Exception {
        int i;
        MQTT mqtt = this.createMQTTConnection("nonclean-packetid", false);
        mqtt.setKeepAlive((short)15);
        final ConcurrentHashMap publishMap = new ConcurrentHashMap();
        mqtt.setTracer(new Tracer(){

            public void onReceive(MQTTFrame frame) {
                log.debug("Client received:\n" + frame);
                if (frame.messageType() == 3) {
                    PUBLISH publish = new PUBLISH();
                    try {
                        publish.decode(frame);
                        log.debug("PUBLISH " + publish);
                    }
                    catch (ProtocolException e) {
                        Assert.fail((String)("Error decoding publish " + e.getMessage()));
                    }
                    if (publishMap.get(publish.messageId()) != null) {
                        Assert.assertTrue((boolean)publish.dup());
                    }
                    publishMap.put(publish.messageId(), publish);
                }
            }

            public void onSend(MQTTFrame frame) {
                log.debug("Client sent:\n" + frame);
            }
        });
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String TOPIC = "TopicA/";
        connection.subscribe(new Topic[]{new Topic("TopicA/", QoS.EXACTLY_ONCE)});
        int TOTAL_MESSAGES = 10;
        for (i = 0; i < 10; ++i) {
            connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
        }
        for (i = 0; i < 5; ++i) {
            org.fusesource.mqtt.client.Message msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((Object)msg);
            MQTTTest.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
        }
        connection.disconnect();
        connection = mqtt.blockingConnection();
        connection.connect();
        org.fusesource.mqtt.client.Message msg = null;
        do {
            if ((msg = connection.receive(1000L, TimeUnit.MILLISECONDS)) == null) continue;
            MQTTTest.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
        } while (msg != null);
        for (short id = 1; id <= 10; id = (short)(id + 1)) {
            MQTTTest.assertNotNull((String)("No message for id " + id), publishMap.get(id));
        }
        connection.unsubscribe(new String[]{"TopicA/"});
        connection.disconnect();
    }

    @Ignore
    @Test(timeout=90000L)
    public void testPacketIdGeneratorCleanSession() throws Exception {
        String[] cleanClientIds = new String[]{"", "clean-packetid", null};
        final ConcurrentHashMap publishMap = new ConcurrentHashMap();
        MQTT[] mqtts = new MQTT[cleanClientIds.length];
        for (int i = 0; i < cleanClientIds.length; ++i) {
            mqtts[i] = this.createMQTTConnection("", true);
            mqtts[i].setKeepAlive((short)15);
            mqtts[i].setTracer(new Tracer(){

                public void onReceive(MQTTFrame frame) {
                    log.debug("Client received:\n" + frame);
                    if (frame.messageType() == 3) {
                        PUBLISH publish = new PUBLISH();
                        try {
                            publish.decode(frame);
                            log.debug("PUBLISH " + publish);
                        }
                        catch (ProtocolException e) {
                            Assert.fail((String)("Error decoding publish " + e.getMessage()));
                        }
                        if (publishMap.get(publish.messageId()) != null) {
                            Assert.assertTrue((boolean)publish.dup());
                        }
                        publishMap.put(publish.messageId(), publish);
                    }
                }

                public void onSend(MQTTFrame frame) {
                    log.debug("Client sent:\n" + frame);
                }
            });
        }
        Random random = new Random();
        for (int i = 0; i < 10; i = (int)((short)(i + 1))) {
            BlockingConnection connection = mqtts[random.nextInt(cleanClientIds.length)].blockingConnection();
            connection.connect();
            String TOPIC = "TopicA/";
            connection.subscribe(new Topic[]{new Topic("TopicA/", QoS.EXACTLY_ONCE)});
            connection.publish("TopicA/", "TopicA/".getBytes(), QoS.EXACTLY_ONCE, false);
            org.fusesource.mqtt.client.Message msg = connection.receive(1000L, TimeUnit.MILLISECONDS);
            MQTTTest.assertNotNull((Object)msg);
            MQTTTest.assertEquals((Object)"TopicA/", (Object)new String(msg.getPayload()));
            msg.ack();
            MQTTTest.assertEquals((long)1L, (long)publishMap.size());
            short id = (short)(i + 1);
            MQTTTest.assertNotNull((String)("No message for id " + id), publishMap.get(id));
            publishMap.clear();
            connection.disconnect();
        }
    }

    @Test(timeout=60000L)
    public void testClientConnectionFailure() throws Exception {
        MQTT mqtt = this.createMQTTConnection("reconnect", false);
        mqtt.setKeepAlive((short)1);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Wait.waitFor(() -> connection.isConnected());
        String TOPIC = "TopicA";
        byte[] qos = connection.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        MQTTTest.assertEquals((long)QoS.EXACTLY_ONCE.ordinal(), (long)qos[0]);
        connection.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        connection.kill();
        BlockingConnection newConnection = mqtt.blockingConnection();
        newConnection.connect();
        Wait.waitFor(() -> newConnection.isConnected());
        MQTTTest.assertEquals((long)QoS.EXACTLY_ONCE.ordinal(), (long)qos[0]);
        org.fusesource.mqtt.client.Message msg = newConnection.receive(1000L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNotNull((Object)msg);
        MQTTTest.assertEquals((Object)"TopicA", (Object)new String(msg.getPayload()));
        msg.ack();
        newConnection.disconnect();
    }

    @Test(timeout=60000L)
    public void testClientConnectionFailureSendsWillMessage() throws Exception {
        this.getServer().createQueue(new QueueConfiguration("will"));
        MQTT mqtt = this.createMQTTConnection("1", false);
        mqtt.setKeepAlive((short)1);
        mqtt.setWillMessage("test message");
        mqtt.setWillTopic("will");
        mqtt.setWillQos(QoS.AT_LEAST_ONCE);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Wait.waitFor(() -> connection.isConnected());
        MQTT mqtt2 = this.createMQTTConnection("2", false);
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(new Topic[]{new Topic("will", QoS.AT_LEAST_ONCE)});
        connection.kill();
        org.fusesource.mqtt.client.Message m = connection2.receive(1000L, TimeUnit.MILLISECONDS);
        MQTTTest.assertEquals((Object)"test message", (Object)new String(m.getPayload()));
    }

    @Test(timeout=60000L)
    public void testWillMessageIsRetained() throws Exception {
        this.getServer().createQueue(new QueueConfiguration("will"));
        MQTT mqtt = this.createMQTTConnection("1", false);
        mqtt.setKeepAlive((short)1);
        mqtt.setWillMessage("test message");
        mqtt.setWillTopic("will");
        mqtt.setWillQos(QoS.AT_LEAST_ONCE);
        mqtt.setWillRetain(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Wait.waitFor(() -> connection.isConnected());
        connection.kill();
        Thread.sleep(10000L);
        MQTT mqtt2 = this.createMQTTConnection("2", false);
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(new Topic[]{new Topic("will", QoS.AT_LEAST_ONCE)});
        org.fusesource.mqtt.client.Message m = connection2.receive(1000L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNotNull((Object)m);
        m.ack();
        MQTTTest.assertEquals((Object)"test message", (Object)new String(m.getPayload()));
    }

    @Test(timeout=60000L)
    public void testCleanSessionForSubscriptions() throws Exception {
        String CLIENTID = "cleansession";
        MQTT mqttNotClean = this.createMQTTConnection("cleansession", false);
        BlockingConnection notClean = mqttNotClean.blockingConnection();
        String TOPIC = "TopicA";
        notClean.connect();
        notClean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        notClean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        notClean.disconnect();
        MQTTTest.assertEquals((long)1L, (long)this.getSessions().size());
        notClean = mqttNotClean.blockingConnection();
        notClean.connect();
        org.fusesource.mqtt.client.Message msg = notClean.receive(10000L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNotNull((Object)msg);
        MQTTTest.assertEquals((Object)"TopicA", (Object)new String(msg.getPayload()));
        msg.ack();
        notClean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        notClean.disconnect();
        MQTTTest.assertEquals((long)1L, (long)this.getSessions().size());
        MQTT mqttClean = this.createMQTTConnection("cleansession", true);
        BlockingConnection clean = mqttClean.blockingConnection();
        clean.connect();
        msg = clean.receive(100L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNull((Object)msg);
        clean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        clean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        clean.disconnect();
        MQTTTest.assertEquals((long)0L, (long)this.getSessions().size());
        notClean = mqttNotClean.blockingConnection();
        notClean.connect();
        msg = notClean.receive(100L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNull((Object)msg);
        notClean.disconnect();
        MQTTTest.assertEquals((long)1L, (long)this.getSessions().size());
    }

    @Test(timeout=60000L)
    public void testCleanSessionForMessages() throws Exception {
        String CLIENTID = "cleansession";
        MQTT mqttNotClean = this.createMQTTConnection("cleansession", false);
        BlockingConnection notClean = mqttNotClean.blockingConnection();
        String TOPIC = "TopicA";
        notClean.connect();
        notClean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        notClean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        notClean.disconnect();
        MQTTTest.assertEquals((long)1L, (long)this.getSessions().size());
        MQTT mqttClean = this.createMQTTConnection("cleansession", true);
        BlockingConnection clean = mqttClean.blockingConnection();
        clean.connect();
        clean.subscribe(new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)});
        org.fusesource.mqtt.client.Message msg = clean.receive(100L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNull((Object)msg);
        clean.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, false);
        clean.disconnect();
        MQTTTest.assertEquals((long)0L, (long)this.getSessions().size());
    }

    @Test(timeout=60000L)
    public void testSendMQTTReceiveJMS() throws Exception {
        this.doTestSendMQTTReceiveJMS("foo.*", "foo/bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLinkRouteAmqpReceiveMQTT() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("TestClient");
        BlockingConnection blockingConnection = mqtt.blockingConnection();
        blockingConnection.connect();
        Topic t = new Topic("test", QoS.AT_LEAST_ONCE);
        blockingConnection.subscribe(new Topic[]{t});
        AmqpClient client = new AmqpClient(new URI(AMQP_URI), null, null);
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender("test", true);
            AmqpMessage message = new AmqpMessage();
            message.setText("Test-Message");
            sender.send(message);
            sender.close();
        }
        try {
            blockingConnection.subscribe(new Topic[]{t});
            MQTTTest.assertNotNull((Object)blockingConnection.receive(5L, TimeUnit.SECONDS));
        }
        finally {
            blockingConnection.kill();
        }
    }

    public void doTestSendMQTTReceiveJMS(String jmsTopicAddress, String mqttAddress) throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        String address = mqttAddress;
        String RETAINED = "RETAINED";
        byte[] payload = "RETAINED".getBytes();
        Connection connection = this.cf.createConnection();
        connection.start();
        Session s = connection.createSession(false, 1);
        jakarta.jms.Queue jmsQueue = s.createQueue(jmsTopicAddress);
        MessageConsumer consumer = s.createConsumer((Destination)jmsQueue);
        provider.publish(address, "RETAINED".getBytes(), 1, true);
        BytesMessage message = (BytesMessage)consumer.receive(5000L);
        MQTTTest.assertNotNull((String)"Should get retained message", (Object)message);
        byte[] b = new byte[8];
        message.readBytes(b);
        MQTTTest.assertArrayEquals((byte[])payload, (byte[])b);
        for (int i = 0; i < 250; ++i) {
            String p = "Test Message: " + i;
            provider.publish(address, p.getBytes(), 1);
            message = (BytesMessage)consumer.receive(5000L);
            MQTTTest.assertNotNull((String)"Should get a message", (Object)message);
            byte[] bytePayload = new byte[p.getBytes().length];
            message.readBytes(bytePayload);
            MQTTTest.assertArrayEquals((byte[])payload, (byte[])b);
        }
        connection.close();
        provider.disconnect();
    }

    @Test(timeout=120000L)
    public void testSendJMSReceiveMQTT() throws Exception {
        this.doTestSendJMSReceiveMQTT("foo.far");
    }

    public void doTestSendJMSReceiveMQTT(String destinationName) throws Exception {
        MQTTClientProvider provider = this.getMQTTClientProvider();
        this.initializeConnection(provider);
        provider.subscribe("foo/+", 0);
        Connection connection = this.cf.createConnection();
        connection.start();
        Session s = connection.createSession(false, 1);
        jakarta.jms.Topic topic = s.createTopic(destinationName);
        MessageProducer producer = s.createProducer((Destination)topic);
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        BytesMessage bytesMessage = s.createBytesMessage();
        bytesMessage.writeBytes(bytes);
        producer.send((Message)bytesMessage);
        byte[] message = provider.receive(10000);
        MQTTTest.assertNotNull((String)"Should get retained message", (Object)message);
        MQTTTest.assertArrayEquals((byte[])bytes, (byte[])message);
        provider.disconnect();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testPingKeepsInactivityMonitorAlive() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        MQTTTest.assertTrue((String)"KeepAlive didn't work properly", (boolean)Wait.waitFor(() -> connection.isConnected()));
        connection.disconnect();
    }

    @Test(timeout=60000L)
    public void testTurnOffInactivityMonitor() throws Exception {
        this.stopBroker();
        this.protocolConfig = "transport.useInactivityMonitor=false";
        this.startBroker();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo3");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        MQTTTest.assertTrue((String)"KeepAlive didn't work properly", (boolean)Wait.waitFor(() -> connection.isConnected()));
        connection.disconnect();
    }

    @Ignore
    @Test(timeout=60000L)
    public void testPublishDollarTopics() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        String clientId = "publishDollar";
        mqtt.setClientId("publishDollar");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String DOLLAR_TOPIC = "$TopicA";
        connection.subscribe(new Topic[]{new Topic("$TopicA", QoS.EXACTLY_ONCE)});
        connection.publish("$TopicA", "$TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        org.fusesource.mqtt.client.Message message = connection.receive(100L, TimeUnit.MILLISECONDS);
        MQTTTest.assertNull((String)"Publish enabled for $ Topics by default", (Object)message);
        connection.disconnect();
        this.stopBroker();
        this.protocolConfig = "transport.publishDollarTopics=true";
        this.startBroker();
        mqtt = this.createMQTTConnection();
        mqtt.setClientId("publishDollar");
        mqtt.setKeepAlive((short)2);
        connection = mqtt.blockingConnection();
        connection.connect();
        connection.subscribe(new Topic[]{new Topic("$TopicA", QoS.EXACTLY_ONCE)});
        connection.publish("$TopicA", "$TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        message = connection.receive(10L, TimeUnit.SECONDS);
        MQTTTest.assertNotNull((Object)message);
        message.ack();
        MQTTTest.assertEquals((String)"Message body", (Object)"$TopicA", (Object)new String(message.getPayload()));
        connection.disconnect();
    }

    @Test(timeout=60000L)
    public void testDuplicateClientId() throws Exception {
        String clientId = "duplicateClient";
        MQTT mqtt = this.createMQTTConnection("duplicateClient", false);
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        String TOPICA = "TopicA";
        connection.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        MQTT mqtt1 = this.createMQTTConnection("duplicateClient", false);
        mqtt1.setKeepAlive((short)2);
        BlockingConnection connection1 = mqtt1.blockingConnection();
        connection1.connect();
        MQTTTest.assertTrue((String)"Duplicate client disconnected", (boolean)Wait.waitFor(() -> connection1.isConnected()));
        MQTTTest.assertTrue((String)"Old client still connected", (boolean)Wait.waitFor(() -> !connection.isConnected()));
        connection1.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        connection1.disconnect();
    }

    @Test(timeout=60000L)
    public void testRepeatedLinkStealing() throws Exception {
        String clientId = "duplicateClient";
        AtomicReference<BlockingConnection> oldConnection = new AtomicReference<BlockingConnection>();
        String TOPICA = "TopicA";
        for (int i = 1; i <= 10; ++i) {
            log.debug("Creating MQTT Connection {}", (Object)i);
            MQTT mqtt = this.createMQTTConnection("duplicateClient", false);
            mqtt.setKeepAlive((short)2);
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
            MQTTTest.assertTrue((String)("Client connect failed for attempt: " + i), (boolean)Wait.waitFor(() -> connection.isConnected(), (long)3000L, (long)200L));
            if (oldConnection.get() != null) {
                MQTTTest.assertTrue((String)("Old client still connected on attempt: " + i), (boolean)Wait.waitFor(() -> !((BlockingConnection)oldConnection.get()).isConnected(), (long)3000L, (long)200L));
            }
            oldConnection.set(connection);
        }
        ((BlockingConnection)oldConnection.get()).publish("TopicA", "TopicA".getBytes(), QoS.EXACTLY_ONCE, true);
        ((BlockingConnection)oldConnection.get()).disconnect();
    }

    @Test(timeout=300000L)
    public void testJmsMapping() throws Exception {
        this.doTestJmsMapping("test.foo");
    }

    public void doTestJmsMapping(String destinationName) throws Exception {
        int i;
        Connection jmsConn = this.cf.createConnection();
        Session session = jmsConn.createSession(false, 1);
        jakarta.jms.Queue dest = session.createQueue(destinationName);
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        jmsConn.start();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo3");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        int messagesToSend = 5;
        for (i = 0; i < messagesToSend; ++i) {
            connection.publish("test/foo", "hello world".getBytes(), QoS.AT_LEAST_ONCE, false);
        }
        connection.disconnect();
        for (i = 0; i < messagesToSend; ++i) {
            Message message = consumer.receive(2000L);
            MQTTTest.assertNotNull((Object)message);
            MQTTTest.assertTrue((boolean)(message instanceof BytesMessage));
            BytesMessage bytesMessage = (BytesMessage)message;
            int length = (int)bytesMessage.getBodyLength();
            byte[] buffer = new byte[length];
            bytesMessage.readBytes(buffer);
            MQTTTest.assertEquals((Object)"hello world", (Object)new String(buffer));
        }
        jmsConn.close();
    }

    @Test(timeout=300000L)
    public void testSubscribeMultipleTopics() throws Exception {
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 50;
        }
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("MQTT-Client");
        mqtt.setCleanSession(false);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        Topic[] topics = new Topic[]{new Topic("Topic/A", QoS.EXACTLY_ONCE), new Topic("Topic/B", QoS.EXACTLY_ONCE)};
        Topic[] wildcardTopic = new Topic[]{new Topic("Topic/#", QoS.AT_LEAST_ONCE)};
        connection.subscribe(wildcardTopic);
        for (Topic topic : topics) {
            connection.publish(topic.name().toString(), payload, QoS.AT_LEAST_ONCE, false);
        }
        int received = 0;
        for (int i = 0; i < topics.length; ++i) {
            org.fusesource.mqtt.client.Message message = connection.receive();
            MQTTTest.assertNotNull((Object)message);
            ++received;
            payload = message.getPayload();
            String messageContent = new String(payload);
            log.debug("Received message from topic: " + message.getTopic() + " Message content: " + messageContent);
            message.ack();
        }
        MQTTTest.assertEquals((String)("Should have received " + topics.length + " messages"), (long)topics.length, (long)received);
    }

    @Test(timeout=60000L)
    public void testReceiveMessageSentWhileOffline() throws Exception {
        byte[] payload = new byte[32768];
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = 50;
        }
        int numberOfRuns = 100;
        int messagesPerRun = 2;
        MQTT mqttPub = this.createMQTTConnection("MQTT-Pub-Client", true);
        MQTT mqttSub = this.createMQTTConnection("MQTT-Sub-Client", false);
        BlockingConnection connectionPub = mqttPub.blockingConnection();
        connectionPub.connect();
        BlockingConnection connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        Topic[] topics = new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)};
        connectionSub.subscribe(topics);
        for (int i = 0; i < messagesPerRun; ++i) {
            connectionPub.publish(topics[0].name().toString(), payload, QoS.AT_LEAST_ONCE, false);
        }
        int received = 0;
        for (int i = 0; i < messagesPerRun; ++i) {
            org.fusesource.mqtt.client.Message message = connectionSub.receive(5L, TimeUnit.SECONDS);
            MQTTTest.assertNotNull((Object)message);
            ++received;
            MQTTTest.assertTrue((boolean)Arrays.equals(payload, message.getPayload()));
            message.ack();
        }
        connectionSub.disconnect();
        for (int j = 0; j < numberOfRuns; ++j) {
            int i;
            for (i = 0; i < messagesPerRun; ++i) {
                connectionPub.publish(topics[0].name().toString(), payload, QoS.AT_LEAST_ONCE, false);
            }
            connectionSub = mqttSub.blockingConnection();
            connectionSub.connect();
            connectionSub.subscribe(topics);
            for (i = 0; i < messagesPerRun; ++i) {
                org.fusesource.mqtt.client.Message message = connectionSub.receive(5L, TimeUnit.SECONDS);
                MQTTTest.assertNotNull((Object)message);
                ++received;
                MQTTTest.assertTrue((boolean)Arrays.equals(payload, message.getPayload()));
                message.ack();
            }
            connectionSub.disconnect();
        }
        MQTTTest.assertEquals((String)("Should have received " + messagesPerRun * (numberOfRuns + 1) + " messages"), (long)(messagesPerRun * (numberOfRuns + 1)), (long)received);
    }

    @Test(timeout=30000L)
    public void testDefaultKeepAliveWhenClientSpecifiesZero() throws Exception {
        this.stopBroker();
        this.protocolConfig = "transport.defaultKeepAlive=2000";
        this.startBroker();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setKeepAlive((short)0);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        MQTTTest.assertTrue((String)"KeepAlive didn't work properly", (boolean)Wait.waitFor(() -> connection.isConnected()));
    }

    @Test(timeout=60000L)
    public void testReuseConnection() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("Test-Client");
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
        Thread.sleep(100L);
        connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
        Thread.sleep(100L);
    }

    @Test(timeout=60000L)
    public void testNoMessageReceivedAfterUnsubscribeMQTT() throws Exception {
        int i;
        Topic[] topics = new Topic[]{new Topic("TopicA", QoS.EXACTLY_ONCE)};
        MQTT mqttPub = this.createMQTTConnection("MQTTPub-Client", true);
        MQTT mqttSub = this.createMQTTConnection("MQTTSub-Client", false);
        BlockingConnection connectionPub = mqttPub.blockingConnection();
        connectionPub.connect();
        BlockingConnection connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        connectionSub.subscribe(topics);
        connectionSub.disconnect();
        for (int i2 = 0; i2 < 5; ++i2) {
            String payload = "Message " + i2;
            connectionPub.publish(topics[0].name().toString(), payload.getBytes(), QoS.EXACTLY_ONCE, false);
        }
        connectionSub = mqttSub.blockingConnection();
        connectionSub.connect();
        int received = 0;
        for (i = 0; i < 5; ++i) {
            org.fusesource.mqtt.client.Message message = connectionSub.receive(5L, TimeUnit.SECONDS);
            MQTTTest.assertNotNull((String)("Missing message " + i), (Object)message);
            log.debug("Message is " + new String(message.getPayload()));
            ++received;
            message.ack();
        }
        MQTTTest.assertEquals((long)5L, (long)received);
        connectionSub.unsubscribe(new String[]{"TopicA"});
        for (i = 0; i < 5; ++i) {
            String payload = "Message " + i;
            connectionPub.publish(topics[0].name().toString(), payload.getBytes(), QoS.EXACTLY_ONCE, false);
        }
        MQTTTest.assertNull((Object)connectionSub.receive(100L, TimeUnit.MILLISECONDS));
        connectionSub.disconnect();
        connectionPub.disconnect();
    }

    @Test(timeout=60000L)
    public void testMQTT311Connection() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("foo");
        mqtt.setVersion("3.1.1");
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
    }

    @Test(timeout=60000L)
    public void testPingOnMQTT() throws Exception {
        this.stopBroker();
        this.protocolConfig = "maxInactivityDuration=-1";
        this.startBroker();
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("test-mqtt");
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        MQTTTest.assertTrue((String)"KeepAlive didn't work properly", (boolean)Wait.waitFor(() -> connection.isConnected()));
        connection.disconnect();
    }

    @Test(timeout=60000L)
    public void testClientDisconnectedOnMaxConsumerLimitReached() throws Exception {
        EOFException peerDisconnectedException = null;
        try {
            String clientId = "test.client";
            SimpleString coreAddress = new SimpleString("foo.bar");
            Topic[] mqttSubscription = new Topic[]{new Topic("foo/bar", QoS.AT_LEAST_ONCE)};
            this.getServer().createQueue(new QueueConfiguration(new SimpleString(clientId + "." + coreAddress)).setAddress(coreAddress).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)));
            MQTT mqtt = this.createMQTTConnection();
            mqtt.setClientId(clientId);
            mqtt.setKeepAlive((short)2);
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(mqttSubscription);
        }
        catch (EOFException e) {
            peerDisconnectedException = e;
        }
        MQTTTest.assertNotNull((Object)peerDisconnectedException);
        MQTTTest.assertTrue((boolean)peerDisconnectedException.getMessage().contains("Peer disconnected"));
    }

    @Test(timeout=60000L)
    public void testAnycastPrefixWorksWithMQTT() throws Exception {
        String clientId = "testMqtt";
        String anycastAddress = "anycast:foo/bar";
        String sendAddress = "foo/bar";
        Topic[] mqttSubscription = new Topic[]{new Topic(anycastAddress, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.subscribe(mqttSubscription);
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttSubscription);
        String message1 = "TestMessage1";
        String message2 = "TestMessage2";
        connection1.publish(sendAddress, message1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish(sendAddress, message2.getBytes(), QoS.AT_LEAST_ONCE, false);
        MQTTTest.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNull((Object)connection1.receive(100L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNull((Object)connection2.receive(100L, TimeUnit.MILLISECONDS));
    }

    @Test(timeout=60000L)
    public void testAnycastAddressWorksWithMQTT() throws Exception {
        String anycastAddress = "foo/bar";
        this.getServer().addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"foo.bar"), RoutingType.ANYCAST));
        String clientId = "testMqtt";
        Topic[] mqttSubscription = new Topic[]{new Topic(anycastAddress, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.subscribe(mqttSubscription);
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttSubscription);
        String message1 = "TestMessage1";
        String message2 = "TestMessage2";
        connection1.publish(anycastAddress, message1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish(anycastAddress, message2.getBytes(), QoS.AT_LEAST_ONCE, false);
        MQTTTest.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNull((Object)connection1.receive(100L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNull((Object)connection2.receive(100L, TimeUnit.MILLISECONDS));
    }

    @Test(timeout=60000L)
    public void testAmbiguousRoutingWithMQTT() throws Exception {
        String anycastAddress = "foo/bar";
        EnumSet<RoutingType> routingTypeSet = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        this.getServer().addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)"foo.bar"), routingTypeSet));
        String clientId = "testMqtt";
        Topic[] mqttSubscription = new Topic[]{new Topic(anycastAddress, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.subscribe(mqttSubscription);
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttSubscription);
        String message1 = "TestMessage1";
        String message2 = "TestMessage2";
        connection1.publish(anycastAddress, message1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish(anycastAddress, message2.getBytes(), QoS.AT_LEAST_ONCE, false);
        MQTTTest.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNotNull((Object)connection1.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
        MQTTTest.assertNotNull((Object)connection2.receive(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testRetainedMessagesAreCorrectlyFormedAfterRestart() throws Exception {
        String clientId = "testMqtt";
        String address = "testAddress";
        String payload = "This is a test message";
        this.getServer().addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)address), RoutingType.MULTICAST));
        Topic[] mqttTopic = new Topic[]{new Topic(address, QoS.AT_LEAST_ONCE)};
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId(clientId);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        connection1.publish(address, payload.getBytes(), QoS.AT_LEAST_ONCE, true);
        this.getServer().fail(false);
        this.getServer().start();
        this.waitForServerToStart(this.getServer());
        MQTT mqtt2 = this.createMQTTConnection();
        mqtt2.setClientId(clientId + "2");
        BlockingConnection connection2 = mqtt2.blockingConnection();
        connection2.connect();
        connection2.subscribe(mqttTopic);
        org.fusesource.mqtt.client.Message message = connection2.receive(5000L, TimeUnit.MILLISECONDS);
        MQTTTest.assertEquals((Object)payload, (Object)new String(message.getPayload()));
    }

    @Test(timeout=60000L)
    public void testBrokerRestartAfterSubHashWithConfigurationQueues() throws Exception {
        CoreAddressConfiguration coreAddressConfiguration = new CoreAddressConfiguration();
        coreAddressConfiguration.setName("DLA");
        coreAddressConfiguration.addRoutingType(RoutingType.ANYCAST);
        coreAddressConfiguration.addQueueConfiguration(new QueueConfiguration("DLQ").setAddress("DLA").setRoutingType(RoutingType.ANYCAST));
        this.getServer().getConfiguration().getAddressConfigurations().add(coreAddressConfiguration);
        this.getServer().stop();
        this.getServer().start();
        this.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        for (int i = 0; i < 2; ++i) {
            MQTT mqtt = this.createMQTTConnection("myClient", false);
            BlockingConnection connection = mqtt.blockingConnection();
            connection.connect();
            connection.subscribe(new Topic[]{new Topic("#", QoS.AT_MOST_ONCE)});
            connection.disconnect();
            this.getServer().stop();
            this.getServer().start();
            this.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoubleBroker() throws Exception {
        int port1 = 1884;
        int port2 = 1885;
        Configuration cfg1 = this.createDefaultConfig(1, false);
        cfg1.addAcceptorConfiguration("mqtt1", "tcp://localhost:1884?protocols=MQTT");
        Configuration cfg2 = this.createDefaultConfig(2, false);
        cfg2.addAcceptorConfiguration("mqtt2", "tcp://localhost:1885?protocols=MQTT");
        ActiveMQServer server1 = this.createServer(cfg1);
        server1.start();
        ActiveMQServer server2 = this.createServer(cfg2);
        server2.start();
        String clientId = "client1";
        MQTT mqtt1 = this.createMQTTConnection("client1", true);
        MQTT mqtt2 = this.createMQTTConnection("client1", true);
        mqtt1.setHost("localhost", 1884);
        mqtt2.setHost("localhost", 1885);
        BlockingConnection connection1 = mqtt1.blockingConnection();
        BlockingConnection connection2 = mqtt2.blockingConnection();
        try {
            connection1.connect();
            connection2.connect();
        }
        catch (Exception e) {
            MQTTTest.fail((String)"Connections should have worked.");
        }
        finally {
            if (connection1.isConnected()) {
                connection1.disconnect();
            }
            if (connection2.isConnected()) {
                connection2.disconnect();
            }
        }
    }

    @Test
    public void autoDestroyAddress() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAutoDeleteAddresses(Boolean.valueOf(true));
        this.server.getAddressSettingsRepository().addMatch("foo.bar", (Object)addressSettings);
        MQTTClientProvider subscriptionProvider = this.getMQTTClientProvider();
        this.initializeConnection(subscriptionProvider);
        subscriptionProvider.subscribe("foo/bar", 0);
        MQTTTest.assertNotNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"foo.bar")));
        subscriptionProvider.disconnect();
        MQTTTest.assertNull((Object)this.server.getAddressInfo(SimpleString.toSimpleString((String)"foo.bar")));
    }
}

