/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.Before;
import org.junit.Test;

public class ManagementActivationTest
extends FailoverTestBase {
    private JMSServerManagerImpl backupJmsServer;
    private InVMNamingContext context;
    private String connectorName;

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        TransportConfiguration inVMConnector = TransportConfigurationUtils.getInVMConnector(live);
        this.connectorName = inVMConnector.getName();
        return inVMConnector;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.backupJmsServer = new JMSServerManagerImpl(this.backupServer.getServer());
        this.context = new InVMNamingContext();
        this.backupJmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.context));
        this.backupJmsServer.start();
    }

    @Test
    public void testCreateConnectionFactory() throws Exception {
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add(this.connectorName);
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("test").setConnectorNames(connectorNames).setBindings(new String[]{"/myConnectionFactory"});
        this.backupJmsServer.createConnectionFactory(true, config, new String[]{"/myConnectionFactory"});
        boolean exception = false;
        try {
            this.context.lookup("/myConnectionFactory");
        }
        catch (NameNotFoundException e) {
            exception = true;
        }
        ManagementActivationTest.assertTrue((String)"exception expected", (boolean)exception);
        this.liveServer.crash(new ClientSession[0]);
        long timeout = System.currentTimeMillis() + 5000L;
        ConnectionFactory factory = null;
        while (timeout > System.currentTimeMillis()) {
            try {
                factory = (ConnectionFactory)this.context.lookup("/myConnectionFactory");
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (factory != null) break;
            Thread.sleep(100L);
        }
        ManagementActivationTest.assertNotNull(factory);
    }

    @Test
    public void testCreateQueue() throws Exception {
        this.backupJmsServer.createQueue(false, "myQueue", null, false, new String[]{"/myQueue"});
        boolean exception = false;
        try {
            this.context.lookup("/myQueue");
        }
        catch (NameNotFoundException e) {
            exception = true;
        }
        ManagementActivationTest.assertTrue((String)"exception expected", (boolean)exception);
        this.liveServer.crash(new ClientSession[0]);
        long timeout = System.currentTimeMillis() + 5000L;
        Queue queue = null;
        while (timeout > System.currentTimeMillis()) {
            try {
                queue = (Queue)this.context.lookup("/myQueue");
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (queue != null) break;
            Thread.sleep(100L);
        }
        ManagementActivationTest.assertNotNull(queue);
    }

    @Test
    public void testCreateTopic() throws Exception {
        this.backupJmsServer.createTopic(false, "myTopic", new String[]{"/myTopic"});
        boolean exception = false;
        try {
            this.context.lookup("/myTopic");
        }
        catch (NameNotFoundException e) {
            exception = true;
        }
        ManagementActivationTest.assertTrue((String)"exception expected", (boolean)exception);
        this.liveServer.crash(new ClientSession[0]);
        long timeout = System.currentTimeMillis() + 5000L;
        Topic topic = null;
        while (timeout > System.currentTimeMillis()) {
            try {
                topic = (Topic)this.context.lookup("/myTopic");
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (topic != null) break;
            Thread.sleep(100L);
        }
        ManagementActivationTest.assertNotNull(topic);
    }

    @Test
    public void testDestroyConnectionFactory() throws Exception {
        for (int testrun = 0; testrun < 50; ++testrun) {
            boolean exception = false;
            try {
                this.backupJmsServer.destroyConnectionFactory("fakeConnectionFactory");
            }
            catch (Exception e) {
                exception = true;
            }
            ManagementActivationTest.assertFalse((boolean)exception);
            this.tearDown();
            this.setUp();
        }
    }

    @Test
    public void testRemoveQueue() throws Exception {
        boolean exception = false;
        try {
            this.backupJmsServer.removeQueueFromBindingRegistry("fakeQueue");
        }
        catch (Exception e) {
            exception = true;
        }
        ManagementActivationTest.assertFalse((boolean)exception);
    }

    @Test
    public void testRemoveTopic() throws Exception {
        boolean exception = false;
        try {
            this.backupJmsServer.removeTopicFromBindingRegistry("fakeTopic");
        }
        catch (Exception e) {
            exception = true;
        }
        ManagementActivationTest.assertFalse((boolean)exception);
    }
}

