/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.JMSContext;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Before;
import org.junit.Test;

public class JMSSecurityTest
extends JMSTestBase {
    @Override
    public boolean useSecurity() {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testSecurityOnJMSContext() throws Exception {
        JMSContext ctx2;
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("IDo", "Exist");
        try {
            ctx2 = this.cf.createContext("Idont", "exist");
            ctx2.close();
        }
        catch (JMSSecurityRuntimeException ctx2) {
            // empty catch block
        }
        ctx2 = this.cf.createContext("IDo", "Exist");
        ctx2.close();
    }

    @Test
    public void testCreateQueueConnection() throws Exception {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("IDo", "Exist");
        try {
            QueueConnection queueC = ((QueueConnectionFactory)this.cf).createQueueConnection("IDont", "Exist");
            JMSSecurityTest.fail((String)"supposed to throw exception");
            queueC.close();
        }
        catch (JMSSecurityException queueC) {
            // empty catch block
        }
        JMSContext ctx = this.cf.createContext("IDo", "Exist");
        ctx.close();
    }
}

