/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import java.util.Collections;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationDownstreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationTransformerConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.tests.integration.federation.FederatedAddressTest;
import org.apache.activemq.artemis.tests.integration.federation.FederatedQueueTest;

public class FederatedTestUtil {
    public static FederationConfiguration createAddressFederationConfiguration(String address, int hops) {
        FederationAddressPolicyConfiguration addressPolicyConfiguration = new FederationAddressPolicyConfiguration();
        addressPolicyConfiguration.setName("AddressPolicy" + address);
        addressPolicyConfiguration.addInclude(new FederationAddressPolicyConfiguration.Matcher().setAddressMatch(address));
        addressPolicyConfiguration.setMaxHops(hops);
        FederationConfiguration federationConfiguration = new FederationConfiguration();
        federationConfiguration.setName("default");
        federationConfiguration.addFederationPolicy((FederationPolicy)addressPolicyConfiguration);
        return federationConfiguration;
    }

    public static FederationConfiguration createAddressUpstreamFederationConfiguration(String connector, String address, int hops) {
        FederationUpstreamConfiguration upstreamConfiguration = new FederationUpstreamConfiguration();
        upstreamConfiguration.setName(connector);
        upstreamConfiguration.getConnectionConfiguration().setStaticConnectors(Collections.singletonList(connector));
        upstreamConfiguration.getConnectionConfiguration().setCircuitBreakerTimeout(-1L);
        upstreamConfiguration.addPolicyRef("AddressPolicy" + address);
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressFederationConfiguration(address, hops);
        federationConfiguration.addUpstreamConfiguration(upstreamConfiguration);
        return federationConfiguration;
    }

    public static FederationConfiguration createAddressUpstreamFederationConfiguration(String connector, String address) {
        return FederatedTestUtil.createAddressUpstreamFederationConfiguration(connector, address, 1);
    }

    public static FederationConfiguration createAddressDownstreamFederationConfiguration(String connector, String address, TransportConfiguration transportConfiguration) {
        return FederatedTestUtil.createAddressDownstreamFederationConfiguration(connector, address, transportConfiguration, 1);
    }

    public static FederationConfiguration createAddressDownstreamFederationConfiguration(String connector, String address, TransportConfiguration transportConfiguration, int hops) {
        FederationDownstreamConfiguration downstreamConfiguration = new FederationDownstreamConfiguration();
        downstreamConfiguration.setName(connector);
        downstreamConfiguration.getConnectionConfiguration().setStaticConnectors(Collections.singletonList(connector));
        downstreamConfiguration.getConnectionConfiguration().setCircuitBreakerTimeout(-1L);
        downstreamConfiguration.addPolicyRef("AddressPolicy" + address);
        downstreamConfiguration.setUpstreamConfiguration(transportConfiguration);
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressFederationConfiguration(address, hops);
        federationConfiguration.addDownstreamConfiguration(downstreamConfiguration);
        return federationConfiguration;
    }

    public static FederationConfiguration createAddressDownstreamFederationConfiguration(String connector, String address, String transportConfigurationRef, int hops) {
        FederationDownstreamConfiguration downstreamConfiguration = new FederationDownstreamConfiguration();
        downstreamConfiguration.setName(connector);
        downstreamConfiguration.getConnectionConfiguration().setStaticConnectors(Collections.singletonList(connector));
        downstreamConfiguration.getConnectionConfiguration().setCircuitBreakerTimeout(-1L);
        downstreamConfiguration.addPolicyRef("AddressPolicy" + address);
        downstreamConfiguration.setUpstreamConfigurationRef(transportConfigurationRef);
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressFederationConfiguration(address, hops);
        federationConfiguration.addDownstreamConfiguration(downstreamConfiguration);
        return federationConfiguration;
    }

    public static FederationConfiguration createAddressDownstreamFederationConfiguration(String connector, String address, String transportConfigurationRef) {
        return FederatedTestUtil.createAddressDownstreamFederationConfiguration(connector, address, transportConfigurationRef, 1);
    }

    public static void addAddressTransformerConfiguration(FederationConfiguration federationConfiguration, String address) {
        federationConfiguration.addTransformerConfiguration(new FederationTransformerConfiguration("transformer", new TransformerConfiguration(FederatedAddressTest.TestTransformer.class.getName())));
        FederationAddressPolicyConfiguration policy = (FederationAddressPolicyConfiguration)federationConfiguration.getFederationPolicyMap().get("AddressPolicy" + address);
        policy.setTransformerRef("transformer");
    }

    public static FederationConfiguration createDownstreamFederationConfiguration(String connector, String queueName, Boolean includeFederated, String transportConfigurationRef) {
        return FederatedTestUtil.createQueueDownstreamFederationConfiguration(null, connector, queueName, includeFederated, false, transportConfigurationRef);
    }

    public static FederationConfiguration createQueueDownstreamFederationConfiguration(String name, String connector, String queueName, Boolean includeFederated, boolean shareConnection, String transportConfigurationRef) {
        FederationDownstreamConfiguration downstreamConfiguration = new FederationDownstreamConfiguration();
        downstreamConfiguration.setName(name != null ? name : connector);
        downstreamConfiguration.getConnectionConfiguration().setStaticConnectors(Collections.singletonList(connector));
        downstreamConfiguration.getConnectionConfiguration().setCircuitBreakerTimeout(-1L);
        downstreamConfiguration.getConnectionConfiguration().setShareConnection(shareConnection);
        downstreamConfiguration.addPolicyRef("QueuePolicy" + queueName);
        downstreamConfiguration.setUpstreamConfigurationRef(transportConfigurationRef);
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueFederationConfiguration(connector, queueName, includeFederated);
        federationConfiguration.addDownstreamConfiguration(downstreamConfiguration);
        return federationConfiguration;
    }

    public static FederationConfiguration createQueueDownstreamFederationConfiguration(String connector, String queueName, String transportConfigurationRef) {
        return FederatedTestUtil.createQueueDownstreamFederationConfiguration(null, connector, queueName, null, false, transportConfigurationRef);
    }

    public static FederationConfiguration createQueueUpstreamFederationConfiguration(String connector, String queueName, Boolean includeFederated) {
        FederationUpstreamConfiguration upstreamConfiguration = FederatedTestUtil.createQueueFederationUpstream(connector, queueName);
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueFederationConfiguration(connector, queueName, includeFederated);
        federationConfiguration.addUpstreamConfiguration(upstreamConfiguration);
        return federationConfiguration;
    }

    public static FederationUpstreamConfiguration createQueueFederationUpstream(String connector, String queueName) {
        FederationUpstreamConfiguration upstreamConfiguration = new FederationUpstreamConfiguration();
        upstreamConfiguration.setName("server1-upstream");
        upstreamConfiguration.getConnectionConfiguration().setStaticConnectors(Collections.singletonList(connector));
        upstreamConfiguration.getConnectionConfiguration().setCircuitBreakerTimeout(-1L);
        upstreamConfiguration.addPolicyRef("QueuePolicy" + queueName);
        return upstreamConfiguration;
    }

    public static FederationConfiguration createQueueUpstreamFederationConfiguration(String connector, String queueName) {
        return FederatedTestUtil.createQueueUpstreamFederationConfiguration(connector, queueName, null);
    }

    public static FederationConfiguration createQueueFederationConfiguration(String connector, String queueName, Boolean includeFederated) {
        FederationQueuePolicyConfiguration queuePolicyConfiguration = new FederationQueuePolicyConfiguration();
        queuePolicyConfiguration.setName("QueuePolicy" + queueName);
        queuePolicyConfiguration.addInclude(new FederationQueuePolicyConfiguration.Matcher().setQueueMatch(queueName).setAddressMatch("#"));
        if (includeFederated != null) {
            queuePolicyConfiguration.setIncludeFederated(includeFederated.booleanValue());
        }
        FederationConfiguration federationConfiguration = new FederationConfiguration();
        federationConfiguration.setName("default");
        federationConfiguration.addFederationPolicy((FederationPolicy)queuePolicyConfiguration);
        return federationConfiguration;
    }

    public static void addQueueTransformerConfiguration(FederationConfiguration federationConfiguration, String queueName) {
        federationConfiguration.addTransformerConfiguration(new FederationTransformerConfiguration("transformer", new TransformerConfiguration(FederatedQueueTest.TestTransformer.class.getName())));
        FederationQueuePolicyConfiguration policy = (FederationQueuePolicyConfiguration)federationConfiguration.getFederationPolicyMap().get("QueuePolicy" + queueName);
        policy.setTransformerRef("transformer");
    }
}

