/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.MultipleBackupsFailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.junit.Test;

public class SingleLiveMultipleBackupsFailoverTest
extends MultipleBackupsFailoverTestBase {
    protected Map<Integer, TestableServer> servers = new HashMap<Integer, TestableServer>();
    protected ServerLocatorImpl locator;
    private NodeManager nodeManager;
    final boolean sharedStore = true;

    @Test
    public void testMultipleFailovers() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        this.createLiveConfig(0);
        this.createBackupConfig(0, 1, 0, 2, 3, 4, 5);
        this.createBackupConfig(0, 2, 0, 1, 3, 4, 5);
        this.createBackupConfig(0, 3, 0, 1, 2, 4, 5);
        this.createBackupConfig(0, 4, 0, 1, 2, 3, 5);
        this.createBackupConfig(0, 5, 0, 1, 2, 3, 4);
        this.servers.get(0).start();
        this.waitForServerToStart(this.servers.get(0).getServer());
        this.servers.get(1).start();
        this.waitForServerToStart(this.servers.get(1).getServer());
        this.servers.get(2).start();
        this.servers.get(3).start();
        this.servers.get(4).start();
        this.servers.get(5).start();
        this.locator = (ServerLocatorImpl)this.getServerLocator(0);
        Topology topology = this.locator.getTopology();
        topology.setOwner((Object)"testMultipleFailovers");
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)sf, true);
        this.instanceLog.debug((Object)"failing node 0");
        this.servers.get(0).crash(session);
        session.close();
        int backupNode = this.waitForNewLive(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        this.instanceLog.debug((Object)("failing node " + backupNode));
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewLive(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        this.instanceLog.debug((Object)("failing node " + backupNode));
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewLive(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        this.instanceLog.debug((Object)("failing node " + backupNode));
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewLive(5L, true, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        this.instanceLog.debug((Object)("failing node " + backupNode));
        this.servers.get(backupNode).crash(session);
        session.close();
        backupNode = this.waitForNewLive(5L, false, this.servers, 1, 2, 3, 4, 5);
        session = this.sendAndConsume((ClientSessionFactory)sf, false);
        session.close();
        this.servers.get(backupNode).stop();
        this.locator.close();
    }

    protected void createBackupConfig(int liveNode, int nodeid, int ... nodes) throws Exception {
        TransportConfiguration backupConnector = SingleLiveMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)SingleLiveMultipleBackupsFailoverTest.generateParams((int)nodeid, (boolean)this.isNetty()));
        Configuration config1 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(SingleLiveMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)true, (Map)SingleLiveMultipleBackupsFailoverTest.generateParams((int)nodeid, (boolean)this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).addConnectorConfiguration(backupConnector.getName(), backupConnector).setBindingsDirectory(this.getBindingsDir() + "_" + liveNode).setJournalDirectory(this.getJournalDir() + "_" + liveNode).setPagingDirectory(this.getPageDir() + "_" + liveNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + liveNode);
        String[] staticConnectors = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            TransportConfiguration liveConnector = SingleLiveMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)SingleLiveMultipleBackupsFailoverTest.generateParams((int)nodes[i], (boolean)this.isNetty()));
            config1.addConnectorConfiguration(liveConnector.getName(), liveConnector);
            staticConnectors[i] = liveConnector.getName();
        }
        config1.addClusterConfiguration(SingleLiveMultipleBackupsFailoverTest.basicClusterConnectionConfig((String)backupConnector.getName(), (String[])staticConnectors));
        this.servers.put(nodeid, new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config1, this.nodeManager, nodeid)));
    }

    protected void createLiveConfig(int liveNode) throws Exception {
        TransportConfiguration liveConnector = SingleLiveMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)false, (Map)SingleLiveMultipleBackupsFailoverTest.generateParams((int)liveNode, (boolean)this.isNetty()));
        Configuration config0 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(SingleLiveMultipleBackupsFailoverTest.createTransportConfiguration((boolean)this.isNetty(), (boolean)true, (Map)SingleLiveMultipleBackupsFailoverTest.generateParams((int)liveNode, (boolean)this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(SingleLiveMultipleBackupsFailoverTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])new String[0])).addConnectorConfiguration(liveConnector.getName(), liveConnector).setBindingsDirectory(this.getBindingsDir() + "_" + liveNode).setJournalDirectory(this.getJournalDir() + "_" + liveNode).setPagingDirectory(this.getPageDir() + "_" + liveNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + liveNode);
        SameProcessActiveMQServer server = new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config0, this.nodeManager, liveNode));
        this.addActiveMQComponent(server);
        this.servers.put(liveNode, server);
    }

    @Override
    protected boolean isNetty() {
        return false;
    }
}

