/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReplicatedDistributionTest
extends ClusterTestBase {
    private static final SimpleString ADDRESS = new SimpleString("test.SomeAddress");
    private ClientSession sessionOne;
    private ClientSession sessionThree;
    private ClientConsumer consThree;
    private ClientProducer producer;

    @Test
    public void testRedistribution() throws Exception {
        int received;
        ClientMessage msg;
        int i;
        this.commonTestCode();
        for (i = 0; i < 50; ++i) {
            msg = this.consThree.receive(15000L);
            Assert.assertNotNull((Object)msg);
            received = msg.getIntProperty("key");
            Assert.assertEquals((long)i, (long)received);
            msg.acknowledge();
        }
        this.sessionThree.commit();
        Thread.sleep(500L);
        this.fail(this.sessionThree);
        for (i = 50; i < 100; ++i) {
            msg = this.consThree.receive(15000L);
            Assert.assertNotNull((Object)msg);
            received = (Integer)msg.getObjectProperty(new SimpleString("key"));
            Assert.assertEquals((long)i, (long)received);
            msg.acknowledge();
        }
        Assert.assertNull((Object)this.consThree.receiveImmediate());
        this.sessionThree.commit();
        this.sessionOne.start();
        ClientConsumer consOne = this.sessionOne.createConsumer(ADDRESS);
        Assert.assertNull((Object)consOne.receiveImmediate());
    }

    @Test
    public void testSimpleRedistribution() throws Exception {
        this.commonTestCode();
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.consThree.receive(15000L);
            Assert.assertNotNull((Object)msg);
            int received = msg.getIntProperty("key");
            if (i != received) {
                this.instanceLog.warn((Object)(i + "!=" + received));
            }
            msg.acknowledge();
        }
        this.sessionThree.commit();
        this.sessionOne.start();
        ClientConsumer consOne = this.sessionOne.createConsumer(ADDRESS);
        Assert.assertNull((Object)consOne.receiveImmediate());
    }

    private void commonTestCode() throws Exception {
        this.waitForBindings(3, "test.SomeAddress", 1, 1, true);
        this.waitForBindings(1, "test.SomeAddress", 1, 1, false);
        this.producer = this.sessionOne.createProducer(ADDRESS);
        for (int i = 0; i < 100; ++i) {
            ClientMessage msg = this.sessionOne.createMessage(true);
            msg.putIntProperty(new SimpleString("key"), i);
            this.producer.send((Message)msg);
        }
        this.sessionOne.commit();
    }

    private void fail(ClientSession session) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        session.addFailureListener((SessionFailureListener)new CountDownSessionFailureListener(latch, session));
        RemotingConnection conn = ((ClientSessionInternal)session).getConnection();
        conn.fail((ActiveMQException)new ActiveMQNotConnectedException());
        boolean ok = latch.await(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)ok);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupLiveServer(1, true, this.haType(), true, false);
        this.setupLiveServer(3, true, this.haType(), true, false);
        this.setupBackupServer(2, 3, true, this.haType(), true);
        String address = ADDRESS.toString();
        this.setupClusterConnectionWithBackups("test", address, MessageLoadBalancingType.ON_DEMAND, 1, true, 1, new int[]{3});
        this.setupClusterConnectionWithBackups("test", address, MessageLoadBalancingType.ON_DEMAND, 1, true, 3, new int[]{2, 1});
        this.setupClusterConnectionWithBackups("test", address, MessageLoadBalancingType.ON_DEMAND, 1, true, 2, new int[]{3});
        AddressSettings as = new AddressSettings().setRedistributionDelay(0L);
        for (int i : new int[]{1, 2, 3}) {
            this.getServer(i).getAddressSettingsRepository().addMatch("test.*", (Object)as);
            this.getServer(i).start();
        }
        this.setupSessionFactory(1, -1, true, true);
        this.setupSessionFactory(3, 2, true, true);
        this.sessionOne = this.sfs[1].createSession(true, true);
        this.sessionThree = this.sfs[3].createSession(false, false);
        this.sessionOne.createQueue(new QueueConfiguration(ADDRESS));
        this.sessionThree.createQueue(new QueueConfiguration(ADDRESS));
        this.consThree = this.sessionThree.createConsumer(ADDRESS);
        this.sessionThree.start();
    }

    @Override
    protected ClusterTestBase.HAType haType() {
        return ClusterTestBase.HAType.SharedNothingReplication;
    }
}

