/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.integration.cluster.failover.StaticClusterWithBackupFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class QuorumFailOverTest
extends StaticClusterWithBackupFailoverTest {
    @Rule
    public RetryRule retryRule = new RetryRule(2);

    @Override
    protected void setupServers() throws Exception {
        super.setupServers();
        ((ReplicatedPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicatedPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicatedPolicyConfiguration)this.servers[2].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setGroupName("group0");
        ((ReplicaPolicyConfiguration)this.servers[4].getConfiguration().getHAPolicyConfiguration()).setGroupName("group1");
        ((ReplicaPolicyConfiguration)this.servers[5].getConfiguration().getHAPolicyConfiguration()).setGroupName("group2");
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setVoteRetries(5);
        ((ReplicaPolicyConfiguration)this.servers[3].getConfiguration().getHAPolicyConfiguration()).setVoteRetryWait(500L);
    }

    @Test
    public void testQuorumVoting() throws Exception {
        int[] liveServerIDs = new int[]{0, 1, 2};
        this.setupCluster();
        this.startServers(0, 1, 2);
        new BackupSyncDelay(this.servers[4], this.servers[1], 121);
        this.startServers(3, 4, 5);
        for (int i : liveServerIDs) {
            QuorumFailOverTest.waitForTopology((ActiveMQServer)this.servers[i], (int)3, (int)3);
        }
        this.waitForFailoverTopology(3, 0, 1, 2);
        this.waitForFailoverTopology(4, 0, 1, 2);
        this.waitForFailoverTopology(5, 0, 1, 2);
        for (int i : liveServerIDs) {
            this.setupSessionFactory(i, i + 3, this.isNetty(), false);
            this.createQueue(i, "queues.testaddress", "queue0", null, true);
            this.addConsumer(i, i, "queue0", null);
        }
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        TopologyListener liveTopologyListener = new TopologyListener("LIVE-1");
        this.locators[0].addClusterTopologyListener((ClusterTopologyListener)liveTopologyListener);
        QuorumFailOverTest.assertTrue((String)"we assume 3 is a backup", (boolean)this.servers[3].getHAPolicy().isBackup());
        QuorumFailOverTest.assertFalse((String)"no shared storage", (boolean)this.servers[3].getHAPolicy().isSharedStore());
        this.failNode(0);
        this.waitForFailoverTopology(4, 3, 1, 2);
        this.waitForFailoverTopology(5, 3, 1, 2);
        this.waitForBindings(3, "queues.testaddress", 1, 1, true);
        QuorumFailOverTest.assertTrue((boolean)this.servers[3].waitForActivation(2L, TimeUnit.SECONDS));
        QuorumFailOverTest.assertFalse((String)"3 should have failed over ", (boolean)this.servers[3].getHAPolicy().isBackup());
        this.failNode(1);
        QuorumFailOverTest.assertFalse((String)"4 should have failed over ", (boolean)this.servers[4].getHAPolicy().isBackup());
    }

    @Test
    public void testQuorumVotingLiveNotDead() throws Exception {
        int[] liveServerIDs = new int[]{0, 1, 2};
        this.setupCluster();
        this.startServers(0, 1, 2);
        new BackupSyncDelay(this.servers[4], this.servers[1], 121);
        this.startServers(3, 4, 5);
        ActiveMQComponent[] externalComponents = new ActiveMQComponent[6];
        for (int i = 0; i < 6; ++i) {
            externalComponents[i] = new FakeServiceComponent("server " + i);
            this.servers[i].addExternalComponent(externalComponents[i], true);
        }
        for (int i : liveServerIDs) {
            QuorumFailOverTest.waitForTopology((ActiveMQServer)this.servers[i], (int)3, (int)3);
        }
        this.waitForFailoverTopology(3, 0, 1, 2);
        this.waitForFailoverTopology(4, 0, 1, 2);
        this.waitForFailoverTopology(5, 0, 1, 2);
        for (int i : liveServerIDs) {
            this.setupSessionFactory(i, i + 3, this.isNetty(), false);
            this.createQueue(i, "queues.testaddress", "queue0", null, true);
            this.addConsumer(i, i, "queue0", null);
        }
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobinInSomeOrder(true, 10, 0, 1, 2);
        TopologyListener liveTopologyListener = new TopologyListener("LIVE-1");
        this.locators[0].addClusterTopologyListener((ClusterTopologyListener)liveTopologyListener);
        QuorumFailOverTest.assertTrue((String)"we assume 3 is a backup", (boolean)this.servers[3].getHAPolicy().isBackup());
        QuorumFailOverTest.assertFalse((String)"no shared storage", (boolean)this.servers[3].getHAPolicy().isSharedStore());
        SharedNothingLiveActivation liveActivation = (SharedNothingLiveActivation)this.servers[0].getActivation();
        liveActivation.freezeReplication();
        QuorumFailOverTest.assertFalse((boolean)this.servers[0].isReplicaSync());
        QuorumFailOverTest.waitForRemoteBackupSynchronization((ActiveMQServer)this.servers[0]);
        QuorumFailOverTest.assertTrue((boolean)this.servers[0].isReplicaSync());
        for (ActiveMQComponent component : externalComponents) {
            Assert.assertTrue((String)("component " + component + " is stopped, the web server would been stopped here"), (boolean)component.isStarted());
        }
    }

    @Override
    protected boolean isSharedStorage() {
        return false;
    }

    private static class TopologyListener
    implements ClusterTopologyListener {
        final String prefix;
        final Map<String, Pair<TransportConfiguration, TransportConfiguration>> nodes = new ConcurrentHashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();

        private TopologyListener(String string) {
            this.prefix = string;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            Pair connectorPair = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
            this.nodes.put(topologyMember.getBackupGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)connectorPair);
        }

        public void nodeDown(long eventUID, String nodeID) {
            this.nodes.remove(nodeID);
        }

        public String toString() {
            return "TopologyListener(" + this.prefix + ", #=" + this.nodes.size() + ")";
        }
    }
}

