/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AMQPLargeMessageClusterTest
extends ClusterTestBase {
    private static final int RECEIVE_TIMEOUT_MILLIS = 20000;
    private static final int MESSAGE_SIZE = 0x100000;
    private static final int MESSAGES = 1;
    private final boolean persistenceEnabled;

    @Parameterized.Parameters(name="persistenceEnabled = {0}")
    public static Iterable<? extends Object> persistenceEnabled() {
        return Arrays.asList({true}, {false});
    }

    public AMQPLargeMessageClusterTest(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AMQPLargeMessageClusterTest.deleteDirectory((File)this.temporaryFolder.getRoot());
        this.temporaryFolder.getRoot().mkdirs();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
    }

    protected boolean isNetty() {
        return true;
    }

    @Test(timeout=40000L)
    public void testSendReceiveLargeMessage() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        String queueName = "queues.0";
        this.createQueue(0, "queues.0", "queues.0", null, false, null, null, RoutingType.ANYCAST);
        this.createQueue(1, "queues.0", "queues.0", null, false, null, null, RoutingType.ANYCAST);
        this.waitForBindings(0, "queues.0", 1, 0, true);
        this.waitForBindings(1, "queues.0", 1, 0, true);
        this.waitForBindings(0, "queues.0", 1, 0, false);
        this.waitForBindings(1, "queues.0", 1, 0, false);
        String producerUri = "amqp://localhost:61616";
        JmsConnectionFactory producerFactory = new JmsConnectionFactory(producerUri);
        try (Connection producerConnection = producerFactory.createConnection();
             Session producerSession = producerConnection.createSession(false, 1);){
            producerConnection.start();
            Queue queue = producerSession.createQueue("queues.0");
            String consumerUri = "amqp://localhost:61617";
            JmsConnectionFactory consumerConnectionFactory = new JmsConnectionFactory(consumerUri);
            try (Connection consumerConnection = consumerConnectionFactory.createConnection();
                 Session consumerSession = consumerConnection.createSession(false, 1);
                 MessageConsumer consumer = consumerSession.createConsumer((Destination)queue);
                 MessageProducer producer = producerSession.createProducer((Destination)queue);){
                producer.setDeliveryMode(2);
                consumerConnection.start();
                byte[] largeMessageContent = new byte[0x100000];
                byte[] receivedContent = new byte[largeMessageContent.length];
                ThreadLocalRandom.current().nextBytes(largeMessageContent);
                for (int i = 0; i < 1; ++i) {
                    BytesMessage sentMessage = producerSession.createBytesMessage();
                    sentMessage.writeBytes(largeMessageContent);
                    producer.send((Message)sentMessage);
                    Message receivedMessage = consumer.receive(20000L);
                    Assert.assertNotNull((String)"A message should be received in 20000 ms", (Object)receivedMessage);
                    Assert.assertThat((Object)receivedMessage, (Matcher)IsInstanceOf.instanceOf(sentMessage.getClass()));
                    try {
                        Assert.assertEquals((long)largeMessageContent.length, (long)((BytesMessage)receivedMessage).readBytes(receivedContent));
                        Assert.assertArrayEquals((byte[])largeMessageContent, (byte[])receivedContent);
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
            }
        }
        this.stopServers(0, 1);
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.persistenceEnabled, this.isNetty());
        this.setupServer(1, this.persistenceEnabled, this.isNetty());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }
}

