/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionSendAcknowledgementHandlerTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString address = new SimpleString("address");
    private final SimpleString queueName = new SimpleString("queue");

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testSetInvalidSendACK() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(-1);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(null, null, false, true, true, false, 1);
        boolean failed = false;
        try {
            session.setSendAcknowledgementHandler(new SendAcknowledgementHandler(){

                public void sendAcknowledged(Message message) {
                }
            });
        }
        catch (Throwable expected) {
            failed = true;
        }
        SessionSendAcknowledgementHandlerTest.assertTrue((String)"Expected a failure on setting ACK Handler", (boolean)failed);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
    }

    @Test
    public void testSendAcknowledgementsNoWindowSize() throws Exception {
        this.verifySendAcknowledgements(0);
    }

    @Test
    public void testSendAcknowledgements() throws Exception {
        this.verifySendAcknowledgements(1024);
    }

    @Test
    public void testSendAcknowledgementsNoWindowSizeProducerOnly() throws Exception {
        this.verifySendAcknowledgementsProducerOnly(0);
    }

    @Test
    public void testSendAcknowledgementsProducer() throws Exception {
        this.verifySendAcknowledgementsProducerOnly(1024);
    }

    public void verifySendAcknowledgements(int windowSize) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(windowSize);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(null, null, false, true, true, false, 1);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        ClientProducer prod = session.createProducer(this.address);
        int numMessages = 1000;
        LatchAckHandler handler = new LatchAckHandler("session", new CountDownLatch(1000));
        LatchAckHandler producerHandler = new LatchAckHandler("producer", new CountDownLatch(1000));
        session.setSendAcknowledgementHandler((SendAcknowledgementHandler)handler);
        for (int i = 0; i < 1000; ++i) {
            ClientMessage msg = session.createMessage(false);
            ClientMessage msg2 = session.createMessage(false);
            prod.send((Message)msg);
            prod.send(this.address, (Message)msg2, (SendAcknowledgementHandler)producerHandler);
        }
        Assert.assertTrue((String)("session must have acked, " + handler), (boolean)handler.latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("producer specific handler must have acked, " + producerHandler), (boolean)producerHandler.latch.await(5L, TimeUnit.SECONDS));
    }

    public void verifySendAcknowledgementsProducerOnly(int windowSize) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(windowSize);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(null, null, false, true, true, false, 1);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        ClientProducer prod = session.createProducer(this.address);
        int numMessages = 1000;
        LatchAckHandler producerHandler = new LatchAckHandler("producer", new CountDownLatch(1000));
        for (int i = 0; i < 1000; ++i) {
            ClientMessage msg2 = session.createMessage(false);
            prod.send(this.address, (Message)msg2, (SendAcknowledgementHandler)producerHandler);
        }
        Assert.assertTrue((String)("producer specific handler must have acked, " + producerHandler), (boolean)producerHandler.latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testHandlerOnSend() throws Exception {
        int MSG_COUNT = 750;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(256);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        ClientProducer producer = session.createProducer(this.address);
        AtomicInteger count = new AtomicInteger(0);
        for (int i = 0; i < 750; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((Message)message, message1 -> count.incrementAndGet());
        }
        Wait.assertEquals((int)750, () -> count.get(), (long)2000L, (long)100L);
    }

    @Test
    public void testHandlerOnSendWithAnonymousProducer() throws Exception {
        int MSG_COUNT = 750;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(256);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        AtomicInteger count = new AtomicInteger(0);
        ClientProducer producer = session.createProducer();
        for (int i = 0; i < 750; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send(this.address, (Message)message, message1 -> count.incrementAndGet());
        }
        Wait.assertEquals((int)750, () -> count.get(), (long)2000L, (long)100L);
    }

    @Test
    public void testHandlerOnSession() throws Exception {
        int MSG_COUNT = 750;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(256);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        AtomicInteger count = new AtomicInteger(0);
        session.setSendAcknowledgementHandler(message1 -> count.incrementAndGet());
        ClientProducer producer = session.createProducer(this.address);
        for (int i = 0; i < 750; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send((Message)message);
        }
        Wait.assertEquals((int)750, () -> count.get(), (long)2000L, (long)100L);
    }

    @Test
    public void testHandlerOnSessionWithAnonymousProducer() throws Exception {
        int MSG_COUNT = 750;
        ServerLocator locator = this.createInVMNonHALocator();
        locator.setConfirmationWindowSize(256);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession();
        AtomicInteger count = new AtomicInteger(0);
        session.setSendAcknowledgementHandler(message1 -> count.incrementAndGet());
        ClientProducer producer = session.createProducer();
        for (int i = 0; i < 750; ++i) {
            ClientMessage message = session.createMessage(true);
            producer.send(this.address, (Message)message);
        }
        Wait.assertEquals((int)750, () -> count.get(), (long)2000L, (long)100L);
    }

    public static final class LatchAckHandler
    implements SendAcknowledgementHandler {
        public CountDownLatch latch;
        private final String name;

        public LatchAckHandler(String name, CountDownLatch latch) {
            this.name = name;
            this.latch = latch;
        }

        public void sendAcknowledged(Message message) {
            this.latch.countDown();
        }

        public String toString() {
            return "SendAckHandler(name=" + this.name + ", latch=" + this.latch + ")";
        }
    }
}

