/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class RedeliveryConsumerTest
extends ActiveMQTestBase {
    ActiveMQServer server;
    final SimpleString ADDRESS = new SimpleString("address");
    ClientSessionFactory factory;
    private ServerLocator locator;

    @Test
    public void testRedeliveryMessageStrict() throws Exception {
        this.testDedeliveryMessageOnPersistent(true);
    }

    @Test
    public void testRedeliveryMessageSimpleCancel() throws Exception {
        this.testDedeliveryMessageOnPersistent(false);
    }

    @Test
    public void testDeliveryNonPersistent() throws Exception {
        this.testDelivery(false);
    }

    @Test
    public void testDeliveryPersistent() throws Exception {
        this.testDelivery(true);
    }

    public void testDelivery(boolean persistent) throws Exception {
        int loopAck;
        ClientMessage msg;
        int i;
        this.setUp(true);
        ClientSession session = this.factory.createSession(false, false, false);
        ClientProducer prod = session.createProducer(this.ADDRESS);
        for (int i2 = 0; i2 < 10; ++i2) {
            prod.send((Message)this.createTextMessage(session, Integer.toString(i2), persistent));
        }
        session.commit();
        session.close();
        session = this.factory.createSession(null, null, false, true, true, true, 0);
        session.start();
        for (int loopAck2 = 0; loopAck2 < 5; ++loopAck2) {
            ClientConsumer browser = session.createConsumer(this.ADDRESS, null, true);
            for (i = 0; i < 10; ++i) {
                msg = browser.receive(1000L);
                Assert.assertNotNull((String)("element i=" + i + " loopAck = " + loopAck2 + " was expected"), (Object)msg);
                msg.acknowledge();
                Assert.assertEquals((Object)Integer.toString(i), (Object)this.getTextMessage(msg));
                Assert.assertEquals((long)0L, (long)msg.getDeliveryCount());
            }
            session.commit();
            browser.close();
        }
        session.close();
        session = this.factory.createSession(false, false, false);
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        for (loopAck = 0; loopAck < 5; ++loopAck) {
            for (i = 0; i < 10; ++i) {
                msg = consumer.receive(1000L);
                Assert.assertNotNull((Object)msg);
                Assert.assertEquals((Object)Integer.toString(i), (Object)this.getTextMessage(msg));
                Assert.assertEquals((long)1L, (long)msg.getDeliveryCount());
            }
            session.rollback();
        }
        if (persistent) {
            session.close();
            this.server.stop();
            this.server.start();
            this.factory = this.createSessionFactory(this.locator);
            session = this.factory.createSession(false, false, false);
            session.start();
            consumer = session.createConsumer(this.ADDRESS);
        }
        for (loopAck = 1; loopAck <= 5; ++loopAck) {
            for (i = 0; i < 10; ++i) {
                msg = consumer.receive(1000L);
                Assert.assertNotNull((Object)msg);
                msg.acknowledge();
                Assert.assertEquals((Object)Integer.toString(i), (Object)this.getTextMessage(msg));
                Assert.assertEquals((long)loopAck, (long)msg.getDeliveryCount());
            }
            if (loopAck >= 5) continue;
            if (persistent) {
                session.close();
                this.server.stop();
                this.server.start();
                this.factory = this.createSessionFactory(this.locator);
                session = this.factory.createSession(false, false, false);
                session.start();
                consumer = session.createConsumer(this.ADDRESS);
                continue;
            }
            session.rollback();
        }
        session.close();
    }

    protected void testDedeliveryMessageOnPersistent(boolean strictUpdate) throws Exception {
        this.setUp(strictUpdate);
        ClientSession session = this.factory.createSession(false, false, false);
        this.instanceLog.debug((Object)"created");
        ClientProducer prod = session.createProducer(this.ADDRESS);
        prod.send((Message)this.createTextMessage(session, "Hello"));
        session.commit();
        session.close();
        session = this.factory.createSession(false, false, false);
        session.start();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg = consumer.receive(1000L);
        Assert.assertEquals((long)1L, (long)msg.getDeliveryCount());
        session.stop();
        if (!strictUpdate) {
            session.rollback(true);
            session.close();
        }
        this.server.stop();
        session.close();
        this.server.start();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, false);
        session.start();
        consumer = session.createConsumer(this.ADDRESS);
        msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((long)(strictUpdate ? 2L : 2L), (long)msg.getDeliveryCount());
        session.close();
    }

    @Test
    public void testInfiniteDedeliveryMessageOnPersistent() throws Exception {
        this.internaltestInfiniteDedeliveryMessageOnPersistent(false);
    }

    private void internaltestInfiniteDedeliveryMessageOnPersistent(boolean strict) throws Exception {
        ClientMessage msg;
        ClientConsumer consumer;
        int i;
        this.setUp(strict);
        ClientSession session = this.factory.createSession(false, false, false);
        this.instanceLog.debug((Object)"created");
        ClientProducer prod = session.createProducer(this.ADDRESS);
        prod.send((Message)this.createTextMessage(session, "Hello"));
        session.commit();
        session.close();
        int expectedCount = 1;
        for (i = 0; i < 700; ++i) {
            session = this.factory.createSession(false, false, false);
            session.start();
            consumer = session.createConsumer(this.ADDRESS);
            msg = consumer.receive(5000L);
            RedeliveryConsumerTest.assertNotNull((Object)msg);
            RedeliveryConsumerTest.assertEquals((long)expectedCount, (long)msg.getDeliveryCount());
            if (i % 100 == 0) {
                ++expectedCount;
                msg.acknowledge();
                session.rollback();
            }
            session.close();
        }
        this.factory.close();
        this.server.stop();
        this.setUp(false);
        for (i = 0; i < 700; ++i) {
            session = this.factory.createSession(false, false, false);
            session.start();
            consumer = session.createConsumer(this.ADDRESS);
            msg = consumer.receive(5000L);
            RedeliveryConsumerTest.assertNotNull((Object)msg);
            RedeliveryConsumerTest.assertEquals((long)expectedCount, (long)msg.getDeliveryCount());
            session.close();
        }
        this.server.stop();
        JournalImpl journal = new JournalImpl(this.server.getConfiguration().getJournalFileSize(), 2, 2, 0, 0, (SequentialFileFactory)new NIOSequentialFileFactory(this.server.getConfiguration().getJournalLocation(), 1), "activemq-data", "amq", 1);
        final AtomicInteger updates = new AtomicInteger();
        journal.start();
        journal.load(new LoaderCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }

            public void updateRecord(RecordInfo info) {
                if (info.userRecordType == 34) {
                    updates.incrementAndGet();
                }
            }

            public void deleteRecord(long id) {
            }

            public void addRecord(RecordInfo info) {
            }

            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
            }
        });
        journal.stop();
        RedeliveryConsumerTest.assertEquals((long)7L, (long)updates.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedeliveryCollisionAvoidance() throws Exception {
        this.setUp(false);
        int numberOfThreads = 10;
        long redeliveryDelay = 1000L;
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch(this.ADDRESS.toString())).setRedeliveryDelay(redeliveryDelay).setRedeliveryCollisionAvoidanceFactor(0.5);
        ClientSession session = this.factory.createSession(false, false, false);
        ClientProducer prod = session.createProducer(this.ADDRESS);
        for (int i = 0; i < numberOfThreads; ++i) {
            prod.send((Message)this.createTextMessage(session, "Hello" + i));
        }
        session.commit();
        session.close();
        final CountDownLatch aligned = new CountDownLatch(numberOfThreads);
        final CountDownLatch startRollback = new CountDownLatch(1);
        class ConsumerThread
        extends Thread {
            long delay;
            int errors;

            ConsumerThread(int i) {
                super("RedeliveryCollisionAvoidance::" + i);
                this.delay = 0L;
                this.errors = 0;
            }

            @Override
            public void run() {
                try (ServerLocator locator = RedeliveryConsumerTest.this.createInVMNonHALocator();){
                    locator.setConsumerWindowSize(0);
                    ClientSessionFactory factory = locator.createSessionFactory();
                    ClientSession session = factory.createSession(false, false, false);
                    session.start();
                    ClientConsumer consumer = session.createConsumer(RedeliveryConsumerTest.this.ADDRESS);
                    ClientMessage msg = consumer.receive(5000L);
                    Assert.assertNotNull((Object)msg);
                    msg.acknowledge();
                    aligned.countDown();
                    startRollback.await();
                    session.rollback();
                    long start = System.currentTimeMillis();
                    msg = consumer.receive(5000L);
                    this.delay = System.currentTimeMillis() - start;
                    Assert.assertNotNull((Object)msg);
                    msg.acknowledge();
                    session.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.errors;
                }
            }
        }
        ConsumerThread[] threads = new ConsumerThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new ConsumerThread(i);
            threads[i].start();
        }
        aligned.await();
        startRollback.countDown();
        try {
            for (ConsumerThread t : threads) {
                t.join(60000L);
                RedeliveryConsumerTest.assertFalse((boolean)t.isAlive());
                RedeliveryConsumerTest.assertEquals((String)"There are Errors on the test thread", (long)0L, (long)t.errors);
            }
        }
        finally {
            for (ConsumerThread t : threads) {
                if (t.isAlive()) {
                    t.interrupt();
                }
                t.join(1000L);
            }
        }
        long maxDelay = 0L;
        long minDelay = Long.MAX_VALUE;
        for (ConsumerThread t : threads) {
            if (t.delay < minDelay) {
                minDelay = t.delay;
            }
            if (t.delay <= maxDelay) continue;
            maxDelay = t.delay;
        }
        RedeliveryConsumerTest.assertTrue(((double)(maxDelay - minDelay) > (double)redeliveryDelay * 0.05 ? (byte)1 : 0) != 0);
        this.factory.close();
    }

    private void setUp(boolean persistDeliveryCountBeforeDelivery) throws Exception {
        Configuration config = this.createDefaultInVMConfig().setPersistDeliveryCountBeforeDelivery(persistDeliveryCountBeforeDelivery);
        this.server = this.createServer(true, config);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(this.factory.createSession(false, false, false));
        try {
            session.createQueue(new QueueConfiguration(this.ADDRESS));
        }
        catch (ActiveMQException activeMQException) {
            // empty catch block
        }
        session.close();
    }
}

