/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.balancing;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.management.BrokerBalancerControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.tests.integration.balancing.BalancingTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.Assert;
import org.junit.Test;

public class MQTTRedirectTest
extends BalancingTestBase {
    private final boolean discovery = true;

    @Test
    public void testSimpleRedirect() throws Exception {
        String topicName = "RedirectTestTopic";
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupLiveServerWithDiscovery(1, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupBalancerServerWithDiscovery(0, TargetKey.USER_NAME, "FIRST_ELEMENT", null, false, null, 1);
        this.startServers(0, 1);
        this.getServer(0).createQueue(new QueueConfiguration("RedirectTestTopic").setRoutingType(RoutingType.ANYCAST));
        this.getServer(1).createQueue(new QueueConfiguration("RedirectTestTopic").setRoutingType(RoutingType.ANYCAST));
        QueueControl queueControl0 = (QueueControl)this.getServer(0).getManagementService().getResource("queue.RedirectTestTopic");
        QueueControl queueControl1 = (QueueControl)this.getServer(1).getManagementService().getResource("queue.RedirectTestTopic");
        Assert.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assert.assertEquals((long)0L, (long)queueControl1.countMessages());
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(true);
        connOpts.setUserName("admin");
        connOpts.setPassword("admin".toCharArray());
        MqttClient client0 = new MqttClient("tcp://localhost:61616", "TEST", (MqttClientPersistence)new MemoryPersistence());
        try {
            client0.connect(connOpts);
            Assert.fail();
        }
        catch (MqttException e) {
            Assert.assertEquals((Object)MqttConnectReturnCode.CONNECTION_REFUSED_USE_ANOTHER_SERVER, (Object)MqttConnectReturnCode.valueOf((byte)((byte)e.getReasonCode())));
        }
        client0.close();
        BrokerBalancerControl brokerBalancerControl = (BrokerBalancerControl)this.getServer(0).getManagementService().getResource("brokerbalancer.bb1");
        CompositeData targetData = brokerBalancerControl.getTarget("admin");
        CompositeData targetConnectorData = (CompositeData)targetData.get("connector");
        TabularData targetConnectorParams = (TabularData)targetConnectorData.get("params");
        CompositeData hostData = targetConnectorParams.get(new Object[]{"host"});
        CompositeData portData = targetConnectorParams.get(new Object[]{"port"});
        String host = hostData != null ? (String)hostData.get("value") : "localhost";
        int port = portData != null ? Integer.valueOf((String)portData.get("value")) : 61616;
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList messages = new ArrayList();
        MqttClient client1 = new MqttClient("tcp://" + host + ":" + port, "TEST", (MqttClientPersistence)new MemoryPersistence());
        client1.connect(connOpts);
        Assert.assertEquals((long)0L, (long)queueControl0.countMessages());
        Assert.assertEquals((long)0L, (long)queueControl1.countMessages());
        client1.subscribe("RedirectTestTopic", (s, mqttMessage) -> {
            messages.add(mqttMessage);
            latch.countDown();
        });
        client1.publish("RedirectTestTopic", new MqttMessage("TEST".getBytes()));
        Assert.assertTrue((boolean)latch.await(3000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"TEST", (Object)new String(((MqttMessage)messages.get(0)).getPayload()));
        client1.disconnect();
        client1.close();
        Assert.assertEquals((long)0L, (long)queueControl0.countMessages());
        Wait.assertEquals((long)0L, () -> queueControl1.countMessages());
    }
}

